<?php
/*
Plugin Name: Adaptive Login Action
Plugin URI: https://wpgear.xyz/adaptive-login-action
Description: Compromise between Comfort and Paranoia.
Version: 3.11
Text Domain: adaptive-login-action
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	$AdaptiveLoginAction_plugin_url = plugin_dir_url( __FILE__ ); // со слэшем на конце	
	
	$AdaptiveLoginAction_LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';

	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/admin/admin.php' );
	
	$AdaptiveLoginAction_Message_SecretKeyPlease = 'Secret Key, please!';
	
	/* Init.
	----------------------------------------------------------------- */
	add_action ('init', 'AdaptiveLoginAction_Action_init');
	function AdaptiveLoginAction_Action_init() {
		global $AdaptiveLoginAction_LocalePath;		
		
		load_plugin_textdomain ('adaptive-login-action', false, $AdaptiveLoginAction_LocalePath);
	}	

	/* Login Form - Styles.
	----------------------------------------------------------------- */	
	add_action ('login_enqueue_scripts', 'AdaptiveLoginAction_Action_login_enqueue_scripts' );	
	function AdaptiveLoginAction_Action_login_enqueue_scripts ($hook) {	
		$debug_process = 'login_enqueue_scripts';
		
		$Pagen_Now = $GLOBALS['pagenow'];
		AdaptiveLoginAction_Debugger ($Pagen_Now, '$Pagen_Now', $debug_process, __FUNCTION__, __LINE__);
		
		if ($Pagen_Now == 'wp-login.php') {
			global $AdaptiveLoginAction_plugin_url;			
		
			wp_enqueue_style ('adaptive-login-action_style', $AdaptiveLoginAction_plugin_url .'style.css');	 // phpcs:ignore 
		}
	}		
	
	/* Login Form
	 * \wp-login.php
	----------------------------------------------------------------- */
	add_action('login_form', 'AdaptiveLoginAction_Action_login_form');
	function AdaptiveLoginAction_Action_login_form(){
		$debug_process = 'login_form';
		
		$Options = AdaptiveLoginAction_Get_Options();
		AdaptiveLoginAction_Debugger ($Options, '$Options', $debug_process, __FUNCTION__, __LINE__);
		
		$Option_Enable			= $Options['enable'];
		$Option_SecretKey 		= $Options['secretkey'];
		$Option_WhiteListIP 	= $Options['whitelist_ip'];
		$Option_ZeroTrustMode 	= $Options['zero_trust_mode'];

		$Option_RestrictiveTimeout_Enable 	= $Options['restrictive_timeout_enable'];	
		$Option_RestrictiveTimeout_Limit 	= $Options['restrictive_timeout_limit'];	
		$Option_RestrictiveTimeout_Delay 	= $Options['restrictive_timeout_delay'];
		
		if ($Option_Enable) {
			$Timeout_Delay_Sec = $Option_RestrictiveTimeout_Delay * 60;
			AdaptiveLoginAction_Debugger ($Timeout_Delay_Sec, '$Timeout_Delay_Sec', $debug_process, __FUNCTION__, __LINE__);
			
			$UserIP = AdaptiveLoginAction_GetUserIP();
			AdaptiveLoginAction_Debugger ($UserIP, '$UserIP', $debug_process, __FUNCTION__, __LINE__);
			
			if ($Option_ZeroTrustMode) {
				// Zero Trust Mode
				
				$Trusted = false;		
				
				if ($UserIP) {
					$IP_Options = get_option('adaptive-login-action_ip_' .$UserIP, array());
					AdaptiveLoginAction_Debugger ($IP_Options, '$IP_Options', $debug_process, __FUNCTION__, __LINE__);
					
					if ($Option_RestrictiveTimeout_Enable) {
						$IP_Chain_Errors 	= isset($IP_Options['chain_errors']) ? $IP_Options['chain_errors'] : 0;
						$IP_TimeStamp 		= isset($IP_Options['timestamp']) ? $IP_Options['timestamp'] : 0;
						
						$Threshold = $Option_RestrictiveTimeout_Limit - $IP_Chain_Errors;
						AdaptiveLoginAction_Debugger ($Threshold, '$Threshold', $debug_process, __FUNCTION__, __LINE__);
				
						if ($Threshold == 1) {
							// Осталась 1 Попытка до Блокировки
							?>
							<div class="adaptive-login-action_threshold">
								<?php echo esc_html( __('1 Attempt left before Blocking!', 'adaptive-login-action') ); ?>
							</div>
							<?php
						}
						
						if ($IP_TimeStamp > 0 && $Threshold <= 0 && $Option_RestrictiveTimeout_Delay > 0) {
							// Блокировка IP							
							$TimeStamp_Now = time();
							AdaptiveLoginAction_Debugger ($TimeStamp_Now, '$TimeStamp_Now', $debug_process, __FUNCTION__, __LINE__);
							
							$TimeLeft = $Timeout_Delay_Sec - ($TimeStamp_Now - $IP_TimeStamp);
							AdaptiveLoginAction_Debugger ($TimeLeft, '$TimeLeft', $debug_process, __FUNCTION__, __LINE__);
			
							if ($TimeLeft > 0) {
								$TimeLeft = date("H:i:s", $TimeLeft);
								
								?>
								<div class="adaptive-login-action_blocked">
									<?php echo esc_html( __('Access has been temporarily blocked due to a large number of unsuccessful attempts', 'adaptive-login-action') ); ?>
								</div>
								<div class="adaptive-login-action_blocked_timeout">
									<?php echo esc_html( __('Time left', 'adaptive-login-action') ) .': ' .esc_html( $TimeLeft ) ?>
								</div>

								<div class="adaptive-login-action_security_field_ip">
									IP: <span><?php echo esc_html( $UserIP ); ?></span>
								</div>
								<?php
								
								exit();
								
							} else {
								// Reset
								AdaptiveLoginAction_Update_LoginIP ($UserIP, null);
							}							
						}
					}
					
					$LastOK = isset($IP_Options['last_ok']) ? $IP_Options['last_ok'] : 0;
					
					if ($Option_WhiteListIP && $LastOK == 1) {
						$Option_WhiteListIP = explode(PHP_EOL, $Option_WhiteListIP);
						AdaptiveLoginAction_Debugger ($Option_WhiteListIP, '$Option_WhiteListIP', $debug_process, __FUNCTION__, __LINE__);
						
						foreach ($Option_WhiteListIP as $Item) {
							AdaptiveLoginAction_Debugger ($Item, '$Item', $debug_process, __FUNCTION__, __LINE__);
							
							$Item = trim ($Item);
							$Item = str_replace (array("\r\n", "\n", "\r"), '', $Item);
					
							if ($UserIP == $Item) {						
								$Trusted = true;
							} 
						}
					}
				}

				AdaptiveLoginAction_Debugger ($Trusted, '$Trusted', $debug_process, __FUNCTION__, __LINE__);
				
				if ($Trusted) {
					// Normal Form.
					if ($UserIP) {
						?>
						<div class="adaptive-login-action_trusted_field_ip">
							IP: <span><?php echo esc_html( $UserIP ); ?></span>
						</div>
						<?php			
					}			
				} else {
					// Ext. Security.
					?>
					<p class="adaptive-login-action_field_secretkey">		
						<label for="adaptive-login-action_secretkey"><?php echo esc_html( __('Secret Key', 'adaptive-login-action') ); ?></label>
						<input id="adaptive-login-action_secretkey" name="adaptive-login-action_secretkey" type="password" class="input password-input"/>
					</p>
					<?php
					if ($UserIP) {
						?>
						<div class="adaptive-login-action_security_field_ip">
							IP: <span><?php echo esc_html( $UserIP ); ?></span> <?php echo esc_html( __('will be saved to DB.', 'adaptive-login-action') ); ?>
						</div>
						<?php			
					}			
				}
				
			} else {
				// Dynamics IP Mode.
				
				if ($UserIP) {
					$Login = isset($_REQUEST['log']) ? sanitize_text_field( wp_unslash( $_REQUEST['log'] ) ) : ''; // phpcs:ignore 
					AdaptiveLoginAction_Debugger ($Login, '$Login', $debug_process, __FUNCTION__, __LINE__);
					
					if ($Login) {
						$user = get_user_by ('login', $Login);
						
						if (!$user) {
							$user = get_user_by ('email', $Login);
						}

						if ($user) {
							$User_ID = $user -> ID;

						} else {
							// Нет такого Пользователя. Будем считать его как ID=0
							$User_ID = 0;
						}
						
						AdaptiveLoginAction_Debugger ($User_ID, '$User_ID', $debug_process, __FUNCTION__, __LINE__);
						
						$UserLastLoginData = AdaptiveLoginAction_Get_UserLastLoginData_by_ID ($User_ID);
						AdaptiveLoginAction_Debugger ($UserLastLoginData, '$UserLastLoginData', $debug_process, __FUNCTION__, __LINE__);
						
						$User_LoginErrors		= isset($UserLastLoginData['errors']) ? $UserLastLoginData['errors'] : 0;
						$User_LoginTimeStamp 	= isset($UserLastLoginData['timestamp']) ? $UserLastLoginData['timestamp'] : null;
						$User_LoginLastIP		= isset($UserLastLoginData['last_ip']) ? $UserLastLoginData['last_ip'] : null;
						
						if ($Option_RestrictiveTimeout_Enable) {
							$Threshold = $Option_RestrictiveTimeout_Limit - $User_LoginErrors;
							AdaptiveLoginAction_Debugger ($Threshold, '$Threshold', $debug_process, __FUNCTION__, __LINE__);
						
							if ($Threshold == 1) {
								// Осталась 1 Попытка до Блокировки
								?>
								<div class="adaptive-login-action_threshold">
									<?php echo esc_html( __('1 Attempt left before Blocking!', 'adaptive-login-action') ); ?>
								</div>
								<?php
							}
							
							if ($User_LoginTimeStamp > 0 && $Threshold <= 0 && $Option_RestrictiveTimeout_Delay > 0) {
								// Блокировка User									
								$TimeStamp_Now = time();
								AdaptiveLoginAction_Debugger ($TimeStamp_Now, '$TimeStamp_Now', $debug_process, __FUNCTION__, __LINE__);
								
								$TimeLeft = $Timeout_Delay_Sec - ($TimeStamp_Now - $User_LoginTimeStamp);
								AdaptiveLoginAction_Debugger ($TimeLeft, '$TimeLeft', $debug_process, __FUNCTION__, __LINE__);
		
								if ($TimeLeft > 0) {
									$TimeLeft = date("H:i:s", $TimeLeft);
									
									?>
									<div class="adaptive-login-action_blocked">
										<?php echo esc_html( __('Access has been temporarily blocked due to a large number of unsuccessful attempts', 'adaptive-login-action') ); ?>
									</div>
									<div class="adaptive-login-action_blocked_timeout">
										<?php echo esc_html( __('Time left', 'adaptive-login-action') ) .': ' .esc_html( $TimeLeft ) ?>
									</div>

									<div class="adaptive-login-action_security_field_ip">
										IP: <span><?php echo esc_html( $UserIP ); ?></span>
									</div>
									<?php
									
									exit();
									
								} else {
									// Reset
									AdaptiveLoginAction_Update_UserLastLoginData_by_ID($User_ID, null);
								}
							}
						}
						
						
						// Ext. Security.
						?>
						<p class="adaptive-login-action_field_secretkey">		
							<label for="adaptive-login-action_secretkey"><?php echo esc_html( __('Secret Key', 'adaptive-login-action') ); ?></label>
							<input id="adaptive-login-action_secretkey" name="adaptive-login-action_secretkey" type="password" class="input password-input"/>
						</p>
						<?php
					}
					
					?>
					<div class="adaptive-login-action_neutral_field_ip">
						IP: <span><?php echo esc_html( $UserIP ); ?></span>
					</div>
					<?php			
				}
			}
		} 	
	}	
	
	/* Zero Trust Mode -> Check Secret Key
	----------------------------------------------------------------- */	
	add_filter('wp_authenticate_user', 'AdaptiveLoginAction_Filter_wp_authenticate_user', 10);	
	function AdaptiveLoginAction_Filter_wp_authenticate_user($user) {
		$debug_process = 'wp_authenticate_user';
		
		AdaptiveLoginAction_Debugger ($user, '$user', $debug_process, __FUNCTION__, __LINE__);
		
		$Options = AdaptiveLoginAction_Get_Options();
		AdaptiveLoginAction_Debugger ($Options, '$Options', $debug_process, __FUNCTION__, __LINE__);
		
		$Option_Enable			= $Options['enable'];
		$Option_SecretKey 		= $Options['secretkey'];
		$Option_ZeroTrustMode 	= $Options['zero_trust_mode'];
		
		if ($Option_Enable) {
			if ($Option_ZeroTrustMode) {
				// Zero Trust Mode. Check Secret Key	

				$SecretKey_Input = isset($_REQUEST['adaptive-login-action_secretkey']) ? sanitize_text_field( wp_unslash( $_REQUEST['adaptive-login-action_secretkey'] ) ) : null; // phpcs:ignore
				AdaptiveLoginAction_Debugger ($SecretKey_Input, '$SecretKey_Input', $debug_process, __FUNCTION__, __LINE__);
				
				if (! is_null($SecretKey_Input)) {
					if ($SecretKey_Input != $Option_SecretKey) {				
						$message = __('Authentication Error!', 'adaptive-login-action');
						return new WP_Error ('secret_string_problem', $message);
					}
				}

				if (AdaptiveLoginAction_Check_Plugin_Installed ('new-users-monitor')) {
					// New Users Monitor. Integration.
					if (is_wp_error($user)) {
						global $NUM_Authentication_Msg;
						
						$message = $user -> get_error_message();

						if ($message == $NUM_Authentication_Msg) {
							$Errors = new WP_Error();
							$Errors -> add( 'no_confirm_user', $message );
							return $Errors;
						}
					}
				}
			} else {
				// Dynamics IP Mode.
				
				$SecretKey_Input = isset($_REQUEST['adaptive-login-action_secretkey']) ? sanitize_text_field( wp_unslash( $_REQUEST['adaptive-login-action_secretkey'] ) ) : null; // phpcs:ignore
				AdaptiveLoginAction_Debugger ($SecretKey_Input, '$SecretKey_Input', $debug_process, __FUNCTION__, __LINE__);
				
				if (! is_null($SecretKey_Input)) {
					// Проверяем SecretKey

					if ($SecretKey_Input != $Option_SecretKey) {				
						$message = __('Authentication Error!', 'adaptive-login-action');
						return new WP_Error ('secret_string_problem', $message);
					}
					
				} else {
					// Проверяем LastLogin
					
					$User_ID = $user -> ID;
					AdaptiveLoginAction_Debugger ($User_ID, '$User_ID', $debug_process, __FUNCTION__, __LINE__);
					
					if ($User_ID) {
						$UserLastLoginData = AdaptiveLoginAction_Get_UserLastLoginData_by_ID ($User_ID);
						AdaptiveLoginAction_Debugger ($UserLastLoginData, '$UserLastLoginData', $debug_process, __FUNCTION__, __LINE__);
						
						$User_LoginErrors		= isset($UserLastLoginData['errors']) ? $UserLastLoginData['errors'] : 0;
						$User_LoginTimeStamp 	= isset($UserLastLoginData['timestamp']) ? $UserLastLoginData['timestamp'] : null;
						$User_LoginLastIP		= isset($UserLastLoginData['last_ip']) ? $UserLastLoginData['last_ip'] : null;
		
						if ($User_LoginErrors > 0) {
							global $AdaptiveLoginAction_Message_SecretKeyPlease;
							
							$Error_Key 		= 'adaptive-login-action_last_login_failed';
							$Error_Message 	= $AdaptiveLoginAction_Message_SecretKeyPlease;
							$Error_Data 	= array (
								'user_id' => $User_ID,
							);
							
							// return new WP_Error ($Error_Key, $Error_Message, $Error_Data);
							$Errors = new WP_Error();
							// $Errors -> add( 'no_confirm_user', $Error_Message, $Error_Data );
							$Errors -> add( $Error_Key, $Error_Message, $Error_Data );
							return $Errors;
						}
					}
				}
			}			
		} 

		AdaptiveLoginAction_Debugger ($user, '$user', $debug_process, __FUNCTION__, __LINE__);
		return $user;
	}	
	
	/* After Login. LoginOK
	----------------------------------------------------------------- */	
	add_action('wp_login', 'AdaptiveLoginAction_Action_wp_login', 10, 2);
	function AdaptiveLoginAction_Action_wp_login($User_login, $user) {
		$debug_process = 'wp_login';
		
		AdaptiveLoginAction_Debugger ($User_login, '$User_login', $debug_process, __FUNCTION__, __LINE__);
		AdaptiveLoginAction_Debugger ($user, '$user', $debug_process, __FUNCTION__, __LINE__);
		
		$Options = AdaptiveLoginAction_Get_Options();
		AdaptiveLoginAction_Debugger ($Options, '$Options', $debug_process, __FUNCTION__, __LINE__);
		
		$Option_Enable			= $Options['enable'];
		$Option_ZeroTrustMode 	= $Options['zero_trust_mode'];
		
		if ($Option_Enable) {
			if ($Option_ZeroTrustMode ) {
				// Zero Trust Mode.	
			} else {
				// Dynamics IP Mode.
				
				// Сброс Тригеров Pannic
				$User_ID = $user -> ID;
				AdaptiveLoginAction_Debugger ($User_ID, '$User_ID', $debug_process, __FUNCTION__, __LINE__);
				
				if ($User_ID) {
					$Success = true;
					
					AdaptiveLoginAction_Update_UserLastLoginData_by_ID ($User_ID, $Success);
				}
			}
		}
				
		$Options = AdaptiveLoginAction_Get_Options();
		
		$Option_Enable					= $Options['enable'];
		$Option_WhiteListIP 			= $Options['whitelist_ip'];
		$Option_WhiteListAutoUpdate 	= $Options['whitelist_ip_autoupdate'];
		
		if ($Option_Enable) {
			$UserIP = AdaptiveLoginAction_GetUserIP();
			
			if ($Option_WhiteListAutoUpdate) {
				// Auto Update "White List IP"			
				if ($UserIP) {
					if ($Option_WhiteListIP) {
						if (!preg_match("/$UserIP/", $Option_WhiteListIP)) {
							$Option_WhiteListIP .= "$UserIP,";
							
							$Options['whitelist_ip'] = $Option_WhiteListIP;
							update_option( 'adaptive-login-action_option', $Options ); // phpcs:ignore	
						}
					} else {
						$Option_WhiteListIP = "$UserIP,";
						
						$Options['whitelist_ip'] = $Option_WhiteListIP;
						update_option( 'adaptive-login-action_option', $Options ); // phpcs:ignore				
					}
				}			
			}
			
			if ($UserIP) {
				// Remember the Success of the Login from this IP
				$Success = true;
				
				AdaptiveLoginAction_Update_LoginIP ($UserIP, $Success);
			}
		}		
	}	
		
	/* Login Failed. LoginFailed
	----------------------------------------------------------------- */	
	add_action('wp_login_failed', 'AdaptiveLoginAction_Action_wp_login_failed', 9999, 2);
	function AdaptiveLoginAction_Action_wp_login_failed ($Login, $error){
		$debug_process = 'wp_login_failed';
		
		AdaptiveLoginAction_Debugger ($Login, '$Login', $debug_process, __FUNCTION__, __LINE__);
		AdaptiveLoginAction_Debugger ($error, '$error', $debug_process, __FUNCTION__, __LINE__);
		
		$Options = AdaptiveLoginAction_Get_Options();
		AdaptiveLoginAction_Debugger ($Options, '$Options', $debug_process, __FUNCTION__, __LINE__);
		
		$Option_Enable			= $Options['enable'];
		$Option_ZeroTrustMode 	= $Options['zero_trust_mode'];

		if ($Option_Enable) {
			if ($Option_ZeroTrustMode) {
				// Zero Trust Mode.
				
				$UserIP = AdaptiveLoginAction_GetUserIP();
				AdaptiveLoginAction_Debugger ($UserIP, '$UserIP', $debug_process, __FUNCTION__, __LINE__);
				
				$is_Plugin_NewUsersMonitor_Installed = AdaptiveLoginAction_Check_Plugin_Installed ('new-users-monitor');
				AdaptiveLoginAction_Debugger ($is_Plugin_NewUsersMonitor_Installed, '$is_Plugin_NewUsersMonitor_Installed', $debug_process, __FUNCTION__, __LINE__);
				
				if ($is_Plugin_NewUsersMonitor_Installed) {
					// New Users Monitor. Integration. (Недоделано.)
					$is_User_Confirmed = false;

					$user = get_user_by ('login', $Login);
					
					if (!$user) {
						$user = get_user_by ('email', $Login);
					}

					if ($user) {
						$User_ID = $user -> ID;
						
						$is_User_Confirmed = get_user_meta ($User_ID, 'num_confirm', true);	
						AdaptiveLoginAction_Debugger ($is_User_Confirmed, '$is_User_Confirmed', $debug_process, __FUNCTION__, __LINE__);
					}
				} else {
					$is_User_Confirmed = true;
				}
				
				AdaptiveLoginAction_Debugger ($is_User_Confirmed, '$is_User_Confirmed', $debug_process, __FUNCTION__, __LINE__);
				
				// if ($is_User_Confirmed) {
					if ($UserIP) {
						// Remember the Failed of the Login from this IP
						$Success = false;
						
						AdaptiveLoginAction_Update_LoginIP ($UserIP, $Success);
					}
				// }

			} else {
				// Dynamics IP Mode.
				if( is_wp_error( $error ) ){
					$Error_Codes = $error -> get_error_codes();
					AdaptiveLoginAction_Debugger ($Error_Codes, '$Error_Codes', $debug_process, __FUNCTION__, __LINE__);
					
					foreach( $Error_Codes as $Error_Code ) {
						AdaptiveLoginAction_Debugger ($Error_Code, '$Error_Code', $debug_process, __FUNCTION__, __LINE__);
						
						if ($Error_Code == 'incorrect_password' || $Error_Code == 'invalid_username' || $Error_Code == 'secret_string_problem'){
							$user = get_user_by( 'login', $Login );
							
							if (!$user) {
								$user = get_user_by ('email', $Login);
							}
							
							if ($user) {
								$User_ID = $user -> ID;
								
							} else {
								// Нет такого Пользователя. Будем считать его как ID=0
								$User_ID = 0;
							}
							
							AdaptiveLoginAction_Debugger ($User_ID, '$User_ID', $debug_process, __FUNCTION__, __LINE__);
							
							$Success = false;
							AdaptiveLoginAction_Update_UserLastLoginData_by_ID ($User_ID, $Success);
						}
					}
				}
			}			
		}
	}	
	
	/* Login Errors
	----------------------------------------------------------------- */
	add_filter('login_errors', 'AdaptiveLoginAction_Filter_login_errors');	
	function AdaptiveLoginAction_Filter_login_errors ($Message) {
		$debug_process = 'login_errors';		
		
		AdaptiveLoginAction_Debugger ($Message, '$Message', $debug_process, __FUNCTION__, __LINE__);
		
		global $AdaptiveLoginAction_Message_SecretKeyPlease;
		
		$Message = trim ( sanitize_text_field ($Message) );
		AdaptiveLoginAction_Debugger ($Message, '$Message', $debug_process, __FUNCTION__, __LINE__);
		
		if ($Message == $AdaptiveLoginAction_Message_SecretKeyPlease) {
			$Message = __('Secret Key, please!', 'adaptive-login-action');
		} else {
			$Message = __('Authentication Error!', 'adaptive-login-action');

		}
		
		AdaptiveLoginAction_Debugger ($Message, '$Message', $debug_process, __FUNCTION__, __LINE__);
		return $Message;
	}			