<?php
/*
 * WPGear. Page and Post Description
 * ajax_page-and-post-list.php
 */	 

	$debug_process = 'ajax_processing';

	$PageAndPostDescription_Nonce = 'ajax_page_and_post_description';
	
	$Mode 			= isset($_REQUEST['mode']) ? sanitize_text_field(wp_unslash( $_REQUEST['mode'])) : null; // phpcs:ignore
	$Items_ID		= isset($_REQUEST['items_id']) ? sanitize_text_field(wp_unslash( $_REQUEST['items_id'])) : null; // phpcs:ignore
	$Item_ID		= isset($_REQUEST['item_id']) ? sanitize_text_field(wp_unslash( $_REQUEST['item_id'])) : null; // phpcs:ignore
	$Type 			= isset($_REQUEST['type']) ? sanitize_text_field(wp_unslash( $_REQUEST['type'])) : null; // phpcs:ignore
	$Item_Content 	= isset($_REQUEST['note']) ? sanitize_text_field(wp_unslash( $_REQUEST['note'])) : '';	 // phpcs:ignore
	
	$WP_Nonce 		= isset($_REQUEST['_wpnonce']) ? sanitize_text_field (wp_unslash( $_REQUEST['_wpnonce']) ) : 'none'; // phpcs:ignore
	
	PageAndPostDescription_Debugger ($_REQUEST, '$_REQUEST', $debug_process, __FUNCTION__, __LINE__); // phpcs:ignore
	
	// if (!wp_verify_nonce($WP_Nonce, $PageAndPostDescription_Nonce)) {
	if ($WP_Nonce != $PageAndPostDescription_Nonce) {
		exit;
	}	

	global $PageAndPostDescription_plugin_url;	

	$Notes = array();
	
	$Result = false; 
	
	// get_description
	if ($Mode == 'get_description') {		
		if ($Items_ID) {
			global $wpdb;
			$PageAndPostDescription_PostMeta_table = $wpdb -> prefix .'postmeta';				
			
			$Items_ID_Array = explode(',', $Items_ID);
			
			// Prepare Query
			$Count_Items = count($Items_ID_Array);			
			$ListID = array_fill(0, $Count_Items, '%d');
			$ListID = implode( ', ', $ListID);			
				
			if ($Type == 'page' || $Type == 'post') {
				//Pages	& Posts	
				
				$Query = "SELECT post_id as ID, meta_value as MetaData FROM " .$PageAndPostDescription_PostMeta_table ." WHERE post_id IN ($ListID) AND meta_key = 'pnpd_metadata'";  // phpcs:ignore
				$Records = $wpdb -> get_results ($wpdb -> prepare ($Query, $Items_ID_Array)); // phpcs:ignore					

				foreach ($Items_ID_Array as $ID) {
					$Note_Description 	= '';
					$Note_User 			= '';
					$Note_Date 			= '';
					
					foreach ($Records as $Record) {
						$Record_ID 		= $Record -> ID;
						$Item_MetaData 	= $Record -> MetaData;
						
						if ($ID == $Record_ID) {
							if ($Item_MetaData) {
								$Item_MetaData_Array = unserialize (trim ($Item_MetaData));								
								
								$Note_User 			= $Item_MetaData_Array['user'];
								$Note_Description 	= $Item_MetaData_Array['content'];
								$Note_Date 			= $Item_MetaData_Array['date'];	
							}
						}					
					}					
					
					$Meta = array (
						'id' 	=> $ID,
						'note' 	=> $Note_Description,
						'date' 	=> $Note_Date,
						'user' 	=> $Note_User,
					);
					
					$Notes[] = $Meta;
				}
			}
		}
		
		$Result = true;	
	}
	
	// Save
	if ($Mode == 'save_description') {
		if ($Item_ID) {
			$Date = current_time('d.m.Y');
			
			$current_user = wp_get_current_user();	
			$User_Name = $current_user -> user_login;	

			$Item_MetaData = array(
				'user' => $User_Name,
				'content' => $Item_Content,
				'date' => $Date
			);			

			update_post_meta ($Item_ID, 'pnpd_metadata', $Item_MetaData);
			
			$Result = true;
		}
	}
	
	$Obj_Request = new stdClass();
	$Obj_Request->status 	= 'OK';
	$Obj_Request->answer 	= $Result;
	$Obj_Request->notes 	= $Notes;

	wp_send_json($Obj_Request);    

	die; // Complete.