<?php
/*
 * WPGear. Page and Post Description
 * functions.php
 */
 
	/* Check is Page-List
	----------------------------------------------------------------- */	
	function PageAndPostDescription_is_Page_ListPost ($screen_base) {
		$Result = false;

		global $PageAndPostDescription_Options;

		$PageAndPostDescription_Enable = (isset($PageAndPostDescription_Options['page_enable'])) ? intval($PageAndPostDescription_Options['page_enable']) : 1;	
		
		if ($PageAndPostDescription_Enable) {
			if ($screen_base == 'edit') {
				if (isset($_REQUEST['post_type']) && $_REQUEST['post_type'] == 'page') { // phpcs:ignore
					$Result = true;
				}
			}	
		}
		
		return $Result;
	}

	/* Check is Post-List
	----------------------------------------------------------------- */	
	function PageAndPostDescription_is_Post_ListPost ($screen_base) {
		$Result = false;

		global $PageAndPostDescription_Options;

		$PageAndPostDescription_Enable = (isset($PageAndPostDescription_Options['post_enable'])) ? intval($PageAndPostDescription_Options['post_enable']) : 1;	
		
		if ($PageAndPostDescription_Enable) {		
			if ($screen_base == 'edit') {
				if (empty($_REQUEST)) { // phpcs:ignore
					$Result = true;
				}
			}	
		}
		
		return $Result;
	}	
	
	/* Check Plugin Installed
	----------------------------------------------------------------- */		
	function PageAndPostDescription_Check_Plugin_Installed ($Plugin_Slug = null) {
		$Result = false;
		
		if ($Plugin_Slug) {
			if (! function_exists ('get_plugins')) {
				require_once ABSPATH . 'wp-admin/includes/plugin.php';
			}
			
			$Plugins = get_plugins();
			
			foreach ($Plugins as $Plugin) {
				$Plugin_TextDomain = $Plugin['TextDomain'];
				if ($Plugin_TextDomain == $Plugin_Slug) {
					$Result = true;
				}
			}			
		}	
		
		return $Result;
	}
	
	/* Debugger. 
	----------------------------------------------------------------- */
	function PageAndPostDescription_Debugger ($Content, $Subject = null, $Process = null, $Function = '', $Line = '') {
		if (function_exists( 'WPGear_Debugger' )) {
			$Source = 'PAPD';
			$Description = 'Plugin: PageAndPostDescription';
			
			$TimeStamp = true;
			
			$Parameters = array(
				'source' => $Source,
				'description' => $Description,
				'content' => $Content,
				'subject' => esc_html( $Subject ),
				'process' => esc_html( $Process ),
				'function' => esc_html( $Function ),
				'timestamp' => $TimeStamp,
				'line' => esc_html( $Line ),
			);
			
			WPGear_Debugger ($Parameters);
		}
	}		