<?php
/*
Plugin Name: Page and Post Description
Plugin URI: https://wpgear.xyz/page-and-post-description/
Description: Description for each Page and Post. Check out the features of the PRO version: <a href="https://wpgear.xyz/page-and-post-description-pro/">"Page and Post Description PRO"</a>.
Version: 1.6
Text Domain: page-and-post-description
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	$PageAndPostDescription_plugin_url = plugin_dir_url( __FILE__); 	// со слэшем на конце
	$PageAndPostDescription_plugin_dir = plugin_dir_path( __FILE__);	// со слэшем на конце	
	
	$PageAndPostDescription_Options = get_option("page-and-post-description_options", array(
		'adminonly' => 1,
		'show_author' => 0,
		'show_date' => 0,
		'page_enable' => 1,
		'post_enable' => 1
		)
	);	
	
	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/init.php' );
	include_once( __DIR__ .'/includes/admin.php' );
	
	$PageAndPostDescription_LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';
	// __('Description for each Page and Post. Check out the features of the PRO version: <a href="https://wpgear.xyz/page-and-post-description-pro/">"Page and Post Description PRO"</a>.', 'page-and-post-description');	
	
	/* Init.
	----------------------------------------------------------------- */
	add_action ('init', 'PageAndPostDescription_Action_init');
	function PageAndPostDescription_Action_init() {
		// Translate.
		global $PageAndPostDescription_LocalePath;
				
		$Result = load_plugin_textdomain ('page-and-post-description', false, $PageAndPostDescription_LocalePath);
	}	
	
	/* Admin Console - Styles.
	----------------------------------------------------------------- */	
	add_action ('admin_enqueue_scripts', 'PageAndPostDescription_admin_style' );
	function PageAndPostDescription_admin_style ($hook) {
		global $PageAndPostDescription_plugin_url;
		global $PageAndPostDescription_Options;
		
		$screen = get_current_screen();
		$screen_base = $screen->base;			
		
		if (PageAndPostDescription_is_Page_ListPost ($screen_base) || PageAndPostDescription_is_Post_ListPost ($screen_base)) {
			$PageAndPostDescription_Setup_ShowAuthor = (isset($PageAndPostDescription_Options['show_author'])) ? intval($PageAndPostDescription_Options['show_author']) : 1;
			$PageAndPostDescription_Setup_ShowDate 	= (isset($PageAndPostDescription_Options['show_date'])) ? intval($PageAndPostDescription_Options['show_date']) : 1;
			
			$current_user = wp_get_current_user();	
			$User_Name = $current_user -> user_login;	
			
			wp_enqueue_style ('page-and-post-list', $PageAndPostDescription_plugin_url .'admin-style.css'); // phpcs:ignore
			wp_enqueue_script ('page-and-post-list', $PageAndPostDescription_plugin_url .'includes/post-list.js'); // phpcs:ignore
			
			wp_localize_script ('page-and-post-list', 'PageAndPostDescription_VarObject', array( 
				'user' => $User_Name,
				'show_author' => $PageAndPostDescription_Setup_ShowAuthor,
				'show_date' => $PageAndPostDescription_Setup_ShowDate,
			));	
		}	
	}
	
	/* AJAX Processing
	----------------------------------------------------------------- */    
    add_action( 'wp_ajax_page_and_post_description', 'PageAndPostDescription_Ajax' );
	function PageAndPostDescription_Ajax(){		
		include_once ('includes/ajax_page-and-post-list.php');
    }	