<?php
/*
 * WPGear. 
 * No Active for GravityForms
 * options.php
 */
 
	$NoActiveGF_Nonce = 'Update_Options No Active for GravityForms';
	$nonce = wp_create_nonce ($NoActiveGF_Nonce);
	
	$NoActiveGF_Options = NoActiveGF_Get_Options();
	
	$NoActiveGF_Option_Setup_AdminOnly 	= (isset($NoActiveGF_Options['adminonly'])) ? intval($NoActiveGF_Options['adminonly']) : 1;
	$NoActiveGF_Option_Setup_MsgDefault = $NoActiveGF_Options['msg_default'];
	$WP_Nonce = isset($_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : 'none';
	
	if ($NoActiveGF_Option_Setup_AdminOnly) {
		if (!current_user_can('edit_dashboard')) {
			?>
			<div class="noactivegf_options_warning">
				<?php echo esc_html( __('Sorry, you are not allowed to view this page.', 'noactive-for-gravityforms') ); ?>
			</div>
			<?php
			
			return;
		}		
	}
	
	$NoActiveGF_Action = isset($_REQUEST['action']) ? sanitize_text_field( wp_unslash( $_REQUEST['action'] ) ) : null; 
	
	if ($NoActiveGF_Action == 'update') {
		if (!wp_verify_nonce($WP_Nonce, $NoActiveGF_Nonce)) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="wdpq_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'noactive-for-gravityforms') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}
		
		// Save Options.
		$NoActiveGF_Option_Setup_AdminOnly 	= isset($_REQUEST['noactivegf_option_adminonly']) ? 1 : 0;
		$NoActiveGF_Option_Setup_MsgDefault = isset($_REQUEST['noactivegf_option_msg_default']) ? sanitize_text_field( wp_unslash( $_REQUEST['noactivegf_option_msg_default'] ) ) : '';
		
		$NoActiveGF_Options = array(
			'adminonly' => $NoActiveGF_Option_Setup_AdminOnly,	
			'msg_default' => $NoActiveGF_Option_Setup_MsgDefault,	
		);	
		
		update_option ('noactivegf_options', $NoActiveGF_Options); // phpcs:ignore				
	}		

	?>
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
		<hr>
		
		<div style="margin-left: 20px;">			
			<form name="form_NoActiveGF_Options" method="post" style="margin-top: 20px;">
				<h3><?php echo esc_html( __('General', 'noactive-for-gravityforms') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<div style="margin-top: 10px;">
						<label for="noactivegf_option_adminonly" title="On/Off">
							<?php echo esc_html( __('Enable this Page for Admin only', 'noactive-for-gravityforms') ); ?>
						</label>
						<input id="noactivegf_option_adminonly" name="noactivegf_option_adminonly" type="checkbox" <?php if($NoActiveGF_Option_Setup_AdminOnly) {echo 'checked';} ?>>
					</div>	
					
					<div style="margin-top: 10px;">
						<label for="noactivegf_option_msg_default" title="Default Message for all Gforms.">
							<?php echo esc_html( __('Default Message for all Gforms', 'noactive-for-gravityforms') ); ?>
						</label>
						<input id="noactivegf_option_msg_default" name="noactivegf_option_msg_default" type="text" placeholder="Form not Active!" style="width: calc(100% - 194px);" value="<?php echo esc_attr( $NoActiveGF_Option_Setup_MsgDefault ); ?>">
					</div>				
				</div>

				<div style="margin-top: 10px; margin-bottom: 5px; text-align: right;">
					<input id="noactivegf_btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_attr( __('Save', 'noactive-for-gravityforms') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="update">	
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($nonce); ?>">					
			</form>
		</div>			
	</div>
