<?php
/*
Plugin Name: No Active for GravityForms
Plugin URI: https://wpgear.xyz/noactive-for-gravityforms
Description: Displays a Message that the Form is not Active, instead of a blank page. Read about <a href="https://wpgear.xyz/noactive-for-gravityforms-pro/">PRO Version</a> for Separate Messages & Control for each Forms.
Version: 2.2
Text Domain: noactive-for-gravityforms
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	$NoActiveGF_plugin_url = plugin_dir_url( __FILE__ );		// со слэшем на конце
	$NoActiveGF_plugin_dir = plugin_dir_path( __FILE__ );	// со слэшем на конце
	
	$NoActiveGF_LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';
	__('Displays a Message that the Form is not Active, instead of a blank page. Read about <a href="https://wpgear.xyz/noactive-for-gravityforms-pro/">PRO Version</a> for Separate Messages & Control for each Forms.', 'noactive-for-gravityforms');	
	
	include_once(__DIR__ .'/includes/functions.php');
	include_once(__DIR__ .'/includes/admin/admin.php');
	
		/* Translate.
	----------------------------------------------------------------- */
	add_action ('plugins_loaded', 'NoActiveGF_Action_plugins_loaded');
	function NoActiveGF_Action_plugins_loaded() {
		global $NoActiveGF_LocalePath;
				
		$Result = load_plugin_textdomain ('noactive-for-gravityforms', false, $NoActiveGF_LocalePath);		
	}

	/* ShortCode [gravityform] filter.
	----------------------------------------------------------------- */		
	add_filter ('gform_shortcode_form', 'NoActiveGF_Filter_gform_shortcode_form', 10, 3);
	function NoActiveGF_Filter_gform_shortcode_form ($shortcode_string, $attributes, $content) {
		$NoActiveGF_Options = NoActiveGF_Get_Options();
		
		$NoActiveGF_Option_Setup_MsgDefault = $NoActiveGF_Options['msg_default'];
		
		$Form_ID = $attributes['id'];

		$Form = GFAPI::get_form( $Form_ID );
		
		$Form_Active = $Form['is_active'];
		
		if (! $Form_Active) {
			$shortcode_string = "<div class='noactivegf_warning'>" .esc_html( $NoActiveGF_Option_Setup_MsgDefault ) ."</div>";
		}
		
		return $shortcode_string;
	}