<?php
/*
 * WPGear. 
 * Org. Departments
 * options.php
 */
 
	$OrgDepartments_Nonce = 'Update_Options Org. Departments';
	$nonce = wp_create_nonce ($OrgDepartments_Nonce);
	
	$OrgDepartments_Action 			= isset($_REQUEST['action']) ? sanitize_text_field( wp_unslash( $_REQUEST['action'] ) ) : null;
	$OrgDepartments_Setup_AdminOnly = isset($_REQUEST['orgdepartments_option_adminonly']) ? 1 : 0;	
	$OrgDepartments_SortBy 			= isset($_REQUEST['orgdepartments_option_sortby']) ? sanitize_text_field( wp_unslash( $_REQUEST['orgdepartments_option_sortby'] ) ) : 'name';
	$OrgDepartments_Users_Column 	= isset($_REQUEST['orgdepartments_option_users_column']) ? 1 : 0;	
	$OrgDepartments_Clearing 		= isset($_REQUEST['orgdepartments_option_clearing']) ? 1 : 0;	
	$WP_Nonce 						= isset($_REQUEST['_wpnonce']) ? sanitize_text_field (wp_unslash($_REQUEST['_wpnonce'])) : 'none';
		
	if ($OrgDepartments_Action == 'Update') {
		if (!wp_verify_nonce($WP_Nonce, $OrgDepartments_Nonce)) {
			?>
				<div class="wrap">
					<h2><?php echo get_admin_page_title() ?></h2>
					<hr>
					<div class="wdpq_options_box">						
						<?php echo __('Warning! Data Incorrect. Update Disable.', 'org-departments'); ?>
					</div>
				</div>
			<?php
			
			exit;
		}
		
		$options = array (
			'adminonly' 	=> $OrgDepartments_Setup_AdminOnly,
			'sortby' 		=> $OrgDepartments_SortBy,
			'users_column' 	=> $OrgDepartments_Users_Column,
			'clearing' 		=> $OrgDepartments_Clearing,
		);

		update_option('orgdepartments_options', $options); // phpcs:ignore
	} 
	
	$OrgDepartments_Options = OrgDepartments_Get_Options();
	
	$OrgDepartments_Setup_AdminOnly = isset($OrgDepartments_Options['adminonly']) ? 1 : 0;
	$OrgDepartments_SortBy 			= isset($OrgDepartments_Options['sortby']) ? $OrgDepartments_Options['sortby'] : 'name';
	$OrgDepartments_Users_Column 	= isset($OrgDepartments_Options['users_column']) ? 1 : 0;	
	$OrgDepartments_Clearing 		= isset($OrgDepartments_Options['clearing']) ? 1 : 0;	
	
	if ($OrgDepartments_Options['adminonly']) {
		if (!current_user_can('edit_dashboard')) {
			?>
			<div class="orgdepartments_warning" style="margin: 40px;">
				<?php echo __('Sorry, you are not allowed to view this page.', 'org-departments'); ?>
			</div>
			<?php
			
			return;
		}		
	}
	
	?>
	<div class="wrap">
		<h2><?php echo get_admin_page_title() ?></h2>
		<hr>
		
		<div class="orgdepartments_options_box">
			<form name="form_OrgDepartments_Options" method="post" style="margin-top: 20px;">
				<h3><?php echo __('General', 'org-departments'); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<div style="margin-top: 10px;">
						<label for="orgdepartments_option_adminonly" title="On/Off">
							<?php echo __('Enable this Page for Admin only', 'org-departments'); ?>
						</label>
						<input id="orgdepartments_option_adminonly" name="orgdepartments_option_adminonly" type="checkbox" <?php if($OrgDepartments_Setup_AdminOnly) {echo 'checked';} ?>>
					</div>
				</div>
				
				<hr>
				
				<h3><?php echo __('Admin Page: "Users"', 'org-departments'); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">					

					<div style="margin-top: 10px; margin-left: 24px;">
						<label for="orgdepartments_option_users_column" title="On/Off">
							<?php echo __('Show "Department" Column', 'org-departments'); ?>
						</label>
						<input id="orgdepartments_option_users_column" name="orgdepartments_option_users_column" type="checkbox" <?php if($OrgDepartments_Users_Column ) {echo 'checked';} ?>>
					</div>					

					<div style="margin-top: 10px; margin-left: 38px;">
						<?php echo __('Sort Departments Tree by:', 'org-departments'); ?>
						<div style="margin-left: 152px;">
							<div>
								<input id="orgdepartments_option_sortby_name" name="orgdepartments_option_sortby" type="radio" value="name" <?php if($OrgDepartments_SortBy == 'name') {echo 'checked';} ?>>
								<label for="orgdepartments_option_sortby_name"><?php echo __('Name', 'org-departments'); ?></label>
							</div>
							<div style="margin-top: 5px;">
								<input id="orgdepartments_option_sortby_id" name="orgdepartments_option_sortby" type="radio" value="term_id" <?php if($OrgDepartments_SortBy == 'term_id') {echo 'checked';} ?>>
								<label for="orgdepartments_option_sortby_id"><?php echo __('ID (term_id)', 'org-departments'); ?></label>
							</div>					
						</div>
					</div>
				</div>
				
				<hr>
				
				<h3><?php echo __('Clearing', 'org-departments'); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">				
					<div style="margin-top: 20px;">
						<label for="orgdepartments_option_clearing" title="On/Off">
							<?php echo __('Delete MetaData with Uninstall Plugin.', 'org-departments'); ?>
						</label>
						<input id="orgdepartments_option_clearing" name="orgdepartments_option_clearing" type="checkbox" <?php if($OrgDepartments_Clearing) {echo 'checked';} ?>>
					</div>
				</div>

				<hr>
				<div style="margin-top: 10px; margin-bottom: 5px; text-align: right;">
					<input id="orgdepartments_btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo __('Save', 'org-departments'); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="Update">
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($nonce); ?>">	
			</form>
		</div>	
	</div>
