<?php
/*
* Decimal Product Quantity for WooCommerce
* Admin Product Setup Page.
* admin_setup_product.php
*/

	/* WooCommerce Product Setup Page. | Вкладка "General"
	 * Добавляем опции: "Mинимальное / Максимальное кол-во Товара, Шаг изменения кол-ва и Количество по-умалчанию".
	 * Если не указано, то будет как в Глобальных Настройках.
	----------------------------------------------------------------- */		
	add_action ('woocommerce_product_options_general_product_data', 'WooDecimalProduct_Tab_General_add_Options');
	function WooDecimalProduct_Tab_General_add_Options() {
		global $WooDecimalProduct_Min_Quantity_Default;
        global $WooDecimalProduct_Step_Quantity_Default; 
		global $WooDecimalProduct_Item_Quantity_Default; 
		global $WooDecimalProduct_Max_Quantity_Default;
	
		echo '<div class="options_group">';
 		echo '<div style="margin-top: 10px; margin-left: 10px;"><span style="font-weight: bold;">Quantity Options</span><span style="margin-left: 10px;">(* If not specified, it will be as in <a target="_blank" href="/wp-admin/edit.php?post_type=product&page=decimal-product-quantity-for-woocommerce/includes/options.php">Global Settings.</a>)</span></div>';
		
		woocommerce_wp_text_input( 
			array( 
				'id'          => 'woodecimalproduct_min_qnt', 
				'label'       => 'Minimum', 
				'placeholder' => $WooDecimalProduct_Min_Quantity_Default,
				'desc_tip'    => 'true',
				'description' => "Set the Min of changing the quantity: 0.1 0.5 100 e.t.c (Default = $WooDecimalProduct_Min_Quantity_Default)"
			)
		);
		
		woocommerce_wp_text_input( 
			array( 
				'id'          => 'woodecimalproduct_item_qnt', 
				'label'       => 'Default Set', 
				'placeholder' => $WooDecimalProduct_Item_Quantity_Default,
				'desc_tip'    => 'true',
				'description' => "Set the Default quantity: 0.1 0.5 100 e.t.c (Default = $WooDecimalProduct_Item_Quantity_Default)"
            )
		);		

		woocommerce_wp_text_input( 
			array( 
				'id'          => 'woodecimalproduct_step_qnt', 
				'label'       => 'Step change +/-', 
				'placeholder' => $WooDecimalProduct_Step_Quantity_Default,
				'desc_tip'    => 'true',
				'description' => "Set the Step of changing the quantity: 0.1 0.5 100 e.t.c (Default = $WooDecimalProduct_Step_Quantity_Default)"
            )
		);

		woocommerce_wp_text_input( 
			array( 
				'id'          => 'woodecimalproduct_max_qnt', 
				'label'       => 'Maximum', 
				'placeholder' => $WooDecimalProduct_Max_Quantity_Default,
				'desc_tip'    => 'true',
				'description' => "Set the Max of changing the quantity: 0.1 0.5 100 e.t.c (or leave blank)"
			)
		);
				
		echo '</div>';      	
	} 
	
	/* Сохраняем "Опции кол-ва Товара" для данного Товара.
	----------------------------------------------------------------- */	
	add_action ('woocommerce_process_product_meta', 'WooDecimalProduct_save_product_field_step_Qnt');	
	function WooDecimalProduct_save_product_field_step_Qnt ($post_id) {	
        $new_min_Qnt    = isset($_POST['woodecimalproduct_min_qnt']) ? sanitize_text_field ($_POST['woodecimalproduct_min_qnt']): 1;
        $new_step_Qnt   = isset($_POST['woodecimalproduct_step_qnt']) ? sanitize_text_field ($_POST['woodecimalproduct_step_qnt']): 1;  
		$new_dft_Qnt    = isset($_POST['woodecimalproduct_item_qnt']) ? sanitize_text_field ($_POST['woodecimalproduct_item_qnt']): 1;
		$new_max_Qnt	= isset($_POST['woodecimalproduct_max_qnt']) ? sanitize_text_field ($_POST['woodecimalproduct_max_qnt']): '';
		
		update_post_meta ($post_id, 'woodecimalproduct_min_qnt', $new_min_Qnt);
		update_post_meta ($post_id, 'woodecimalproduct_step_qnt', $new_step_Qnt);
		update_post_meta ($post_id, 'woodecimalproduct_item_qnt', $new_dft_Qnt);	
		update_post_meta ($post_id, 'woodecimalproduct_max_qnt', $new_max_Qnt);		
	}	