<?php
/*
 * WPGear Debugger
 * options.php
 */	
	
    if (!current_user_can('edit_dashboard')) {
        return;
    }
	
	$WPGearDebugger_Nonce = 'Update_Options WPGear Debugger';
	$nonce = wp_create_nonce ($WPGearDebugger_Nonce);
		
	$Action = isset($_REQUEST['action']) ? sanitize_text_field (wp_unslash($_REQUEST['action'])) : null;
	
	if ($Action == 'Update') { 		
		$WP_Nonce = isset($_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : 'none';
		
		$New_Option_AdminOnly 		= isset($_REQUEST['wpgeardebugger_option_adminonly']) ? 1 : 0;	
		$New_Option_Enable 			= isset($_REQUEST['wpgeardebugger_option_enable']) ? 1 : 0;	
		$New_Option_Remote_Control 	= isset($_REQUEST['wpgeardebugger_option_remote_control']) ? 1 : 0;	
		$New_Option_ProcessesSource = isset($_REQUEST['wpgeardebugger_option_processes_source']) ? $_REQUEST['wpgeardebugger_option_processes_source'] : array(); // phpcs:ignore 	
		$New_Option_Processes 		= isset($_REQUEST['wpgeardebugger_option_processes']) ? $_REQUEST['wpgeardebugger_option_processes'] : array(); // phpcs:ignore 	
		$New_Option_ClearSources 	= isset($_REQUEST['wpgeardebugger_option_clear_processes_source']) ? $_REQUEST['wpgeardebugger_option_clear_processes_source'] : array(); // phpcs:ignore 	
		$New_Option_Clearing 		= isset($_REQUEST['wpgeardebugger_option_clearing']) ? 1 : 0;

		if (!wp_verify_nonce($WP_Nonce, $WPGearDebugger_Nonce)) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="wpgeardebugger_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'wpgear-debugger') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}

		global $WPGearDebugger_Processes;

		foreach ($WPGearDebugger_Processes as $Source_Name => &$Source) {	
			if ( array_key_exists( $Source_Name, $New_Option_ProcessesSource ) ) {
				$Source['enable'] = 1;
			} else {
				$Source['enable'] = 0;
			}
			
			foreach ($Source['processes'] as $Process_Name => &$Process_Enable) {
				if (! $New_Option_Processes) {
					$Process_Enable = 0;
				} else {
					if ( array_key_exists( $Source_Name, $New_Option_Processes ) ) {
						if ( array_key_exists( $Process_Name, $New_Option_Processes[$Source_Name] ) ) {
							$Process_Enable = 1;
						} else {
							$Process_Enable = 0;
						}
					} else {
						$Process_Enable = 0;
					}					
				}
			}		
		}

		foreach ($New_Option_ClearSources as $Source_Name => $value) {		
			unset($WPGearDebugger_Processes[$Source_Name]);
		}

		$WPGearDebugger_Options = array(
			'adminonly' => $New_Option_AdminOnly,
			'enable' => $New_Option_Enable,
			'remote_control' => $New_Option_Remote_Control,
			'processes' => $WPGearDebugger_Processes,
			'clearing' => $New_Option_Clearing,
		);

		update_option ('wpgear-debugger_option', $WPGearDebugger_Options); // phpcs:ignore 		
	}
	
	$WPGearDebugger_Options = WPGearDebugger_Get_Options ();
	
	$WPGearDebugger_AdminOnly		= $WPGearDebugger_Options['adminonly'];
	$WPGearDebugger_Enable 			= $WPGearDebugger_Options['enable'];
	$WPGearDebugger_Remote_Control 	= $WPGearDebugger_Options['remote_control'];
	$WPGearDebugger_Processes 		= $WPGearDebugger_Options['processes'];
	$WPGearDebugger_Clearing 		= $WPGearDebugger_Options['clearing'];
	
	ksort( $WPGearDebugger_Processes );
	
	$LogFilesInfo = WPGearDebugger_Get_LogFiles_Info ();
	
	$LogFilesInfo_TotalFiles 	= isset($LogFilesInfo['total_files']) ? $LogFilesInfo['total_files'] : 'N/A';
	$LogFilesInfo_TotalSize 	= isset($LogFilesInfo['total_size']) ? $LogFilesInfo['total_size'] : 'N/A';

	?>
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
		<hr>	
		
		<div class="wpgeardebugger_options_box">
			<form name="form_wpgeardebugger_options" style="display: grid;" method="post">	
				<h3><?php echo esc_html( __('General', 'wpgear-debugger') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>				
							<tr>
								<th scope="row" class="wpgeardebugger_options_field_label">
									<label for="wpgeardebugger_option_adminonly">
										<?php echo esc_html( __('Enable this Page for Admin only', 'wpgear-debugger') ); ?>
									</label>
								</th>
								<td class="wpgeardebugger_options_field_input">
									<input id="wpgeardebugger_option_adminonly" name="wpgeardebugger_option_adminonly" type="checkbox" <?php if($WPGearDebugger_AdminOnly) {echo 'checked';} ?>>
									<span class="wpgeardebugger_options_field_description">
										<?php echo esc_html( __('On/Off', 'wpgear-debugger') ); ?>
									</span>
								</td>
							</tr>

							<tr>
								<th scope="row" class="wpgeardebugger_options_field_label">
									<label for="wpgeardebugger_option_enable">
										<?php echo esc_html( __('Enable Debug Log', 'wpgear-debugger') ); ?>
									</label>
								</th>
								<td class="wpgeardebugger_options_field_input">
									<input id="wpgeardebugger_option_enable" name="wpgeardebugger_option_enable" type="checkbox" <?php if($WPGearDebugger_Enable) {echo 'checked';} ?>>
									<span class="wpgeardebugger_options_field_description">
										<?php echo esc_html( __('On/Off', 'wpgear-debugger') ); ?>
									</span>
								</td>
							</tr>
							
							<tr>
								<th scope="row" class="wpgeardebugger_options_field_label">
									<label for="wpgeardebugger_option_remote_control">
										<?php echo esc_html( __('Enable Remote Control', 'wpgear-debugger') ); ?>
									</label>
								</th>
								<td class="wpgeardebugger_options_field_input">
									<input id="wpgeardebugger_option_remote_control" name="wpgeardebugger_option_remote_control" type="checkbox" <?php if($WPGearDebugger_Remote_Control) {echo 'checked';} ?>>
									<span class="wpgeardebugger_options_field_description">
										<?php echo esc_html( __('On/Off', 'wpgear-debugger') ); ?>
									</span>
								</td>
							</tr>							
						</tbody>
					</table>
				</div>
				
				<hr>

				<h3><?php echo esc_html( __('Processes', 'wpgear-debugger') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>	
							<?php
							foreach ($WPGearDebugger_Processes as $Source_Name => $Source) {							
								
if ( is_array( $Source ) ) {
									$Source_Enable 		= $Source['enable'];
									$Source_Description = $Source['description'];
									?>
									<tr class="wpgeardebugger_options_source_box">
										<td>
											<input id="wpgeardebugger_option_processes_source[<?php echo esc_html( $Source_Name ); ?>]" name="wpgeardebugger_option_processes_source[<?php echo esc_html( $Source_Name ); ?>]" type="checkbox" <?php if($Source_Enable) {echo 'checked';} ?>>
											
											<span class="wpgeardebugger_options_field_label_process_source">
												<?php echo esc_html( $Source_Name ); ?>
											</span>
											<span class="wpgeardebugger_options_field_label_process_source_description">
												<?php echo esc_html( $Source_Description ); ?>
											</span>										
										</td>									
									</tr>									
									<?php
									$Source_Processes = $Source['processes'];
									
									ksort( $Source_Processes );	
									
									foreach ($Source_Processes as $Process_Name => $Processes_Enable) {
										?>
										<tr class="wpgeardebugger_options_process_box">
											<td class="wpgeardebugger_options_field_checkbox_process">
												<input id="wpgeardebugger_option_processes[<?php echo esc_html( $Source_Name ); ?>][<?php echo esc_html( $Process_Name ); ?>]" name="wpgeardebugger_option_processes[<?php echo esc_html( $Source_Name ); ?>][<?php echo esc_html( $Process_Name ); ?>]" type="checkbox" <?php if($Processes_Enable) {echo 'checked';} ?>>
												<span class="wpgeardebugger_options_field_label_process<?php echo esc_html( $Processes_Enable ); ?>">
													<?php 
														if ($Process_Name == '..') {
															echo esc_html( '--- Stream (all Processes) ---' ); 
														} else {
															echo esc_html( $Process_Name ); 
														}
													?>
												</span>
											</td>
										</tr>
										<?php	
									}
}
							}
							?>
						</tbody>
					</table>
				</div>
				
				<hr>	

				<h3><?php echo esc_html( __('Files', 'wpgear-debugger') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="wpgeardebugger_options_info_label">
									<?php echo esc_html( __('Total Files', 'wpgear-debugger') ); ?>
								</th>
								<td class="wpgeardebugger_options_field_info">
									<?php echo esc_html( $LogFilesInfo_TotalFiles ); ?>
								</td>
							</tr>
							
							<tr>
								<th scope="row" class="wpgeardebugger_options_info_label">
									<?php echo esc_html( __('Total Size', 'wpgear-debugger') ); ?>
								</th>
								<td class="wpgeardebugger_options_field_info">
									<?php echo esc_html( $LogFilesInfo_TotalSize ); ?>
								</td>
							</tr>							
						</tbody>
					</table>
				</div>

				<hr>				

				<h3><?php echo esc_html( __('Clearing', 'wpgear-debugger') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<?php 
								echo esc_html( __('Delete Sources if Unused:', 'wpgear-debugger') );

								foreach ($WPGearDebugger_Processes as $Source_Name => $Source) {
									?>
									<tr class="wpgeardebugger_options_clear_source_box">
										<td>
											<input id="wpgeardebugger_option_clear_processes_source[<?php echo esc_html( $Source_Name ); ?>]" name="wpgeardebugger_option_clear_processes_source[<?php echo esc_html( $Source_Name ); ?>]" type="checkbox">
											
											<span class="wpgeardebugger_options_field_label_process_source">
												<?php echo esc_html( $Source_Name ); ?>
											</span>											
										</td>									
									</tr>
									<?php
								}
								?>								
							</tr>

							<tr><td></td></tr>
							
							<tr>								
								<th scope="row" class="wpgeardebugger_options_field_label">
									<label for="wpgeardebugger_option_clearing">
										<?php echo esc_html( __('Delete MetaData with Uninstall Plugin.', 'wpgear-debugger') ); ?>
									</label>
								</th>
								<td class="wpgeardebugger_options_field_input">
									<input id="wpgeardebugger_option_clearing" name="wpgeardebugger_option_clearing" type="checkbox" <?php if($WPGearDebugger_Clearing) {echo 'checked';} ?>>
									<span class="wpgeardebugger_options_field_description">
										<?php echo esc_html( __('On/Off', 'wpgear-debugger') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>

				<hr>				

				<div style="margin-top: 10px; margin-bottom: 10px; text-align: right;">
					<input id="btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_html( __('Save', 'wpgear-debugger') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="Update">
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($nonce); ?>">				
		
			</form>
		</div>		
	</div>			
<?php		