<?php
/*
 * WPGear_Debugger
 * functions.php
 */

	/* Debugger. 
	----------------------------------------------------------------- */
	// function WPGear_Debugger ($Result, $Title = null, $Process = null, $TimeStamp = '') {
	function WPGear_Debugger ( $Parameters = array() ) {
		$WPGearDebugger_isEnable = WPGearDebugger_Get_Options ('enable');
		
		if ($WPGearDebugger_isEnable) {
			$Source 		= isset( $Parameters['source'] ) ? sanitize_text_field ( wp_unslash( $Parameters['source'] ) ) : ''; 			// Источник (Плагин / Тема / Скрипт).
			$Description 	= isset( $Parameters['description'] ) ? sanitize_text_field ( wp_unslash( $Parameters['description'] ) ) : ''; 	// Описание Источника.
			$Subject 		= isset( $Parameters['subject'] ) ? sanitize_text_field ( wp_unslash( $Parameters['subject'] ) ) : ''; 			// Заголовок (Название Переменной).
			$Process 		= isset( $Parameters['process'] ) ? sanitize_text_field ( wp_unslash( $Parameters['process'] ) ) : ''; 			// Название Процесса.
			$Content 		= isset( $Parameters['content'] ) ? $Parameters['content'] : ''; // phpcs:ignore								// Контент / Значение.
			$Function 		= isset( $Parameters['function'] ) ? sanitize_text_field ( wp_unslash( $Parameters['function'] ) ) : ''; 		// Название Функции.
			$TimeStamp 		= isset( $Parameters['timestamp'] ) ? 1 : 0; 																	// Временная Метка.		
			$Line	 		= isset( $Parameters['line'] ) ? sanitize_text_field ( wp_unslash( $Parameters['line'] ) ) : ''; 				// Номер строки в Файле.					
			
			$Source 	= WPGearDebugger_TextNormalizer ($Source);
			$Subject 	= WPGearDebugger_TextNormalizer ($Subject);
			$Process 	= WPGearDebugger_TextNormalizer ($Process);
			$Line 		= WPGearDebugger_TextNormalizer ($Line);				
			
			$Source = sanitize_file_name( $Source );			
			
			if ($Source && $Process) {			
				if ($TimeStamp) {
					$Process_Content = '----';
					$DateTime = current_time('Y.m.d H:i:s');
					$Process_Content .= ' ' .$DateTime .' ---- ';					
				} else {
					$Process_Content = '----------------------';
				}

				$Process_Content .= "\r\n";				
				$Process_Content .= '"' .$Process .'", "' .$Function .'", Line:' .$Line;				
				$Process_Content .= "\r\n";
				$Process_Content .= $Subject .': ' .var_export( $Content, true); // phpcs:ignore 
				$Process_Content .= "\r\n\r\n";	

				// Источник. Создание / Обновление
				WPGearDebugger_Update_Source ($Source, $Description);				

				// Отдельный процесс.
				WPGearDebugger_Debug_Processing ($Source, $Process, $Process_Content);	
				
				// Потоковый Процесс для данного Источника.
				WPGearDebugger_Debug_Processing ($Source, '..', $Process_Content);
			}
		}		
	}
	
	/* Update Source. 
	----------------------------------------------------------------- */
	function WPGearDebugger_Update_Source ($Source, $NewDescription) {
		global $WPGearDebugger_Processes;
		
		$Need_Update = false;
		
		if ( ! array_key_exists( $Source, $WPGearDebugger_Processes ) ) {		
			// Новый Источник. (Статус = OFF)
			$WPGearDebugger_Processes[$Source] = array(
				'enable' => 0,
				'description' => $NewDescription,
				'processes' => array(),
			);	

			$Need_Update = true;
			
		} else {
			// Обновление Описания.
			$Description = isset( $WPGearDebugger_Processes[$Source]['description'] ) ? $WPGearDebugger_Processes[$Source]['description'] : ''; // phpcs:ignore
			
			if ($NewDescription != $Description) {
				$WPGearDebugger_Processes[$Source]['description'] = $NewDescription;
				
				$Need_Update = true;
			}
		}
		
		if ($Need_Update) {
			WPGearDebugger_Update_Option ( 'processes', $WPGearDebugger_Processes );
		}
	}
	
	/* Debug Processing. 
	----------------------------------------------------------------- */
	function WPGearDebugger_Debug_Processing ($Source, $Process, $Process_Content) {
		global $WPGearDebugger_Processes;

		$Need_Update = false;

		$Process_Name = $Source .'.' .$Process;	

		if ( ! array_key_exists( $Process, $WPGearDebugger_Processes[$Source]['processes'] ) ) {
			// Новый Процесс. (Статус = OFF)
			$WPGearDebugger_Processes[$Source]['processes'][$Process] = 0;
			
			$Need_Update = true;
		}
		
		// Проверяем Статус Процесса.
		if ( array_key_exists( $Process, $WPGearDebugger_Processes[$Source]['processes'] ) ) {
			$is_Source_Enable 	= $WPGearDebugger_Processes[$Source]['enable'];
			$is_Process_Enable 	= $WPGearDebugger_Processes[$Source]['processes'][$Process];

			if ($is_Source_Enable && $is_Process_Enable) {
				// Логируем Процесс.
				WPGearDebugger_Save_Log ($Source, $Process_Name, $Process_Content);
			}
		}
		
		if ($Need_Update) {
			WPGearDebugger_Update_Option ( 'processes', $WPGearDebugger_Processes );
		}
		
		return true;
	}
	
	/* Save Log
	----------------------------------------------------------------- */
	function WPGearDebugger_Save_Log ($Source, $Process_Name, $Content) {
		global $WPGearDebugger_DirName;
		
		$SubDir = $WPGearDebugger_DirName .'/' .$Source;
		
		$Process_Name = sanitize_file_name( $Process_Name );
		
		$Dir_Uploads = wp_get_upload_dir();
		
		$Dir_Uploads_WPGearDebugger = $Dir_Uploads['basedir'] .'/' .$SubDir;
		
		$Date = current_time('Y.m.d');				
		
		$File_Name = $Date;
		
		$CurrentUser_ID = get_current_user_id();
		
		if ($CurrentUser_ID) {
			$File_Name .= '-' .$CurrentUser_ID;
		}
		
		$File_Name .= '_' .$Process_Name .'.txt';		

		if ( wp_mkdir_p( $Dir_Uploads_WPGearDebugger ) ) {
			$File_Handle = fopen( trailingslashit( $Dir_Uploads_WPGearDebugger ) .$File_Name, 'a+' ); // phpcs:ignore		
			
			if ( $File_Handle ) {
				fwrite( $File_Handle, $Content ); // phpcs:ignore
				
				fclose( $File_Handle ); // phpcs:ignore
			}			
		}		
		
		return true;
	}
	
	/* Create SubDir in WP-Upload Dir
	----------------------------------------------------------------- */ 	
	function WPGearDebugger_Create_UploadSubDir ($SubDir, $File_Name, $Content) {
		$Dir_Uploads = wp_get_upload_dir();
		
		$Dir_Uploads_WPGearDebugger = $Dir_Uploads['basedir'] .'/' .$SubDir;

		if ( wp_mkdir_p( $Dir_Uploads_WPGearDebugger ) && ! file_exists( trailingslashit( $Dir_Uploads_WPGearDebugger ) .$File_Name ) ) {
			$File_Handle = fopen( trailingslashit( $Dir_Uploads_WPGearDebugger ) .$File_Name, 'wb' ); // phpcs:ignore		
			
			if ( $File_Handle ) {
				fwrite( $File_Handle, $Content ); // phpcs:ignore
				
				fclose( $File_Handle ); // phpcs:ignore
			}			
		}		
		
		return true;
	}	
	
	/* Get_Options / Option
	----------------------------------------------------------------- */ 	
	function WPGearDebugger_Get_Options( $Option = null ) {
		
		// delete_option ('wpgear-debugger_option');		
		
		$WPGearDebugger_Options = get_option( "wpgear-debugger_option", array(
			'adminonly' => 1,
			'enable' => 1,
			'remote_control' => 1,
			'processes' => array(),
			'clearing' => 1,
			)
		);	
		
		$WPGearDebugger_AdminOnly		= isset( $WPGearDebugger_Options['adminonly'] ) ? $WPGearDebugger_Options['adminonly'] : 1;				// Доступ к Настройкам.
		$WPGearDebugger_Enable 			= isset( $WPGearDebugger_Options['enable'] ) ? $WPGearDebugger_Options['enable'] : 1;					// On/Off - Обработчик.
		$WPGearDebugger_Remote_Control 	= isset( $WPGearDebugger_Options['remote_control'] ) ? $WPGearDebugger_Options['remote_control'] : 1;	// On/Off - Удаленное Управление.
		$WPGearDebugger_Processes 		= isset( $WPGearDebugger_Options['processes'] ) ? $WPGearDebugger_Options['processes'] : array();		// Процессы Логирования.
		$WPGearDebugger_Clearing 		= isset( $WPGearDebugger_Options['clearing'] ) ? $WPGearDebugger_Options['clearing'] : 1;				// Необходимость удаления Мета-Данных.
		
		$WPGearDebugger_Options = array(
			'adminonly' => $WPGearDebugger_AdminOnly,
			'enable' => $WPGearDebugger_Enable,
			'remote_control' => $WPGearDebugger_Remote_Control,
			'processes' => $WPGearDebugger_Processes,
			'clearing' => $WPGearDebugger_Clearing,
		);
		
		if ($Option) {
			return $WPGearDebugger_Options[$Option];
		}

		return $WPGearDebugger_Options;
	}	
	
	/* Update Option
	----------------------------------------------------------------- */ 
	function WPGearDebugger_Update_Option ( $Option, $Value ) {
		if ($Option) {
			$WPGearDebugger_Options = WPGearDebugger_Get_Options();
			
			$WPGearDebugger_Options[$Option] = $Value;
			
			update_option ('wpgear-debugger_option', $WPGearDebugger_Options); // phpcs:ignore 
			
			return true;
			
		} else {
			return false;
		}
	}
		
	/* Text_Normalizer. 
	----------------------------------------------------------------- */	
	function WPGearDebugger_TextNormalizer ($String) {
		$String = trim( $String );
		$String = strtolower( $String );		
		
		return $String;
	}	
	
	/* Get Log Files Info. 
	----------------------------------------------------------------- */
	function WPGearDebugger_Get_LogFiles_Info () {
		global $WPGearDebugger_DirName;
		
		$Dir_Uploads = wp_get_upload_dir();
		
		$Dir_Uploads_WPGearDebugger = $Dir_Uploads['basedir'] .'/' .$WPGearDebugger_DirName;		
		
		$Iterator = new RecursiveDirectoryIterator( $Dir_Uploads_WPGearDebugger );

		$BytesTotal = 0;
		$FilesTotal = 0;
		$SizeTotal = 0;
		$Files = array();
		
		$FilesExclude = array ('.', '..', 'index.php');
		
		foreach ( new RecursiveIteratorIterator( $Iterator ) as $FileName => $Item ) {
			$FileBase = $Item -> getBasename();
			
			if (! in_array($FileBase, $FilesExclude)) {
				$FileSize = $Item -> getSize();
				$BytesTotal += $FileSize;
				$FilesTotal ++;
				$Files[] = $FileName;
			}	
		}

		if ($BytesTotal > 0) {
			$precision = 2;
			$Unit = ["B", "KB", "MB", "GB"];
			$Exp = floor( log( $BytesTotal, 1024) ) | 0;
			$SizeTotal = round( $BytesTotal / (pow( 1024, $Exp ) ), $precision) .$Unit[$Exp];		
		}
		
		$Result = array( 
			'total_files' => $FilesTotal,
			'total_size' => $SizeTotal,
			'files' => $Files,
		);

		return $Result;		
	}
	
	/* Clear Log Files. 
	----------------------------------------------------------------- */	
	function WPGearDebugger_Clear_Logs ($Source) {
		global $WPGearDebugger_DirName;
		
		$Source = trim( $Source );
		$Source = strtolower( $Source );
		$Source = sanitize_file_name( $Source );
		
		$Dir_Uploads = wp_get_upload_dir();
		
		$Dir_Uploads_WPGearDebugger = $Dir_Uploads['basedir'] .'/' .$WPGearDebugger_DirName .'/' .$Source;
		
		$Date = current_time('Y.m.d');				
		
		$File_Name = $Date .'_' .$Source .'.txt';	

		$File_Path = $Dir_Uploads_WPGearDebugger .'/' .$File_Name;
		
		// unlink ($File_Path);
		wp_delete_file( $File_Path );
		
		return true;
	}