<?php
/*
Plugin Name: WPGear Debugger
Plugin URI: https://wpgear.xyz/wpgear-debugger
Description: Debug System
Version: 1.8
Text Domain: wpgear-debugger
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/admin/admin.php' );
	
	$WPGearDebugger_Plugin_URL = plugin_dir_url ( __FILE__ ); // со слэшем на конце
	$WPGearDebugger_Plugin_Version 	= '';
	
	$WPGearDebugger_DirName = 'wpgear_debugger';

	$WPGearDebugger_LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';
	// __('Debug System', 'wpgear-debugger');
	
	$WPGearDebugger_Processes = WPGearDebugger_Get_Options ('processes');

	/* Translate.
	----------------------------------------------------------------- */
	add_action ('plugins_loaded', 'WPGearDebugger_Action_plugins_loaded');
	function WPGearDebugger_Action_plugins_loaded() {
		global $WPGearDebugger_LocalePath;		
		
		$result = load_plugin_textdomain ('wpgear-debugger', false, $WPGearDebugger_LocalePath);
	}	

	/* Init. Инициализация.
	----------------------------------------------------------------- */ 
	add_action ('init', 'WPGearDebugger_Init', 10);
	function WPGearDebugger_Init () {
		global $WPGearDebugger_DirName;
		
		$Plugin_Data = get_plugin_data( __FILE__ );

		global $WPGearDebugger_Plugin_Version;
		$WPGearDebugger_Plugin_Version = $Plugin_Data['Version'];

		// Создание Папки "wpgear_debugger" в Uploads
		$File_Name = 'index.php';
		$Content = '<?php // Silence is golden.';
		
		WPGearDebugger_Create_UploadSubDir ($WPGearDebugger_DirName, $File_Name, $Content);
		
		// Remote Control. Внешня команда Удаления Логов для определенного Источника
		$WPGearDebugger_Remote_Control = WPGearDebugger_Get_Options ('remote_control');
		
		if ($WPGearDebugger_Remote_Control) {
			$RemoteCommand_Clear = isset( $_REQUEST['clear_debug'] ) ? sanitize_text_field ( wp_unslash( $_REQUEST['clear_debug'] ) ): ''; // phpcs:ignore
			
			if ($RemoteCommand_Clear) {
				WPGearDebugger_Clear_Logs ($RemoteCommand_Clear);
			}
		}
	}