// * WPGear. 
// * WPGear – Consent Privacy Policy Acceptance
// * wpgear-cppa.js
 
	// Get Cookie
	function getCookie(c_name) {
		var i,x,y,ARRcookies = document.cookie.split(";");
		
		for (i=0; i < ARRcookies.length; i++) {
			x = ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
			y = ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
			x = x.replace(/^\s+|\s+$/g,"");

			if (x == c_name) {
				return unescape(y);
			}
		}
	}

	// Display Notification
	function displayNotification() {
		var message = "<div id='cookiewarning' ><div id=\"back\">";

		message = message + "<div>";
		message = message + "<p>" + nl2br(wpgearcppa_user_options.messageContent) + "</p>";
		message = message + "<p id=\"buttons\"><a href=\"\" id=\"cookiewarningOK\" >"+wpgearcppa_user_options.okText+"</a></p>";
		message = message + "</div></div></div>";

		jQuery('body').prepend(message);

		jQuery('a[id=cookiewarningOK]').click( function(event) {
			event.preventDefault();
			
			setCookie(wpgearcppa_user_options.cookieName, null, 365);
		} );
	}

	// Set Cookie
	function setCookie(c_name,value,exdays) {
		var exdate = new Date();
		
		exdate.setDate(exdate.getDate() + exdays);
		
		var c_value = escape(value) + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString());
		document.cookie=c_name + "=" + c_value + ";path=/";

		jQuery('#cookiewarning').css('display', 'none');
	}

	// Check Cookie
	function checkCookie() {
		var cookieName = wpgearcppa_user_options.cookieName;
		
		var cookieChk = getCookie(cookieName);
		
		if (cookieChk != null && cookieChk != "") {
			setCookie(cookieName,cookieChk, 365);
		} else {
			// No cookie exists.
			displayNotification();
		} 
	}

	// Message Formatting
	function nl2br (str, is_xhtml) {   
		var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';    
		return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1'+ breakTag +'$2');
	}
    
	
	function are_cookies_enabled() {
		var cookieEnabled = (navigator.cookieEnabled) ? true : false;

		if (typeof navigator.cookieEnabled == "undefined" && !cookieEnabled) { 
			document.cookie = "testcookie";
			cookieEnabled = (document.cookie.indexOf("testcookie") != -1) ? true : false;
		}
		return (cookieEnabled);
	}

	
	jQuery(window).load(function() {
		if (are_cookies_enabled()) {
			checkCookie();
		}

		jQuery(window).resize(function() {
			if(jQuery( 'div#cookiewarning' ).is(':visible')) {
				if( jQuery(window).scrollTop() + jQuery(window).height() >= jQuery( 'div#cookiewarning div#back' ).outerHeight() ) {
					jQuery(window).scrollTop( jQuery( 'div#cookiewarning div#back' ).outerHeight() - jQuery(window).height() );
				}
			}
		});
	});