<?php
/*
Plugin Name: WPGear – Consent Privacy Policy Acceptance
Plugin URI: https://wpgear.xyz/accept-privacy-policy
Description: Accept Cookies & Privacy Policy. (Fork of "Cookie warning" by Marie Manandise, MAJWeb)
Version: 2.5
Text Domain: wpgear-consent-privacy-policy-acceptance
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly
	}
	
	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/admin/admin.php' );
	
	/* Init.
	----------------------------------------------------------------- */
	add_action ('init', 'WPGearCPPA_Action_init');
	function WPGearCPPA_Action_init() {
		$debug_process = 'init';
		
		$LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';	
		
		$Result = load_plugin_textdomain ('wpgear-consent-privacy-policy-acceptance', false, $LocalePath);
		WPGearCPPA_Debugger ($Result, '$Result', $debug_process, __FUNCTION__, __LINE__);
		
		// if ($Result) {
			// $Translations_Data = get_translations_for_domain( 'wpgear-consent-privacy-policy-acceptance' );	
			// WPGearCPPA_Debugger ($Translations_Data, '$Translations_Data', $debug_process, __FUNCTION__, __LINE__);
		// }
	}	
	
	/* Styles & Scripts.
	----------------------------------------------------------------- */	
	add_action ('wp_enqueue_scripts', 'WPGearCPPA_Action_enqueue_scripts' );	
	function WPGearCPPA_Action_enqueue_scripts () {	
		$debug_process = 'enqueue_scripts';
	
		$Plugin_Url = plugin_dir_url( __FILE__ ); // со слэшем на конце	
		$Plugin_Data = get_plugin_data ( __FILE__ );
		WPGearCPPA_Debugger ($Plugin_Data, '$Plugin_Data', $debug_process, __FUNCTION__, __LINE__);
		
		$Plugin_Version = $Plugin_Data['Version'];		
	
		wp_enqueue_style ('wpgear-consent-privacy-policy-acceptance_style', $Plugin_Url .'style.css'); // phpcs:ignore 
		
		wp_enqueue_script ( 'jquery' );
		wp_enqueue_script ( 'wpgear-consent-privacy-policy-acceptance' , $Plugin_Url .'includes/js/wpgear-cppa.js', array('jquery'), $Plugin_Version, true );
		
		$Options = WPGearCPPA_Get_Options();
		WPGearCPPA_Debugger ($Options, '$Options', $debug_process, __FUNCTION__, __LINE__);
		
		$OptionMessage 			= isset( $Options['message'] ) ? $Options['message'] : '';
		$OptionButtonAccept		= isset( $Options['button_accept'] ) ? $Options['button_accept'] : '';
		$OptionPolicyPageSlug 	= isset( $Options['policypage_slug'] ) ? $Options['policypage_slug'] : $OptionPolicyPageSlug;
		$OptionPolicyPageText 	= isset( $Options['policypage_text'] ) ? $Options['policypage_text'] : $OptionPolicyPageSlug;
		
		if ($OptionPolicyPageSlug && $OptionPolicyPageText) {
			$PolicyPage_URL = get_site_url( null, $OptionPolicyPageSlug );
			
			$PolicyPage_Link = '<a href=' .esc_url($PolicyPage_URL) .'>' .$OptionPolicyPageText .'</a>';
			WPGearCPPA_Debugger ($PolicyPage_Link, '$PolicyPage_Link', $debug_process, __FUNCTION__, __LINE__);
			
			if (function_exists( 'mb_str_replace' )) {
				$OptionMessage = mb_str_replace('{Privacy Policy}', $PolicyPage_Link, $OptionMessage);
				
			} else {
				$OptionMessage = str_replace('{Privacy Policy}', $PolicyPage_Link, $OptionMessage);
			}
			
			WPGearCPPA_Debugger ($OptionMessage, '$OptionMessage', $debug_process, __FUNCTION__, __LINE__);
		}
		
		$AJAX_URL =  admin_url ('admin-ajax.php');
		
		$Nonce_Key = 'WPGear – Consent Privacy Policy Acceptance';		
		$Nonce = wp_create_nonce ($Nonce_Key);
		
		$Options_JS = array(
			'messageContent' => $OptionMessage,
			'okText' => $OptionButtonAccept,
			'cookieName' => 'WPGearCPPA',
			'ajax_url' => $AJAX_URL,
			'nonce' => $Nonce,
		);
		WPGearCPPA_Debugger ($Options_JS, '$Options_JS', $debug_process, __FUNCTION__, __LINE__);
				 
		wp_localize_script( 'wpgear-consent-privacy-policy-acceptance' , 'wpgearcppa_user_options' , $Options_JS );
	}
	
	/* AJAX Call to Clear Cookies.
	----------------------------------------------------------------- */
	add_action('wp_ajax_wpgear-cppa_clear_cookies', 'WPGearCPPA_Action_clear_cookies');
	add_action('wp_ajax_nopriv_wpgear-cppa_clear_cookies', 'WPGearCPPA_Action_clear_cookies');
	function WPGearCPPA_Action_clear_cookies () {
		$Cookies_Request = $_REQUEST[ 'cookie' ]; // phpcs:ignore 
		$PastDate = mktime(0,0,0,1,1,1970);
		$Cookies = $_COOKIE;
		
		foreach( $Cookies as $Key => $Value ){
			if ( $Key != $Cookies_Request ) {
				setcookie( $Key , "" , $PastDate );
			}
		}
		
		echo json_encode( array( 'success' => true ) );
		
		die;
	}