<?php
/*
Plugin Name: GV Excel Export
Plugin URI: https://wpgear.xyz/gv-excel-export
Description: Make Export to normal Excel file from GravityView Forms. Check out the features of the PRO version: <a href="https://wpgear.xyz/gv-excel-export-pro/">"GV Excel-Export PRO"</a>.
Version: 3.5
Text Domain: gv-excel-export
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	$GVXL_plugin_url = plugin_dir_url( __FILE__ );	// со слэшем на конце
	$GVXL_plugin_dir = plugin_dir_path( __FILE__ );	// со слэшем на конце	

	$GVXL_LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';
	__('Make Export to normal Excel file from GravityView Forms. Check out the features of the PRO version: <a href="https://wpgear.xyz/gv-excel-export-pro/">"GV Excel-Export PRO"</a>.', 'gv-excel-export');	
	
	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/shortcodes.php' );
	include_once( __DIR__ .'/includes/admin/admin.php' );
	
	/* Translate.
	----------------------------------------------------------------- */
	add_action ('plugins_loaded', 'GVXL_Action_plugins_loaded');
	function GVXL_Action_plugins_loaded() {
		global $GVXL_LocalePath;
				
		$Result = load_plugin_textdomain ('gv-excel-export', false, $GVXL_LocalePath);
	}	

	/* Registering Styles with GravityView when running on "no-conflict mode"
	----------------------------------------------------------------- */
	add_filter('gravityview_noconflict_styles', 'GVXL_Filter_gravityview_noconflict_styles' );	
	function GVXL_Filter_gravityview_noconflict_styles( $styles ){
		$GVXL_Setup_Enable = GVXL_Get_Options('enable');
		
		if ($GVXL_Setup_Enable) {
			$styles[] = "gvxl_admin";
			$styles[] = "fontawesome_4.7.0";
			
			return $styles;
		}
		
		return $styles;
	}	
	
	/* Стили для Фронтенд
	----------------------------------------------------------------- */	
	add_action ('wp_enqueue_scripts','GVXL_Action_wp_enqueue_scripts');		
	function GVXL_Action_wp_enqueue_scripts(){
		$GVXL_Setup_Enable = GVXL_Get_Options('enable');
		
		if ($GVXL_Setup_Enable) {
			global $GVXL_plugin_url;
			
			$Style_Path = $GVXL_plugin_url .'style.css';
			wp_enqueue_style('gvxl', $Style_Path, false, null ); // phpcs:ignore
			
			// Font Awesome
			wp_enqueue_style('fontawesome_4.7.0', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css'); // phpcs:ignore
		}		
	}

	// Advanced requests. 
	add_action( 'template_redirect', 'GVXL_Action_template_redirect' );	
	function GVXL_Action_template_redirect() {
		$GVXL_Setup_Enable = GVXL_Get_Options('enable');
		
		if ($GVXL_Setup_Enable) {
			$Request_Output = isset($_REQUEST['out']) ? sanitize_text_field ($_REQUEST['out']) : null; // phpcs:ignore
			
			global $wp_query;
			
			$Post = $wp_query -> post;		
			
			if ($Request_Output == 'excel') {
				// Create Excel File.
				GVXL_ExcelExport_Processing($Post);
								
				// $Return_URL = $_SERVER['REDIRECT_SCRIPT_URI'];
				
				// echo "<script> location.href=$Return_URL; </script>";
				// exit();
			}
		}		
	}