<?php
/*
 * WPGear. 
 * GV Excel Export
 * options.php
 */
 
	$GVXL_Nonce = 'Update_Options GV Excel Export';
	$nonce = wp_create_nonce ($GVXL_Nonce);
	
	$GVXL_Action = isset($_REQUEST['action']) ? sanitize_text_field( wp_unslash( $_REQUEST['action'] ) ) : null;
	$WP_Nonce 		= isset($_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : 'none';
	
	if ($GVXL_Action == 'update') {	
		if (!wp_verify_nonce($WP_Nonce, $GVXL_Nonce)) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="wdpq_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'gv-excel-export') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}
	
		// Save Options.
		$GVXL_Setup_AdminOnly 	= isset( $_REQUEST['gv_excel_export_option_adminonly'] ) ? 1 : 0;
		$GVXL_Setup_Enable 		= isset( $_REQUEST['gv_excel_export_option_enable'] ) ? 1 : 0;
		$GVXL_Setup_Clearing 	= isset( $_REQUEST['gv_excel_export_option_clearing'] ) ? 1 : 0;
		
		$GVXL_Options = array(
			'adminonly' => $GVXL_Setup_AdminOnly,
			'enable' => $GVXL_Setup_Enable,
			'clearing' => $GVXL_Setup_Clearing,
		);
		
		update_option( 'gv-excel-export_option', $GVXL_Options ); // phpcs:ignore
	}
	
	$GVXL_Options = GVXL_Get_Options();
	
	$GVXL_Setup_AdminOnly 	= $GVXL_Options['adminonly'];
	$GVXL_Setup_Enable		= $GVXL_Options['enable'];
	$GVXL_Setup_Clearing 	= $GVXL_Options['clearing'];	
	
	if ($GVXL_Setup_AdminOnly) {
		if (!current_user_can( 'edit_dashboard' )) {
			?>
			<div class="gv_excel_export_warning" style="margin: 40px;">
				<?php echo esc_html( __('Sorry, you are not allowed to view this page.', 'gv-excel-export') ); ?>
			</div>
			<?php
			
			return;
		}		
	}
	
	?>
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
		
		<div id="gv_excel_export_message_box" class="gv_excel_export_message_box"></div>
		
		<hr>
		
		<div class="gv_excel_export_options_box">			
			<form name="form_GVXL_Options" method="post" style="margin-top: 20px;">
				<h3><?php echo esc_html( __('General', 'gv-excel-export') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<div style="margin-top: 10px;">
						<label for="gv_excel_export_option_adminonly" title="On/Off">
							<?php echo esc_html( __('Enable this Page for Admin only', 'gv-excel-export') ); ?>
						</label>
						<input id="gv_excel_export_option_adminonly" name="gv_excel_export_option_adminonly" type="checkbox" <?php if($GVXL_Setup_AdminOnly) {echo 'checked';} ?>>
					</div>	
				</div>
				
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<div style="margin-top: 10px;">
						<label for="gv_excel_export_option_enable" title="On/Off">
							<?php echo esc_html( __('Enable Excel Export for all GViews', 'gv-excel-export') ); ?>
						</label>
						<input id="gv_excel_export_option_enable" name="gv_excel_export_option_enable" type="checkbox" <?php if($GVXL_Setup_Enable) {echo 'checked';} ?>>
					</div>	
				</div>

				<hr>
				
				<h3><?php echo esc_html( __('Clearing', 'gv-excel-export') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">				
					<div style="margin-top: 20px;">
						<label for="gv_excel_export_option_clearing" title="On/Off">
							<?php echo esc_html( __('Delete MetaData with Uninstall Plugin.', 'gv-excel-export') ); ?>
						</label>
						<input id="gv_excel_export_option_clearing" name="gv_excel_export_option_clearing" type="checkbox" <?php if($GVXL_Setup_Clearing) {echo 'checked';} ?>>
					</div>
				</div>
				
				<hr>				
				
				<div style="margin-top: 10px; margin-bottom: 5px; text-align: right;">
					<input id="gv_excel_export_btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_attr( __('Save', 'gv-excel-export') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="update">	
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr( $nonce ); ?>">
				
			</form>	
		</div>			
	</div>	
	<?php