<?php
/*
 * WPGear. 
 * GV Excel Export
 * functions.php
 */
 
	/* Get_Options / Option
	----------------------------------------------------------------- */ 	
	function GVXL_Get_Options( $Option = null ) {
		$GVXL_Options = get_option( "gv-excel-export_option", array(
			'adminonly' => 1,
			'enable' => 1,
			'clearing' => 1,
			)
		);
		
		$GVXL_Setup_AdminOnly 	= isset( $GVXL_Options['adminonly'] ) ? $GVXL_Options['adminonly'] : 1;
		$GVXL_Setup_Enable 		= isset( $GVXL_Options['enable'] ) ? $GVXL_Options['enable'] : 1;
		$GVXL_Setup_Clearing 	= isset( $GVXL_Options['clearing'] ) ? $GVXL_Options['clearing'] : 0;
		
		$GVXL_Options = array(
			'adminonly' => $GVXL_Setup_AdminOnly,
			'enable' => $GVXL_Setup_Enable,
			'clearing' => $GVXL_Setup_Clearing,
		);
		
		if ($Option) {
			return $GVXL_Options[$Option];
		}

		return $GVXL_Options;
	}
	
	/* Create Excel File.
	----------------------------------------------------------------- */   
	function GVXL_ExcelExport_Processing($Post) {
		if (! class_exists('GFForms')) {
			die();
		} else {
			if (! class_exists('PHPExcel')) {	
				global $GVXL_plugin_dir;
				include_once($GVXL_plugin_dir .'/lib/phpExcel_7.4.3.1/PHPExcel.php');
			}
		
			$Post_ID 	= $Post -> ID;			
			$Post_Type 	= $Post -> post_type;	
			$Post_Title = $Post -> post_title;

			$Request_Search 	= isset($_REQUEST['gv_search']) ? sanitize_text_field( wp_unslash( $_REQUEST['gv_search'] ) ) : null; // phpcs:ignore
			$Request_Sorting 	= isset($_REQUEST['sort']) ? sanitize_text_field( wp_unslash( $_REQUEST['sort'] ) ) : null; // phpcs:ignore
			$Date_Start 		= isset($_REQUEST['date_from']) ? sanitize_text_field( wp_unslash( $_REQUEST['date_from'] ) ) : null; // phpcs:ignore
			$Date_End 			= isset($_REQUEST['date_to']) ? sanitize_text_field( wp_unslash( $_REQUEST['date_to'] ) ) : null; // phpcs:ignore				
		
			$GV_Form_ID = null;			
			if ($Post_Type == 'page' || $Post_Type == 'post') {
				// Page with Shortcode.
				$GV_Form_ID = isset($_REQUEST['gv_id']) ? sanitize_text_field ($_REQUEST['gv_id']) : null; // phpcs:ignore							
				
				if ($GV_Form_ID) {
					$GV_Form_ID = intval($GV_Form_ID);
				}
			} else if ($Post_Type == 'gravityview') {
				// Page G-View
				$GV_Form_ID = $Post_ID;				
			} else {
				// Somthing Wrong.
				echo 'Somthing Wrong. GVXL_ExcelExport_Processing';
				die();
			}

			if ($GV_Form_ID) {			
				$key = '_gravityview_form_id';
				$Form_ID = get_post_meta($GV_Form_ID, $key, true);
	
				$Form = GFAPI::get_form($Form_ID);
				
				$Current_User 	= wp_get_current_user();
				$User_ID 		= $Current_User -> ID;
				$User_Name 		= $Current_User -> user_login;				
				
				$key = '_gravityview_template_settings';
				$GV_Settings = get_post_meta($GV_Form_ID, $key, true);

				$key = '_gravityview_filters';
				$GV_Filters = get_post_meta($GV_Form_ID, $key, true);

				$key = '_gravityview_directory_fields';
				$GV_Table_Columns = get_post_meta($GV_Form_ID, $key, true);
				$GV_Table_Columns = $GV_Table_Columns['directory_table-columns'];
				
				// Нормализуем Array "GV_Table_Columns" для недостающих Полей
				foreach ($GV_Table_Columns as $key => &$Item) {
					// Field "content"
					if ( !array_key_exists('content', $Item) ) {
						$Item['content'] = '';
					}
					
					// Field "date_display"
					if ( !array_key_exists('date_display', $Item) ) {
						$Item['date_display'] = '';
					}
				}

				if ($GV_Settings) {
					$Show_Only_Approved = $GV_Settings['show_only_approved'];
				}
				
				$Search_Criteria = array ();
				$GV_Filters_Conditions = false;

				if ($GV_Filters) {
					$GW_Version				= $GV_Filters['version'];
					$GV_Filters_Conditions 	= $GV_Filters['conditions'];
					
					$Search_Criteria['version'] = $GW_Version;
				}
				
				$Search_Criteria['status'] = 'active';	
				$Search_Criteria['field_filters']['mode'] = 'all';
				
				if ($Show_Only_Approved) {
					$Search_Criteria['field_filters'][] = array( 'key' => 'is_approved', 'value' => true );
				}
					
				if ($Date_Start) {					
					$Date_Start = gmdate('Y-m-d', strtotime ($Date_Start));
					$Search_Criteria['start_date'] = $Date_Start;
				} else {
					$Date_Start = $GV_Settings['start_date'];
					
					if ($Date_Start) {
						// Date from GV Filters.
						$Search_Criteria['start_date'] = $Date_Start;
					} else {
						// Set Default.
						$Search_Criteria['start_date'] = '2000-01-01';
					}
				}
				
				if ($Date_End) {
					$Date_End = gmdate('Y-m-d', strtotime ($Date_End));
					$Search_Criteria['end_date'] = $Date_End;
				} else {
					$Date_End = $GV_Settings['end_date'];
					
					if ($Date_End) {
						// Date from GV Filters.
						$Search_Criteria['end_date'] = $Date_End;
					} else {
						// Set Default.
						$Search_Criteria['end_date'] = current_time('Y-m-d');
					}
				}		

				// GV Filters					
				$Temp_Search_Criteria 	= array();
				$Trigger_OnCreatedBy 	= false;
				$Trigger_OnLoggedIn 	= false;
				$GW_Advanced_Filter		= false;
				
				$Description = '';
							
				if (function_exists('gv_extension_advanced_filtering_load')) {
					// GravityView - Advanced Filter Extension
					$GW_Advanced_Filter = true;
				
					if ($GV_Filters_Conditions) {
						foreach ($GV_Filters_Conditions as $Condition) {
							foreach ($Condition['conditions'] as $Item) {
								$Item_Key 		= $Item['key'];
								$Item_Operator 	= $Item['operator'];
								$Item_value 	= $Item['value'];
								
								if ($Item_Key == 'created_by') {
									$Trigger_OnCreatedBy = true;
									
									if ($Item_value == 'created_by') {
										if ($GW_Advanced_Filter) {
											$Trigger_OnLoggedIn = true;
										}
									} 
								} else {
									$Temp_Search_Criteria[] = array(
										'key' => $Item_Key, 
										'operator' => $Item_Operator, 
										'value' => $Item_value
									);								
								}							
							}
						}
					}
					
					if ($Description == '') {
						// Easy User. Apply GW Filters.
						if ($Trigger_OnLoggedIn) {
							// Main Criteria.
							$Search_Criteria['field_filters'][] = array(
								'key' => 'created_by', 
								'operator' => 'is', 
								'value' => $User_ID
							);

							$Description = 'Look like: Member';							
						} else {
							$Description = 'Look like: As is';
						}
					}					
				}

				if ($Request_Search) {
					// Get Records with Search Requests.
					$Search_Criteria['field_filters'][] = array( 'value' => $Request_Search );
				}
				
				// Filter from GV Widget. PRO Version.

				$Sorting = array();
                
                if (is_array($Request_Sorting)) {
					// Sorting.
					$Sort_Field 	= array_keys($Request_Sorting)[0];
					$Sort_Direction = array_values($Request_Sorting)[0];
					
					$Sorting = array( 'key' => $Sort_Field, 'direction' => $Sort_Direction); 
					// ,'is_numeric' => true ); - need type of Fields.
				}				
				
				$Count_Entries = GFAPI::count_entries( $Form_ID, $Search_Criteria );
				$Paging = array( 'offset' => 0, 'page_size' => $Count_Entries );

				$Entries = GFAPI::get_entries($Form_ID, $Search_Criteria, $Sorting, $Paging);			

				// Normalize File Name.
				$DateTime = current_time('Ymd_Hi');
				
				$File_Subject = $Post_Title;
				$rule = 'Any-Latin; Latin-ASCII; Lower;';

				$File_Subject = Transliterator::create($rule)->transliterate($File_Subject); 
				$File_Subject = html_entity_decode ($File_Subject);
				$File_Subject = sanitize_file_name ($File_Subject);			
				
				$File_Title = $User_Name .' ' .$DateTime;
				$File_Title = Transliterator::create($rule)->transliterate($File_Title); 
				$File_Title = html_entity_decode ($File_Title);
				$File_Title = sanitize_file_name ($File_Title);			
				
				$File_Name = $File_Subject .'-' .$File_Title .'.xls';				
								
				$Headers 			= wp_list_pluck( $GV_Table_Columns, 'label' );			
				$Fields_ID 			= wp_list_pluck( $GV_Table_Columns, 'id' );
				$Custom_Headers 	= wp_list_pluck( $GV_Table_Columns, 'custom_label' );
				$Custom_Content 	= wp_list_pluck( $GV_Table_Columns, 'content' );			
				$Date_Format 		= wp_list_pluck( $GV_Table_Columns, 'date_display' );
				
				// Hide Columns. PRO Version.
				
				// Any types of GV Fields - any Headers.
				foreach ($Custom_Headers as $key => $value) {
					if ($value != '') {						
						$Headers[$key] = $value;
					}
				}

				// Alternative Headers for Excel. PRO Version.

				$Headers = array_values($Headers);			
			
				$Data_Sheet = array();
				$Data_Sheet[] = $Headers;	

				foreach ( $Entries as $Entry ) {
					$Data_Row = array();			
					
					foreach ( $Fields_ID as $key => &$value ) {
						$Data_Cell = isset($Entry[$value]) ? sanitize_text_field( wp_unslash( $Entry[$value] ) ) : '';
						
						if ($value == 'custom') {
							// Not Easy Fields: Formula, Shortcode...
							if ( class_exists( 'GFCommon' ) ) {	
								$Data_Cell = $Custom_Content[$key];	
								$Data_Cell = GFCommon::replace_variables( $Data_Cell, $Form, $Entry, false, true, true, 'html', array () );
							}
						}				
						
						if ($Date_Format[$key]) {
							// Field type "Date". Need convert to Excel.
							$Data_Cell = gmdate("Y.m.d", strtotime($Data_Cell));
							$Data_Cell = PHPExcel_Shared_Date::PHPToExcel($Data_Cell);
						}
						
						$Data_Row[] = $Data_Cell;					
					}
					
					$Data_Sheet[] = $Data_Row;
				}

				// Note About DateRange;
				$Note_About_DateRange = '';
				if ($Date_Start) {
					$Note_About_DateRange .= $Date_Start .' - ';
				} else {
					$Note_About_DateRange .= 'frome begin - ';
				}

				if ($Date_End) {
					$Note_About_DateRange .= $Date_End;
				} else {
					$Note_About_DateRange .= current_time('Y-m-d');
				}				
				
				$xls = new PHPExcel();		

				$xls -> getProperties() -> setTitle("GVXL Reports. $File_Title");
				$xls -> getProperties() -> setSubject($File_Subject);
				$xls -> getProperties() -> setCreator($User_Name);
				$xls -> getProperties() -> setCompany("My Company");
				$xls -> getProperties() -> setCategory("Back-Office");			
				$xls -> getProperties() -> setDescription("Top Secret. $Description");				
				
				$xls -> setActiveSheetIndex(0);
				$sheet = $xls -> getActiveSheet();
				$sheet -> setTitle($Note_About_DateRange);		

				$sheet -> getColumnDimension("A") -> setWidth(1.0);
				
				// "A1". Any others start Cells may Conflicted of data Indexes.
				$Start_Column 	= 'A';
				$Start_Row 		= 1;
				$Start_Cell 	= $Start_Column .$Start_Row;
								
				$sheet->fromArray($Data_Sheet, null, $Start_Cell);
				
				$Last_Column 	= $sheet -> getHighestDataColumn();
				$Last_Row 		= $sheet -> getHighestDataRow();

				$ColumnIterator = $sheet -> getColumnIterator();

				// Cell Styles.
				$Borders_Thin = array(
					'borders'=>array(
						'outline' => array(
							'style' => PHPExcel_Style_Border::BORDER_THIN,
							'color' => array('rgb' => '000000')
						),
					)
				);

				// Post Processing.
				$i = 0;
				foreach( $ColumnIterator as $Column ) {
					$Column_Index = $Column -> getColumnIndex();
					
					// AutoSize Column 
					$sheet -> getColumnDimension( $Column_Index ) -> setAutoSize(true);
					
					// Formating Headers.
					$Cell = $Column_Index .$Start_Row;					
					
					$sheet -> getStyle($Cell) -> getFont() -> setBold(true);
					$sheet -> getStyle($Cell) -> getAlignment() -> setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
					$sheet -> getStyle($Cell) -> applyFromArray($Borders_Thin);

					// Formating Column type: "Date"
					$Date_Format_Column 		= array_slice($Date_Format, $i, 1);					
					$Date_Format_Column_Value 	= array_values ($Date_Format_Column)[0];
					$Date_Format_Column_Key 	= array_keys ($Date_Format_Column)[0];

					if ($Date_Format_Column_Value) {
						// Formate: Date Excel - not formates: Date PHP. (Y, M, F, n, j - and others, not correct.)
						
						// const FORMAT_DATE_YYYYMMDD2 = 'yyyy-mm-dd';
						// const FORMAT_DATE_YYYYMMDD = 'yy-mm-dd';
						// const FORMAT_DATE_DDMMYYYY = 'dd/mm/yy';
						// const FORMAT_DATE_DMYSLASH = 'd/m/y';
						// const FORMAT_DATE_DMYMINUS = 'd-m-y';
						
						$Date_Format_Column_Value = str_replace("y", "yy", $Date_Format_Column_Value);
						$Date_Format_Column_Value = str_replace("Y", "yyyy", $Date_Format_Column_Value);
						$Date_Format_Column_Value = str_replace("F", "mm", $Date_Format_Column_Value);						
						$Date_Format_Column_Value = str_replace("M", "mm", $Date_Format_Column_Value);
						$Date_Format_Column_Value = str_replace("m", "mm", $Date_Format_Column_Value);
						$Date_Format_Column_Value = str_replace("mmmm", "mm", $Date_Format_Column_Value);
						$Date_Format_Column_Value = str_replace("n", "m", $Date_Format_Column_Value);												
						$Date_Format_Column_Value = str_replace("d", "dd", $Date_Format_Column_Value);
						$Date_Format_Column_Value = str_replace("j", "d", $Date_Format_Column_Value);
						
						$sheet->getStyle($Column_Index .($Start_Row + 1) .':' .$Column_Index .$Last_Row) -> getNumberFormat() -> setFormatCode($Date_Format_Column_Value);
					}

					$i = $i + 1;	
				}
				
				ob_end_clean();
				
				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment;filename=' .$File_Name);
				header('Cache-Control: max-age=0');

				$writer = PHPExcel_IOFactory::createWriter($xls, 'Excel5');				
			
				$writer -> save('php://output');
			}
		}
	}