<?php
/*
Plugin Name: Users Login Monitor
Plugin URI: https://wpgear.xyz/users-login-monitor
Description: Ext Security. Dashboard & Daily-Digest about users activity whith WhoIs. Check out the features of the PRO version: <a href="http://wpgear.xyz/users-login-monitor-pro/">"Users Login Monitor PRO"</a>.
Version: 5.21
Text Domain: users-login-monitor
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/
	
	$UsersLoginMonitor_Plugin_URL = plugin_dir_url( __FILE__ ); // со слэшем на конце
	
	$admin_email = get_option('admin_email');

	$UsersLoginMonitor_LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';
	// __('Ext Security. Dashboard & Daily-Digest about users activity whith WhoIs. Check out the features of the PRO version: <a href="http://wpgear.xyz/users-login-monitor-pro/">"Users Login Monitor PRO"</a>.', 'users-login-monitor');	
	
	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/admin/admin.php' );
	include_once( __DIR__ .'/includes/admin/users.php' );
	include_once( __DIR__ .'/includes/admin/widgets.php' );
	
	/* Translate.
	----------------------------------------------------------------- */
	add_action ('init', 'UsersLoginMonitor_Action_init');
	function UsersLoginMonitor_Action_init() {
		// Translate.
		global $UsersLoginMonitor_LocalePath;		
		
		load_plugin_textdomain ('users-login-monitor', false, $UsersLoginMonitor_LocalePath);
		
		// Create Digest and Send, if a new day has come.
		global $wpdb;
		
		$UsersLoginMonitor_Options = UsersLoginMonitor_Get_Options();
		
		$UsersLoginMonitor_Digest_Enable 	= $UsersLoginMonitor_Options['digest_enable'];
		$UsersLoginMonitor_Digest_Email 	= $UsersLoginMonitor_Options['digest_email'];
		
		if($UsersLoginMonitor_Digest_Enable) {
            $ULM_Digest_OK = false;
			
			$timestamp = gmdate('Y-m-d H:i:s');
			$timezone = get_option('gmt_offset');
			$TimeStamp_data = strtotime ($timestamp) + $timezone * 3600;
			$Today = gmdate ("Y.m.d", $TimeStamp_data);
			$Digest_TimeStamp = gmdate ("Y.m.d  H:i", $TimeStamp_data);			
			
			// TimeStamp Отправки Дайджеста.
			$UsersLoginMonitor_Digest_Sent = get_option('ulm_digest_date', '0000.00.00' );
			$Records = 0;
			
			if ($Today != $UsersLoginMonitor_Digest_Sent) {				
				$usermeta_table = $wpdb -> prefix .'usermeta';
				$users_table 	= $wpdb -> prefix .'users';
				
				$Query = "SELECT * FROM $usermeta_table WHERE meta_key = 'ulm_lastlogin' AND %d ORDER BY meta_value DESC";
				$users = $wpdb -> get_results ($wpdb -> prepare ($Query, 1)); // phpcs:ignore 

				$Report_Table = "
					<table style='width: 100%; border-collapse: collapse; border-style: solid; border-width: 2px;'>
						<tbody>
							<tr style='border-style: solid; border-width: thin; background-color: #4CAF50; color: white;'>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>Login</th>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>Name</th>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>Role</th>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>Last Login</th>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>IP Address</th>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>Device</th>
							</tr>
				";
						
				foreach ($users as $user) {
					$User_ID = $user -> user_id;
					
					$meta_key = 'ulm_triger';
					$User_toDigest = get_user_meta ($User_ID, $meta_key, true);	
					
					if ($User_toDigest) {
						// Включаем в Дайджест.
						$Records = $Records + 1;
						
						$ULM_Digest_OK = true;
						
						$LastLogin = gmdate('Y-m-d H:i', strtotime ($user->meta_value));

						$Query = "SELECT user_login, display_name FROM $users_table WHERE ID = %d";						
						$User_Detail = $wpdb -> get_row ($wpdb -> prepare ($Query, $User_ID)); // phpcs:ignore 
						
						$User_Login 		= $User_Detail->user_login;
						$User_DisplayName	= $User_Detail->display_name;
						
						$meta_key = 'ulm_user_ip';
						$User_IP = get_user_meta ($User_ID, $meta_key, true);
						
						$meta_key = 'ulm_browser';
						$Browser_Log = get_user_meta ($User_ID, $meta_key, true);
						
						$User_Info 	= get_userdata ($User_ID);
						$User_Roles = implode (', ', $User_Info -> roles);				

						$Report_Table .= "
							<tr>	
								<td style='border: 1px solid #ddd; padding: 8px;'>$User_Login</td>
								<td style='border: 1px solid #ddd; padding: 8px;'>$User_DisplayName</td>
								<td style='border: 1px solid #ddd; padding: 8px;'>$User_Roles</td>
								<td style='border: 1px solid #ddd; padding: 8px;'>$LastLogin</td>				
								<td style='border: 1px solid #ddd; padding: 8px;'>$User_IP</td>
								<td style='border: 1px solid #ddd; padding: 8px;'>$Browser_Log</td>								
							</tr>
						";
						
						$meta_key = 'ulm_triger';
						$meta_value = '0';
						update_user_meta ($User_ID, $meta_key, $meta_value);
					}				
				}
			
				update_option ('ulm_digest_date', $Today);
				update_option ('ulm_digest_size', $Records);
				
                $Report_Table .= "</tbody></table>";
			}
			

			if ($ULM_Digest_OK) {
				// Send Digest.
				// $Site_title = get_bloginfo('name');
				// $subject = "$Site_title | Users Login Monitor. Daily-Digest.";
				$subject = "Users Login Monitor. Daily-Digest.";
				
				// $admin_email = get_option('admin_email');
				// $from = $admin_email;
				
				// $headers[] = "From: Users Login Monitor <$from>";
				$headers[] = "Content-Type: text/html";
				$headers[] = "charset=UTF-8";
				
				$to = $UsersLoginMonitor_Digest_Email;
				
				$message = "Users Login Monitor. Daily-Digest $Digest_TimeStamp\r\n\r\n";
				$message .= $Report_Table;			
				
				// формируем HTML контент вместо Text, т.к почему-то нарушается форматирование текста. Переводы строки не работают ((
				$message = wpautop($message);
				wp_mail($to, $subject, $message, $headers);		
			}	
		}

		// Init Active Users Processing. Update Users-Data Transient
		UsersLoginMonitor_Update_UsersData_Transient ();		
	}
	
	/* After Login
	----------------------------------------------------------------- */
	add_action ('wp_login', 'UsersLoginMonitor_Action_wp_login', 10, 2);
	function UsersLoginMonitor_Action_wp_login ($user_login, $user) {
		global $wpdb;

		$User_ID 		= $user -> ID;
		$user_login 	= $user -> user_login;
		$display_name	= $user -> display_name;
		
		$timestamp = gmdate ('Y-m-d H:i:s');
		$timezone = get_option ('gmt_offset');
		$TimeStamp_data = strtotime ($timestamp) + $timezone * 3600;
		$TimeStamp_str = gmdate ("Y-m-d H:i:s", $TimeStamp_data);	

		$user_ip = isset ($_SERVER['REMOTE_ADDR']) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : null;
		$user_ip = isset ($_SERVER['HTTP_X_FORWARDED_FOR']) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) : $user_ip;
		$user_ip = isset ($_SERVER['HTTP_X_REAL_IP']) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_REAL_IP'] ) ) : $user_ip;
        
		// Try use Browscap PHP Lib.
        $browser = get_browser(null, true);
		
		$browser_log = '---';
		
		if ($browser) {
			$browser_log = $browser['browser'] .', ' .$browser['platform'] .', ' .$browser['device_type'];
		} else {
            // Try use Plugin: 'Quick Browscap'. https://wordpress.org/plugins/quick-browscap/
            global $quick_browscap;

            if (isset($quick_browscap) && is_object($quick_browscap)) {
                $bw_info = $quick_browscap->get_browser(null, true);

                $browser_log = $bw_info['Browser'] .', ' .$bw_info['Platform'];
            }
        }

		if ($user_ip) {
			$WhoIs = json_decode (UsersLoginMonitor_Get_WhoIs ($user_ip));

			$WhoIs_asn 			= $WhoIs -> as;
			$WhoIs_country 		= $WhoIs -> country;
			$WhoIs_city			= $WhoIs -> city;
			$WhoIs_countryCode 	= $WhoIs -> countryCode;
			$WhoIs_isp 			= $WhoIs -> isp;
			$WhoIs_org 			= $WhoIs -> org;

			$IP_Details = $WhoIs_isp ." | " .$WhoIs_country." | " .$WhoIs_city ." | " .$WhoIs_asn;					
		} else {
			$user_ip = '---';
			$IP_Details = '---';
		}

		$meta_key = 'ulm_lastlogin';
		$meta_value = $TimeStamp_str;
		update_user_meta ($User_ID, $meta_key, esc_html( $meta_value ));
		
		$meta_key = 'ulm_user_ip';
		$meta_value = $user_ip;
		update_user_meta ($User_ID, $meta_key, esc_html( $meta_value ));	

		$meta_key = 'ulm_browser';
		$meta_value = $browser_log;
		update_user_meta ($User_ID, $meta_key, esc_html( $meta_value ));
		
		$meta_key = 'ulm_whois';
		$meta_value = $IP_Details;
		update_user_meta ($User_ID, $meta_key, esc_html( $meta_value ));		

		$meta_key = 'ulm_triger';
		$meta_value = 1;
		update_user_meta ($User_ID, $meta_key, esc_html( $meta_value ));
		
		$meta_key = 'ulm_count_login_total';
		$meta_value = intval (get_user_meta ($User_ID, $meta_key, true));
		update_user_meta ($User_ID, $meta_key, esc_html( $meta_value + 1 ));

		$meta_key = 'ulm_count_login_success';
		$meta_value = intval (get_user_meta ($User_ID, $meta_key, true));
		update_user_meta ($User_ID, $meta_key, esc_html( $meta_value + 1 ));
	}	
	
	/* Login Failed
	----------------------------------------------------------------- */	
	add_action ('wp_login_failed', 'UsersLoginMonitor_Action_wp_login_failed');	
	function UsersLoginMonitor_Action_wp_login_failed($username){
		$User = get_user_by('login', $username);
		
		$User_ID = null;
		
		if ($User) {
		   $User_ID = $User->ID;
		} else {
			$User = get_user_by('email', $username);
			
			if ($User) {
			   $User_ID = $User->ID;
			}			
		}
		
		if ($User_ID) {
			$meta_key = 'ulm_count_login_total';
			$meta_value = intval (get_user_meta ($User_ID, $meta_key, true));
			update_user_meta ($User_ID, $meta_key, esc_html( $meta_value + 1 ));
		}
	}	