<?php
/*
 * WPGear. 
 * Hack-Info
 * schedules.php
 */
 
	/* Scheduler. Инициализация.
	----------------------------------------------------------------- */	
	function HackInfo_Scheduler_Init() {
		$debug_process = 'f_scheduler_init';
		
		$HackInfo_Digest_Enable = HackInfo_Get_Options('digest_enable');
		HackInfo_Debugger ($HackInfo_Digest_Enable, '$HackInfo_Digest_Enable', $debug_process, __FUNCTION__, __LINE__);
		
		if ($HackInfo_Digest_Enable) {
			// Отправка Уведомлений.
			if (!wp_next_scheduled('hackinfo_send_digest')) {
				wp_schedule_event(time(), 'hackinfo_digest_timer', 'hackinfo_send_digest');	
			}
		}
	}
	
	/* Scheduler. Регистрируем интервал.
	----------------------------------------------------------------- */		
	add_filter( 'cron_schedules', 'HackInfo_Filter_cron_schedules' );
	function HackInfo_Filter_cron_schedules ($schedules) {	
		$debug_process = 'f_cron_schedules';
		
		$HackInfo_Digest_Enable = HackInfo_Get_Options('digest_enable');
		HackInfo_Debugger ($HackInfo_Digest_Enable, '$HackInfo_Digest_Enable', $debug_process, __FUNCTION__, __LINE__);
		
		if ($HackInfo_Digest_Enable) {
			// Период отправки Уведомлений.
			$HackInfo_Digest_Timer = HackInfo_Get_Options('digest_timer');
			HackInfo_Debugger ($HackInfo_Digest_Timer, '$HackInfo_Digest_Timer', $debug_process, __FUNCTION__, __LINE__);

			$schedules['hackinfo_digest_timer'] = array(
				'interval' => 3600 * $HackInfo_Digest_Timer,
				'display'  => "Every $HackInfo_Digest_Timer H"
			);			
		}			
		
		HackInfo_Debugger ($schedules, '$schedules', $debug_process, __FUNCTION__, __LINE__);
		return $schedules;
	}

	/* Scheduler. Отправка Уведомлений.
	----------------------------------------------------------------- */	
	add_action('hackinfo_send_digest', 'HackInfo_do_send_digest');	
	
	/* Scheduler. Клиринг при деактивации.
	----------------------------------------------------------------- */	
	register_deactivation_hook( __FILE__, 'HackInfo_deactivation');
	function HackInfo_deactivation() {
		wp_clear_scheduled_hook('hackinfo_scan_log');
	}	