<?php
/*
Plugin Name: Hack-Info
Plugin URI: https://wpgear.xyz/hack-info
Description: Ext Security. Monitoring about evil hacking attempts.
Version: 4.24
Text Domain: hack-info
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	global $HackInfo_db_version;
	$HackInfo_db_version = '3';	// Проверка необходимости модификации Таблиц в DB.	
	
	$HackInfo_plugin_url = plugin_dir_url ( __FILE__ ); 							// со слэшем на конце	
	$HackInfo_plugin_dir = plugin_dir_path ( __FILE__ ); 							// со слэшем на конце	
	
	$HackInfo_WhoIs_MaxBox 	= 150;													// Максимальное количество IP адресов для одного запроса.	
	
	$HackInfo_LocalePath = dirname (plugin_basename (__FILE__)) . '/languages/';
	// __('Ext Security. Monitoring about evil hacking attempts.', 'hack-info');	
	
	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/schedules.php' );
	include_once( __DIR__ .'/includes/init.php' );
	include_once( __DIR__ .'/includes/admin/admin.php' );
		
	register_activation_hook( __FILE__, 'hackinfo_install' ); // hack-info\includes\init.php
	add_action( 'plugins_loaded', 'HackInfo_Create_Tables' );	
	
	global $HackInfo_Version;
	$HackInfo_Version = '';
	
	/* Init. Инициализация.
	----------------------------------------------------------------- */ 
	add_action ('init', 'HackInfo_Action_Init', 10);
	function HackInfo_Action_Init () {
		$debug_process = 'action_init';
		
		global $HackInfo_Version;
		
		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		
		$Plugin_Data = get_plugin_data( __FILE__ );
		$HackInfo_Version = $Plugin_Data['Version'];

		// Scheduler. Инициализация.
		HackInfo_Scheduler_Init();
		
		// Translate.
		global $HackInfo_LocalePath;		
		
		load_plugin_textdomain ('hack-info', false, $HackInfo_LocalePath);		
	}	
	
	/* Проверка запросов к сайту. 
		Error 404
	----------------------------------------------------------------- */		
	add_action ('wp_head', 'HackInfo_Action_wp_head' );
	function HackInfo_Action_wp_head() {
		$HackInfo_Digest_Enable = HackInfo_Get_Options('digest_enable');
		
		if ($HackInfo_Digest_Enable) {
			if (is_404()) {
				// Такой страницы не существует. Получаем подробности.
				$Type = 'scan';
				
				$IP = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field (wp_unslash($_SERVER['REMOTE_ADDR'])) : '';
				$IP = isset($_SERVER['HTTP_X_REAL_IP']) ? sanitize_text_field (wp_unslash($_SERVER['HTTP_X_REAL_IP'])) : $IP;

				$Page_URL = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field (wp_unslash($_SERVER['REQUEST_URI'])) : '';
				
				HackInfo_Save_Event ($IP, $Type, $Page_URL);
			}
		}
	}
		
	/* Неудачная попытка входа.
	----------------------------------------------------------------- */	
	add_action ('wp_login_failed', 'HackInfo_Action_wp_login_failed', 10);
	function HackInfo_Action_wp_login_failed ($Login) {
		$HackInfo_Digest_Enable = HackInfo_Get_Options('digest_enable');
		
		if ($HackInfo_Digest_Enable) {
			$Type = 'brute_force';
			
			$IP = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : '';
			$IP = isset($_SERVER['HTTP_X_REAL_IP']) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_REAL_IP'] ) ) : $IP;

			HackInfo_Save_Event ($IP, $Type, $Login);
		}		
	}	