<?php
/*
 * WPGear.
 * Dismiss Gravity Notices
 * widgets.php
 */
	
	/* Create Dismiss Gravity Notices DashboardWidget
	----------------------------------------------------------------- */		
	add_action('wp_dashboard_setup', 'DGN_Action_wp_dashboard_setup');
	function DGN_Action_wp_dashboard_setup() {
        if (current_user_can('edit_dashboard')) {
			global $wp_meta_boxes;
			
			wp_add_dashboard_widget('dgn_widget', esc_html( __('Dismissed Gravity Notices', 'dismiss-gravity-notices') ), 'DGN_Dashboard_Widget');			
		}
	}	

	/* Dismiss Gravity Notices DashboardWidget
	----------------------------------------------------------------- */	
	function DGN_Dashboard_Widget() {
		global $DGN_Notices;

        $DGN_Notices_Content = '';
        $Notices_Title = ''; 
        $Notices_Msg = '';

        ob_start();

        if ($DGN_Notices) {
            $i = 1;		    

            ?>
            <div class="dgn_notices_box">
                <ul>
                    <?php 					
                    foreach ($DGN_Notices as $notice) {
                        $Notices_Title  = $notice['title'];
                        $Notices_Msg    = $notice['message'];

                        $Element_Notices_ID = "dgn_notice_msg_$i";
                        ?>
                        <li>
                            <div class="dgn_notice_title" title="Click for details" onclick="DGN_Show_Notice(<?php echo esc_html( $i ); ?>)">
                                <?php echo esc_html( $Notices_Title );?>
                            </div>

                            <div id="<?php echo esc_html( $Element_Notices_ID ); ?>" class="dgn_notice_msg" style="display: none;">
                                <?php echo $Notices_Msg; // phpcs:ignore ?>
                            </div>
                        </li>
                        <?php                
                        $i = $i+1;
                    }

                    ?>
                </ul>

                <div id="dgn_btn_close" class="dgn_btn_close" style="display: none;">
                    <span title="Click for Hide all opened Notices" onclick="DGN_Hide_Notice()"><?php echo esc_html( __('Hide', 'dismiss-gravity-notices') ); ?></span>
                </div>

                <script>
                    function DGN_Show_Notice (Notice_ID) {
                        document.getElementById ('dgn_notice_msg_' + Notice_ID).style.display = 'block';
                        document.getElementById ('dgn_btn_close').style.display = 'block';
                    }

                    function DGN_Hide_Notice () {
                        DGN_Elements = document.querySelectorAll("[id^='dgn_notice_msg_']");

                        var i;
                        for (i = 0; i < DGN_Elements.length; i++) {
                            DGN_Elements[i].style.display = 'none';
                        }

                        document.getElementById ('dgn_btn_close').style.display = 'none';
                    }
                </script>
            </div>
            <?php              
        } else {
            ?>
            <div><?php echo esc_html( __('nothing', 'dismiss-gravity-notices') ); ?></div>
            <?php 
        }
        
        $DGN_Notices_Content = ob_get_clean();

        echo $DGN_Notices_Content; // phpcs:ignore
	}		
	