<?php
/*
 * WPGear. Notice Interceptor
 * options.php
 */
 
	$NI_Nonce = 'Update_Options_Notice Interceptor';
	$nonce = wp_create_nonce ($NI_Nonce);
	
	$NI_Action 			= isset($_REQUEST['action']) ? sanitize_text_field (wp_unslash( $_REQUEST['action'])) : null;
	$NI_Custom_Rules 	= isset($_REQUEST['notice_interceptor_option_customrules']) ? sanitize_textarea_field (wp_unslash( $_REQUEST['notice_interceptor_option_customrules'])) : null;
	$NI_Setup_AdminOnly = isset($_REQUEST['notice_interceptor_option_adminonly']) ? 1 : 0;	
	$NI_Clearing 		= isset($_REQUEST['notice_interceptor_option_clearing']) ? 1 : 0;	
	$WP_Nonce 			= isset($_REQUEST['_wpnonce']) ? sanitize_text_field (wp_unslash($_REQUEST['_wpnonce'])) : 'none';
	
	if ($NI_Action == 'Update') {
		if (!wp_verify_nonce($WP_Nonce, $NI_Nonce)) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="wdpq_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'notice-interceptor') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}

		$NI_Custom_Rules = NtcIntrcptr_Prepare_Rules ($NI_Custom_Rules);		
		
		update_option('notice-interceptor_rules_custom', $NI_Custom_Rules); // phpcs:ignore			
		update_option('notice-interceptor_option_adminonly', $NI_Setup_AdminOnly); // phpcs:ignore
		update_option('notice-interceptor_option_clearing', $NI_Clearing); // phpcs:ignore
		
	} else {
		$NI_Custom_Rules 	= get_option('notice-interceptor_rules_custom', array());
		$NI_Setup_AdminOnly = get_option('notice-interceptor_option_adminonly', 1);
		$NI_Clearing 		= get_option('notice-interceptor_option_clearing', 1);
	}	
	
	if ($NI_Setup_AdminOnly) {
		if (!current_user_can('edit_dashboard')) {
			?>
			<div class="notice_interceptor_warning" style="margin: 40px;">				
				<?php echo esc_html( __('Sorry, you are not allowed to view this page.', 'notice-interceptor') ); ?>
			</div>
			<?php
			
			return;
		}		
	}
	
	$NI_Custom_Rules_txt = '';
	
	foreach ($NI_Custom_Rules as $NI_Custom_Rule) {
		$NI_Custom_Rules_txt .= "$NI_Custom_Rule\r\n";
	}
	
	?>
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
		<hr>
		
		<div class="notice_interceptor_options_box">
			<form name="form_NI_Options" method="post" style="margin-top: 20px;">
				<h3><?php echo esc_html( __('General', 'notice-interceptor') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<div style="margin-top: 10px;">
						<label for="notice_interceptor_option_adminonly" title="On/Off">
							<?php echo esc_html( __('Enable this Page for Admin only', 'notice-interceptor') ); ?>
						</label>
						<input id="notice_interceptor_option_adminonly" name="notice_interceptor_option_adminonly" type="checkbox" <?php if( $NI_Setup_AdminOnly ) {echo 'checked';} ?>>
					</div>				
					
					<div style="margin-top: 10px;">
						<label for="notice_interceptor_option_customrules" title="one rule per line">
							<?php echo esc_html( __('Custom Rules', 'notice-interceptor') ); ?> (<?php echo esc_html( count( $NI_Custom_Rules ) ); ?>):
						</label>
						<textarea id="notice_interceptor_option_customrules" name="notice_interceptor_option_customrules" rows="4" class="notice_interceptor_option_customrules"><?php echo esc_html( $NI_Custom_Rules_txt ); ?></textarea>					
					</div>
					<div style="margin-left: 20px;">
						<p>
							<?php echo esc_html( __('* To avoid processing errors, you should include the complete set of notification block classes that you want to block. For example:', 'notice-interceptor') ); ?>
						</p>
						<p class="notice_interceptor_option_customrules_sample">
							&lt;div <span style="font-weight: bold;">class="<span style="color: brown;">notice notice-warning settings-error is-dismissible</span>"</span>&gt;You have a newer version WordPress 999.01 than it can be!&lt;a href="//wp-admin/update-core.php" aria-label="Please update WordPress now"&gt;Please update&lt;/a&gt;.&lt;/div&gt;
						</p>
						<p>
							<?php echo esc_html( __('We need to take from this block the complete line of the class attribute:', 'notice-interceptor') ); ?>
						</p>
						<p style="font-weight: bold; color: brown;">
							<?php echo esc_html( __('notice notice-warning settings-error is-dismissible', 'notice-interceptor') ); ?>
						</p>
						<p>
							<?php echo esc_html( __('and insert into the: "Custom Rules".', 'notice-interceptor') ); ?>
						</p>
						<p>
							<?php echo esc_html( __('* Also, you can add ID instead of Class.', 'notice-interceptor') ); ?>
						</p>
					</div>
				</div>

				<hr>
				
				<h3><?php echo esc_html( __('Clearing', 'notice-interceptor') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">				
					<div style="margin-top: 20px;">
						<label for="notice_interceptor_option_clearing" title="On/Off">
							<?php echo esc_html( __('Delete MetaData with Uninstall Plugin.', 'notice-interceptor') ); ?>
						</label>
						<input id="notice_interceptor_option_clearing" name="notice_interceptor_option_clearing" type="checkbox" <?php if($NI_Clearing) {echo 'checked';} ?>>
					</div>
				</div>
				
				<hr>
				
				<div style="margin-top: 10px; margin-bottom: 5px; text-align: right;">
					<input id="notice_interceptor_btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_html( __('Save', 'notice-interceptor') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="Update">
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($nonce); ?>">	
			</form>
		</div>			
	</div>
