<?php
/*
 * WPGear. Plugin Notes Label
 * functions.php
 */
 
	/* Get Options
	----------------------------------------------------------------- */
	function PluginNotesLabel_Get_Options () {
		$PluginNotesLabel_Options = get_option( "plugin-note-label_options", array(
			'adminonly' => 1,
			'show_author' => 1,
			'show_date' => 1,
			'clearing' => 1,
			'export' => '',
			)
		);

		return $PluginNotesLabel_Options;
	}
	
	/* Get Count of Labels
	----------------------------------------------------------------- */
	function PluginNotesLabel_Get_CountLabels () {
		global $wpdb;
		
		$Options_table = $wpdb -> prefix .'options';
		
		$Query = "
			SELECT COUNT(*)
			FROM $Options_table
			WHERE (option_name LIKE 'plugin-note-label_%' AND option_name != 'plugin-note-label_options')
		";
		
		$CountLabels = $wpdb -> get_var ($wpdb -> prepare ($Query)); // phpcs:ignore	
		
		return $CountLabels;
	}
	
	/* Get Labels
	----------------------------------------------------------------- */
	function PluginNotesLabel_Get_Labels () {
		global $wpdb;
		
		$Options_table = $wpdb -> prefix .'options';
		
		$Query = "
			SELECT * 
			FROM $Options_table
			WHERE (option_name LIKE 'plugin-note-label_%' AND option_name != 'plugin-note-label_options')
		";
		
		$Records = $wpdb -> get_results ($wpdb -> prepare ($Query)); // phpcs:ignore
		
		return $Records;
	}
	
	/* Delete Labels
	----------------------------------------------------------------- */
	function PluginNotesLabel_Delete_Labels () {
		global $wpdb;
		
		$PluginNotesLabel_options_table = $wpdb -> prefix .'options';
		
		$Query = "
			DELETE 
			FROM $PluginNotesLabel_options_table 
			WHERE (option_name LIKE 'plugin-note-label_%' AND option_name != 'plugin-note-label_options')
		";
		
		$wpdb -> query($Query); // phpcs:ignore
		
		return true;
	}