<?php
/*
 * WPGear. Page and Post Description
 * options.php
 */
 
	$PageAndPostDescription_Nonce = 'Update_Options_PageAndPostDescription';
	$nonce = wp_create_nonce ($PageAndPostDescription_Nonce);	

	$PageAndPostDescription_Action = isset($_REQUEST['action']) ? sanitize_text_field (wp_unslash( $_REQUEST['action'])) : null; 
	$WP_Nonce = isset($_REQUEST['_wpnonce']) ? sanitize_text_field (wp_unslash($_REQUEST['_wpnonce'])) : 'none';

	if ($PageAndPostDescription_Action == 'update') {
		if (!wp_verify_nonce($WP_Nonce, $PageAndPostDescription_Nonce)) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="wdpq_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'page-and-post-description') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}
		
		// Save Options.
		$PageAndPostDescription_Setup_AdminOnly 	= isset($_REQUEST['pnpd_option_adminonly']) ? 1 : 0;
		$PageAndPostDescription_Setup_ShowAuthor 	= isset($_REQUEST['pnpd_option_show_author']) ? 1 : 0;
		$PageAndPostDescription_Setup_ShowDate 		= isset($_REQUEST['pnpd_option_show_date']) ? 1 : 0;
		$PageAndPostDescription_Setup_PageEnable 	= isset($_REQUEST['pnpd_option_page_enable']) ? 1 : 0;
		$PostAndPostDescription_Setup_PostEnable 	= isset($_REQUEST['pnpd_option_post_enable']) ? 1 : 0;
		$PageAndPostDescription_Setup_Clearing 		= isset($_REQUEST['pnpd_option_clering']) ? 1 : 0;

		$PageAndPostDescription_Options = array(
			'adminonly' => $PageAndPostDescription_Setup_AdminOnly,
			'show_author' => $PageAndPostDescription_Setup_ShowAuthor,
			'show_date' => $PageAndPostDescription_Setup_ShowDate,
			'page_enable' => $PageAndPostDescription_Setup_PageEnable,
			'post_enable' => $PostAndPostDescription_Setup_PostEnable,
			'clearing' => $PageAndPostDescription_Setup_Clearing,			
		);	
			
		update_option('page-and-post-description_options', $PageAndPostDescription_Options); // phpcs:ignore
	}

	$PageAndPostDescription_Options = get_option("page-and-post-description_options", array(
		'adminonly' => 1,
		'show_author' => 0,
		'show_date' => 0,
		'page_enable' => 1,
		'post_enable' => 1,
		'clearing' => 0,
		)
	);

	$PageAndPostDescription_Setup_AdminOnly 	= isset($PageAndPostDescription_Options['adminonly']) ? intval($PageAndPostDescription_Options['adminonly']) : 1;	
	$PageAndPostDescription_Setup_ShowAuthor 	= isset($PageAndPostDescription_Options['show_author']) ? intval($PageAndPostDescription_Options['show_author']) : 0;	
	$PageAndPostDescription_Setup_ShowDate 		= isset($PageAndPostDescription_Options['show_date']) ? intval($PageAndPostDescription_Options['show_date']) : 0;	
	$PageAndPostDescription_Setup_Clearing 		= isset($PageAndPostDescription_Options['clearing']) ? intval($PageAndPostDescription_Options['clearing']) : 0;	
	$PageAndPostDescription_Setup_PageEnable	= isset($PageAndPostDescription_Options['page_enable']) ? intval($PageAndPostDescription_Options['page_enable']) : 1;	
	$PostAndPostDescription_Setup_PostEnable	= isset($PageAndPostDescription_Options['post_enable']) ? intval($PageAndPostDescription_Options['post_enable']) : 1;

	if ($PageAndPostDescription_Setup_AdminOnly) {
		if (!current_user_can('edit_dashboard')) {
			?>
			<div class="pageandpostdescription_options_warning" style="margin: 40px;">
				<?php echo esc_html( __('Sorry, you are not allowed to view this page.', 'page-and-post-description') ); ?>
			</div>
			<?php
			
			return;
		}		
	}	

	?>
	<style>
		.pnpd_about_pro {
			background: aliceblue;
			padding: 5px;
			border-radius: 9px;
		}
		.pnpd_about_pro ul {
			list-style: initial;
		}
		.pnpd_about_pro li {
			margin-top: 5px;
			margin-left: 40px;
		}
	</style>
	
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
		<hr>
		
		<div id="pnpd_option_box" style="margin-left: 20px;">			
			<form name="form_PageAndPostDescription_Options" method="post" style="margin-top: 20px;">
				<h3><?php echo esc_html( __('General', 'page-and-post-description') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<div style="margin-top: 10px;">
						<label for="pnpd_option_adminonly" title="On/Off">
							<?php echo esc_html( __('Enable this Page for Admin only.', 'page-and-post-description') ); ?>
						</label>
						<input id="pnpd_option_adminonly" name="pnpd_option_adminonly" type="checkbox" <?php if($PageAndPostDescription_Setup_AdminOnly) {echo 'checked';} ?>>
					</div>	

					<div style="margin-top: 20px; margin-left: 42px;">
						<label for="pnpd_option_show_author" title="On/Off">
							<?php echo esc_html( __('Show Description Author.', 'page-and-post-description') ); ?>
						</label>
						<input id="pnpd_option_show_author" name="pnpd_option_show_author" type="checkbox" <?php if($PageAndPostDescription_Setup_ShowAuthor) {echo 'checked';} ?>>
					</div>		

					<div style="margin-top: 10px; margin-left: 54px;">
						<label for="pnpd_option_show_date" title="On/Off">
							<?php echo esc_html( __('Show Description Date.', 'page-and-post-description') ); ?>
						</label>
						<input id="pnpd_option_show_date" name="pnpd_option_show_date" type="checkbox" <?php if($PageAndPostDescription_Setup_ShowDate) {echo 'checked';} ?>>
					</div>	
				</div>
				
				<hr>

				<h3><?php echo esc_html( __('Post Type', 'page-and-post-description') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">				
					<div style="margin-top: 20px; margin-left: 72px;">
						<label for="pnpd_option_page_enable" title="On/Off">
							<?php echo esc_html( __('Enable on Page List', 'page-and-post-description') ); ?>
						</label>
						<input id="pnpd_option_page_enable" name="pnpd_option_page_enable" type="checkbox" <?php if($PageAndPostDescription_Setup_PageEnable) {echo 'checked';} ?>>
					</div>		

					<div style="margin-top: 10px; margin-left: 76px;">
						<label for="pnpd_option_post_enable" title="On/Off">
							<?php echo esc_html( __('Enable on Post List', 'page-and-post-description') ); ?>
						</label>
						<input id="pnpd_option_post_enable" name="pnpd_option_post_enable" type="checkbox" <?php if($PostAndPostDescription_Setup_PostEnable) {echo 'checked';} ?>>
					</div>	

					<div class="pnpd_about_pro" style="margin-top: 20px;">
						<ul>
							<?php echo esc_html( __('Check out the features of the PRO version: ', 'page-and-post-description') ); ?>
							<a href="https://wpgear.xyz/page-and-post-description-pro/"><?php echo esc_html( __('"Page and Post Description PRO:"', 'page-and-post-description') ); ?></a>
							<li><?php echo esc_html( __('Works for any Castoms Post-Types.', 'page-and-post-description') ); ?></li>					
							<li><?php echo esc_html( __('Automatic finding of all Castoms Post-Types and their connection.', 'page-and-post-description') ); ?></li>
						</ul>				
					</div>					
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Clearing', 'page-and-post-description') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">				
					<div style="margin-top: 20px;">
						<label for="pnpd_option_clering" title="On/Off">
							<?php echo esc_html( __('Delete MetaData with Uninstall Plugin.', 'page-and-post-description') ); ?>
						</label>
						<input id="pnpd_option_clering" name="pnpd_option_clering" type="checkbox" <?php if($PageAndPostDescription_Setup_Clearing) {echo 'checked';} ?>>
					</div>
				</div>
				
				<hr>				
				
				<div style="margin-top: 10px; margin-bottom: 5px; text-align: right;">
					<input id="pnpd_btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_html( __('Save', 'page-and-post-description') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="update">	
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($nonce); ?>">					
			</form>
		</div>			
	</div>
