<?php
/*
 * WPGear. Page and Post Description
 * admin.php
 */

	/* Create plugin SubMenu
	----------------------------------------------------------------- */		
	add_action('admin_menu', 'PageAndPostDescription_create_menu');		
	function PageAndPostDescription_create_menu() {
		add_options_page(
			'Page and Post Description',
			'Page and Post Description',
			'publish_posts',
			'page-and-post-description/options.php',
			''
		);	
	}	
	
	/* Add Field 'Description' to Page and Post Metabox
	----------------------------------------------------------------- */
	add_action( 'add_meta_boxes', 'PageAndPostDescription_Add_MetaField' );	
	function PageAndPostDescription_Add_MetaField() {
		global $PageAndPostDescription_Options;

		$PageAndPostDescription_Page_Enable = isset($PageAndPostDescription_Options['page_enable']) ? intval($PageAndPostDescription_Options['page_enable']) : 1;	
		$PageAndPostDescription_Post_Enable = isset($PageAndPostDescription_Options['post_enable']) ? intval($PageAndPostDescription_Options['post_enable']) : 1;	
				
		$Screens = array ();

		if ($PageAndPostDescription_Page_Enable) {
			array_push ($Screens, "page");
		}

		if ($PageAndPostDescription_Post_Enable) {
			array_push ($Screens, "post");
		}
		
		add_meta_box( 
			'PageAndPostDescription_MetaField', 
			__('Description', 'page-and-post-description'), 
			'PageAndPostDescription_MetaField_Callback', 
			$Screens, 
			'advanced', 
			'high', 
			null 
		);
	}	

	/* Metabox Description.
	----------------------------------------------------------------- */	
	function PageAndPostDescription_MetaField_Callback ($Post, $Meta) {
		$Metabox_Description = "";
		
		$Post_ID = $Post -> ID;
		
		if ($Post_ID) {
			$PageAndPostDescription_Note = get_post_meta ($Post_ID, 'pnpd_metadata', true );
			
			$Note_Description 	= isset($PageAndPostDescription_Note['content']) ? sanitize_text_field(wp_unslash( $PageAndPostDescription_Note['content'])) : '';	
			$Note_User			= isset($PageAndPostDescription_Note['user']) ? sanitize_text_field(wp_unslash( $PageAndPostDescription_Note['user'])) : '';	
			$Note_Date			= isset($PageAndPostDescription_Note['date']) ? sanitize_text_field(wp_unslash( $PageAndPostDescription_Note['date'])) : '';
			
			if ($Note_User) {
				$Metabox_Description = "[$Note_User]";
			}
			
			if ($Note_Date) {
				$Metabox_Description .= " $Note_Date";
			}
		}		

		$Metabox_Description .= "<div style='margin-top: 5px;'>";
		$Metabox_Description .= "<textarea name='pnpd_description' rows='2' style='width: 100%;'>$Note_Description</textarea>";
		$Metabox_Description .= "</div>";	
		
		echo esc_html( $Metabox_Description );
	}

	/* Save Metabox Description.
	----------------------------------------------------------------- */
	add_action( 'save_post', 'PageAndPostDescription_Save_MetaField');	
	function PageAndPostDescription_Save_MetaField ($Post_ID) {	
		$Item_Content = isset($_REQUEST['pnpd_description']) ? sanitize_text_field(wp_unslash( $_REQUEST['pnpd_description'] )) : null; // phpcs:ignore
		// Not - sanitize_textarea_field. В Описаниях не должно быть переносов строк. Иначе, будет плохо выглядеть в Списках.
		
		if ($Item_Content) {
			$Date = current_time('d.m.Y');
			
			$current_user = wp_get_current_user();	
			$User_Name = $current_user -> user_login;	

			$Item_MetaData = array(
				'user' => $User_Name,
				'content' => $Item_Content,
				'date' => $Date
			);			

			update_post_meta ($Post_ID, 'pnpd_metadata', $Item_MetaData);
		}
	}	