<?php
/*
 * WPGear. 
 * Import Excel to Gravity Forms
 * loader.php
 */

	/* Styles & Scripts for Gravity Forms Pages.
	----------------------------------------------------------------- */		
	add_action ('gform_enqueue_scripts', 'GFXLImport_Action_gform_enqueue_scripts', 10, 2 );
	function GFXLImport_Action_gform_enqueue_scripts ($form = '', $is_ajax = false) {	
		if (isset($_REQUEST['edit'])) { // phpcs:ignore
			// Не отображаем Кнопку на странице Редактирования Записи.					
		} else {
			$GFXLImport_GFormID = $form['id'];		
			$GFXLImport_Form_Enable = (isset($form['gfxl_import']) && $form['gfxl_import'] == 'on') ? true : false;		
			
			include_once ABSPATH .'wp-admin/includes/plugin.php'; // требуется для Функции: is_plugin_active на Фронте
			if (is_plugin_active ('gf-excel-import-pro/gf-excel-import-pro.php')) {
				// Имеется PRO версия "Import Excel to Gravity Forms PRO".
				if (isset($form['gfxl_import_pro']) && $form['gfxl_import_pro'] == 'on') {
					// Игнорируем запуск.
					$GFXLImport_Form_Enable = false;
				}
			}		
			
			if ($GFXLImport_Form_Enable) {
				global $GFXLImport_plugin_url;
				global $GFXLImport_CSV_Separator;
				global $GFXLImport_CSV_Encoding;
				
				$GFXLImport_Nonce = 'AJAX_Processing Import Excel to Gravity Forms';
				$nonce = wp_create_nonce ($GFXLImport_Nonce);
				
				wp_enqueue_script ( 'gfxl_import', $GFXLImport_plugin_url .'includes/import_records.js' ); // phpcs:ignore
				wp_enqueue_style ( 'gfxl_import_style', $GFXLImport_plugin_url .'style.css' ); // phpcs:ignore			
				wp_enqueue_style ( 'font-awesome_4.7', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css' ); // phpcs:ignore
				
				$GFXLImport_JS_Global = array (
					'CSV_Separator' => $GFXLImport_CSV_Separator,
					'Ajax_URL' => admin_url ('admin-ajax.php'),
					'GFXLImport_GFormID' => $GFXLImport_GFormID,
					'CSV_Encoding' => $GFXLImport_CSV_Encoding,
					'_wpnonce' => $nonce,
				);			
				
				wp_localize_script( 'gfxl_import', 'GFXLImport_Params', $GFXLImport_JS_Global ); // phpcs:ignore
			} 
		}		
	}	
	