<?php
/*
 * WPGear. 
 * Import Excel to Gravity Forms
 * options.php
 */
 
	$GFXLImport_Nonce = 'Update_Options Import Excel to Gravity Forms';
	$nonce = wp_create_nonce ($GFXLImport_Nonce);
	
	$GFXLImport_Action 			= isset( $_REQUEST['action'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['action'] ) ) : null;
	$GFXLImport_Setup_AdminOnly = isset( $_REQUEST['gfxl_import_option_adminonly'] ) ? 1 : 0;	
	$GFXLImport_CSV_Separator	= isset( $_REQUEST['gfxl_import_option_separator'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['gfxl_import_option_separator'] ) ) : ',';
	$GFXLImport_CSV_Encoding	= isset( $_REQUEST['gfxl_import_option_encoding'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['gfxl_import_option_encoding'] )) : 'utf-8';
	$GFXLImport_Setup_Clearing	= isset( $_REQUEST['gfxl_import_option_clering'] ) ? 1 : 0;
	$WP_Nonce 					= isset( $_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : 'none';
	
	if ($GFXLImport_Action == 'Update') {	
		if (!wp_verify_nonce($WP_Nonce, $GFXLImport_Nonce)) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="wdpq_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'gf-excel-import') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}
		
		update_option( 'gfxl_import_option_adminonly', $GFXLImport_Setup_AdminOnly ); // phpcs:ignore
		update_option( 'gfxl_import_option_separator', $GFXLImport_CSV_Separator) ; // phpcs:ignore
		update_option( 'gfxl_import_option_encoding', $GFXLImport_CSV_Encoding) ; // phpcs:ignore
		update_option( 'gfxl_import_option_clearing', $GFXLImport_Setup_Clearing ); // phpcs:ignore
	} else {
		$GFXLImport_Setup_AdminOnly = get_option( 'gfxl_import_option_adminonly', 1 );
		$GFXLImport_CSV_Separator 	= get_option( 'gfxl_import_option_separator', ',' );
		$GFXLImport_CSV_Encoding 	= get_option( 'gfxl_import_option_encoding', 'utf-8' );
		$GFXLImport_Setup_Clearing 	= get_option( 'gfxl_import_option_clearing', 1 );
	}	
	
	if ($GFXLImport_Setup_AdminOnly) {
		if (!current_user_can('edit_dashboard')) {
			?>
			<div class="gfxl_import_warning" style="margin: 40px;">
				<?php echo esc_html( __('Sorry, you are not allowed to view this page.', 'gf-excel-import') ); ?>
			</div>
			<?php
			
			return;
		}		
	}
	
	?>
	<style>
		.gfxl_import_about_pro {
			margin-top: 20px;
			background: aliceblue;
			padding: 5px;
			border-radius: 9px;	
		}
		.gfxl_import_about_pro ul {
			list-style: initial;
		}
		.gfxl_import_about_pro li {
			margin-top: 5px;
			margin-left: 40px;
		}
	</style>
	
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() );?></h2>
		<hr>
		
		<div class="gfxl_import_options_box">
			<form name="form_GFXLImport_Options" method="post" style="margin-top: 20px;">
				<h3><?php echo esc_html( __('General', 'gf-excel-import') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<div style="margin-top: 10px;">
						<label for="gfxl_import_option_adminonly" title="On/Off">
						<?php echo esc_html( __('Enable this Page for Admin only.', 'gf-excel-import') ); ?>
						</label>
						<input id="gfxl_import_option_adminonly" name="gfxl_import_option_adminonly" name="gfxl_import_option_adminonly" type="checkbox" <?php if($GFXLImport_Setup_AdminOnly) {echo 'checked';} ?>>
					</div>
				</div>

				<hr>
				
				<h3><?php echo esc_html( __('CSV', 'gf-excel-import') ); ?></h3>					
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<div style="margin-top: 10px;">
						<label for="gfxl_import_option_separator" title="On/Off">
						<?php echo esc_html( __('CSV Separator', 'gf-excel-import') ); ?>
						</label>
						<input id="gfxl_import_option_separator" name="gfxl_import_option_separator" class="gfxl_import_option_separator" type="text" maxlength="1" value="<?php echo esc_attr( $GFXLImport_CSV_Separator ); ?>">
					</div>	

					<div style="margin-top: 20px;">
						<label for="gfxl_import_option_encoding" title="On/Off">
						<?php echo esc_html( __('CVS Encoding', 'gf-excel-import') ); ?>
						</label>
						<input id="gfxl_import_option_encoding" name="gfxl_import_option_encoding" class="gfxl_import_option_encoding" type="text" maxlength="12" value="<?php echo esc_attr( $GFXLImport_CSV_Encoding ); ?>">
						<span>utf-8, ISO-8859-1, CP1251, ...</span>
					</div>	
				</div>					

				<hr>
				
				<h3><?php echo esc_html( __('Clearing', 'gf-excel-import') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">				
					<div style="margin-top: 20px;">
						<label for="gfxl_import_option_clering" title="On/Off">
							<?php echo esc_html( __('Delete MetaData with Uninstall Plugin.', 'gf-excel-import') ); ?>
						</label>
						<input id="gfxl_import_option_clering" name="gfxl_import_option_clering" type="checkbox" <?php if($GFXLImport_Setup_Clearing) {echo 'checked';} ?>>
					</div>
				</div>
				
				<div style="margin-top: 10px; margin-bottom: 5px; text-align: right;">
					<input id="gfxl_import_btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_html( __('Save', 'gf-excel-import-pro') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="Update">
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr( $nonce ); ?>">
			</form>
		</div>

		<div class="gfxl_import_about_pro">
			<ul>
				<?php echo esc_html( __('Check out the features of the PRO version:', 'gf-excel-import') ); ?> <a href="https://wpgear.xyz/import-excel-to-gravity-forms-pro/">"<?php echo esc_html( __('Import Excel to Gravity Forms PRO', 'gf-excel-import') ); ?>"</a>
				<li><?php echo esc_html( __('Ability to select data type (Name / Value) for Fields: "Select", "MultiSelect", "Radio", "CheckBox".', 'gf-excel-import') ); ?></li>
				<li><?php echo esc_html( __('Generation of a Template for easy filling of the Import Table. Template - Excel file in XLSX format.', 'gf-excel-import') ); ?></li>
				<li><?php echo esc_html( __('The Template contains: Field IDs, Fields Name, Type and Prompts for input.', 'gf-excel-import') ); ?></li>
				<li><?php echo esc_html( __('Input Prompts contain all Valid Variants for a given Field, given the selected data type (Name / Value).', 'gf-excel-import') ); ?></li>
			</ul>				
		</div>	
	</div>
