// WPGear. Import Excel to Gravity Forms
// import_records.js
window.addEventListener("load", GFXLImport_JS_OnLoad);

function GFXLImport_JS_OnLoad () {
	console.log('import_records.js Loaded.');

	var GFXLImport_Ajax_Data = '';	
	var GFXLImport_Ajax_URL 		= GFXLImport_Params['Ajax_URL'];	
	var GFXLImport_CSV_Separator 	= GFXLImport_Params['CSV_Separator'];	
	var GFXLImport_GFormID			= GFXLImport_Params['GFXLImport_GFormID'];
	var GFXLImportCSV_Encoding		= GFXLImport_Params['CSV_Encoding'];
	var GFXLImport_Ajax_Nonce		= GFXLImport_Params['_wpnonce'];
	
	var GFXLImport_GForm = document.getElementById('gform_' + GFXLImport_GFormID);

	if (GFXLImport_GForm) {			
		var GFXLImport_Ajax_Data = '';	
		var GFXLImport_Ajax_URL 		= GFXLImport_Params['Ajax_URL'];	
		var GFXLImport_CSV_Separator 	= GFXLImport_Params['CSV_Separator'];
		var GFXLImport_ValueType_for_Select	= 'name';
		
		var GFXLImport_CountRecords = 0;
		var GFXLImport_Button_Submit = document.getElementById ("gform_submit_button_" + GFXLImport_GFormID);
		
		var CountLines;
		var Lines;
		var Records_Import_Status;
		var Record;
		var Fields;
		var CountFields;
		var Fields_ID;
		var Fields_Name;
		var Fields_Value;
		var Error;
		var CountErrors;
		
		// Import Box.
		var GFXLImport_ImportBox = document.createElement("div");
			GFXLImport_ImportBox.id = "gfxl_import_records_box";
			GFXLImport_ImportBox.className = "gfxl_import_records_box";
			GFXLImport_ImportBox.style.borderWidth = '0px';
			
		GFXLImport_GForm.insertAdjacentElement("beforebegin", GFXLImport_ImportBox);
		
		// Button: Import
		var GFXLImport_Button_Import = document.createElement("input");
			GFXLImport_Button_Import.id = "gfxl_import_btn_import_records";
			GFXLImport_Button_Import.type = "button";
			GFXLImport_Button_Import.className = "gfxl_import_btn_import_records gfxl_import_btn_dialog";
			GFXLImport_Button_Import.value = "Excel Import";
			GFXLImport_Button_Import.onclick = GFXLImport_Show_Import_box;
	
		GFXLImport_ImportBox.appendChild (GFXLImport_Button_Import);
		
		// Button: Upload
		var GFXLImport_Button_Import_Upload = document.createElement("input");
			GFXLImport_Button_Import_Upload.id = "gfxl_import_btn_records_upload";
			GFXLImport_Button_Import_Upload.type = "button";
			GFXLImport_Button_Import_Upload.className = "gfxl_import_btn_records_upload gfxl_import_btn_dialog";
			GFXLImport_Button_Import_Upload.value = "Upload CSV file";
			GFXLImport_Button_Import_Upload.onclick = GFXLImport_Show_Import_FileUpload;
			GFXLImport_Button_Import_Upload.style.display = 'none';
	
		GFXLImport_ImportBox.appendChild (GFXLImport_Button_Import_Upload);		
		
		// Button: File Upload
		var GFXLImport_Button_Import_FileUpload = document.createElement("input");
			GFXLImport_Button_Import_FileUpload.id = "gfxl_import_btn_file_upload";
			GFXLImport_Button_Import_FileUpload.type = "file";
			GFXLImport_Button_Import_FileUpload.className = "gfxl_import_btn_file_upload gfxl_import_btn_dialog";
			GFXLImport_Button_Import_FileUpload.onchange = GFXLImport_HandleFileSelect;
			GFXLImport_Button_Import_FileUpload.style.color = 'royalblue';
			GFXLImport_Button_Import_FileUpload.style.display = 'none';

		GFXLImport_ImportBox.appendChild (GFXLImport_Button_Import_FileUpload);

		// Info Box
		var GFXLImport_ImportBox_InfoBox = document.createElement("div");
			GFXLImport_ImportBox_InfoBox.id = "gfxl_import_infobox";
			GFXLImport_ImportBox_InfoBox.innerHTML = "";
			GFXLImport_ImportBox_InfoBox.className = "gfxl_import_records_infobox";
			GFXLImport_ImportBox_InfoBox.style.display = 'none';
			
		GFXLImport_ImportBox.appendChild (GFXLImport_ImportBox_InfoBox);
		
		// Controls Box
		var GFXLImport_ImportBox_ControlsBox = document.createElement("div");
			GFXLImport_ImportBox_ControlsBox.id = "gfxl_import_controlsbox";
			GFXLImport_ImportBox_ControlsBox.className = "gfxl_import_records_controlsbox";
			GFXLImport_ImportBox_ControlsBox.style.display = 'none';
			
		GFXLImport_ImportBox.appendChild (GFXLImport_ImportBox_ControlsBox);
		
		// Controls Box. Records
		var GFXLImport_ImportBox_ControlsBox_Records = document.createElement("div");
			GFXLImport_ImportBox_ControlsBox_Records.id = "gfxl_import_controlsbox_records";
			GFXLImport_ImportBox_ControlsBox_Records.innerHTML = "";
			GFXLImport_ImportBox_ControlsBox_Records.className = "gfxl_import_controlsbox_records";
			
		GFXLImport_ImportBox_ControlsBox.appendChild (GFXLImport_ImportBox_ControlsBox_Records);	

		// Controls Box. Buttons
		var GFXLImport_ImportBox_ControlsBox_Buttons = document.createElement("div");
			GFXLImport_ImportBox_ControlsBox_Buttons.id = "gfxl_import_controlsbox_buttons";
			GFXLImport_ImportBox_ControlsBox_Buttons.className = "gfxl_import_controlsbox_buttons";
			
		GFXLImport_ImportBox_ControlsBox.appendChild (GFXLImport_ImportBox_ControlsBox_Buttons);		

		// Button: Cancel
		var GFXLImport_Button_Import_Cancel = document.createElement("input");
			GFXLImport_Button_Import_Cancel.id = "gfxl_import_btn_cancel";
			GFXLImport_Button_Import_Cancel.type = "button";
			GFXLImport_Button_Import_Cancel.className = "gfxl_import_btn_cancel gfxl_import_btn_dialog";
			GFXLImport_Button_Import_Cancel.value = "Cancel";
			GFXLImport_Button_Import_Cancel.onclick = GFXLImport_Hide_Import_box;
			
		GFXLImport_ImportBox_ControlsBox_Buttons.appendChild (GFXLImport_Button_Import_Cancel);		
		
		// Button: Submit
		var GFXLImport_Button_Import_Submit = document.createElement("input");
			GFXLImport_Button_Import_Submit.id = "gfxl_import_btn_record_submit";
			GFXLImport_Button_Import_Submit.type = "button";
			GFXLImport_Button_Import_Submit.className = "gfxl_import_btn_record_submit gfxl_import_btn_dialog";
			GFXLImport_Button_Import_Submit.value = "Save";
			GFXLImport_Button_Import_Submit.onclick = GFXLImport_Submit;	
			GFXLImport_Button_Import_Submit.style.display = 'none';
			
		GFXLImport_ImportBox_ControlsBox_Buttons.appendChild (GFXLImport_Button_Import_Submit);			
	}
	
	// Show Import Box
	function GFXLImport_Show_Import_box () {
		GFXLImport_ImportBox.style.borderWidth = '1px';
		
		GFXLImport_Button_Import.style.display = 'none';
		GFXLImport_Button_Import_Upload.style.display = 'block';
		GFXLImport_ImportBox_ControlsBox.style.display = 'block';
		GFXLImport_ImportBox_ControlsBox_Records.innerHTML = "";
		GFXLImport_Button_Import_Submit.style.display = 'none';		
	}
	
	// Cancel. Hide Import Box
	function GFXLImport_Hide_Import_box () {
		GFXLImport_ImportBox.style.borderWidth = '0px';		
		GFXLImport_Button_Import_FileUpload.value= null;
		GFXLImport_Button_Import_FileUpload.style.display = 'none';		
		GFXLImport_ImportBox_ControlsBox.style.display = 'none';
		GFXLImport_ImportBox_ControlsBox_Records.innerHTML = "";
		GFXLImport_Button_Import.style.display = 'block';
		GFXLImport_Button_Import_Upload.style.display = 'none';
		GFXLImport_ImportBox_InfoBox.style.display = 'none';
		
		GFXLImport_Button_Submit.style.display = 'block';		
	}
	
	// Show Upload Box
	function GFXLImport_Show_Import_FileUpload () {
		GFXLImport_ImportBox_ControlsBox_Records.innerHTML = '';
		GFXLImport_Button_Import_Upload.style.display = 'none';						
		GFXLImport_Button_Import_FileUpload.style.display = 'block';		
		GFXLImport_ImportBox_InfoBox.style.display = 'none';		
		GFXLImport_Button_Import_Submit.style.display = 'none';
	}
	
	// Uploading CSV
	function GFXLImport_HandleFileSelect (Event) {
		GFXLImport_Button_Import_Submit.style.display = 'none';		
		
		var File = Event.target.files[0];
		
		var File_Name = File.name;
		var File_Size = File.size;
		var File_Type = File.type;
				
		if (File_Type == 'application/vnd.ms-excel' || File_Type == 'application/csv' || File_Type == 'text/csv' || File_Type == 'application/wps-office.xls')  {
			// CSV
			var reader = new FileReader();			
			// reader.onerror = errorHandler;
			
			reader.onload = (function(theFile) {
			return function(e) {
				var Result = this.result;			
				Lines = Result.split('\r\n');
				
				var Line_Fields_ID = Lines[0];
				Fields_ID = Line_Fields_ID.split(GFXLImport_CSV_Separator);
				CountFields = Fields_ID.length;

				CountLines = Lines.length;
				
				Records_Import_Status = [];
				Fields_Value = [];

				GFXLImport_CountRecords = 0;
				
				for (var i = 0; i < CountFields; i ++){	
					// Очищаем ID от мусора.
					var Field_ID = Number(Fields_ID[i].trim());
					Fields_ID[i] = Field_ID;	
				}					
				
				for (var Line = 1; Line < CountLines; Line ++){	
					Records_Import_Status[GFXLImport_CountRecords] = 0;

					// Могут быть Пустые Строки или Строки с Пустыми Значениями. Их необходимо удалить.
					var StrLine = Lines[Line];
					StrLine = StrLine.split(GFXLImport_CSV_Separator).join("");
					StrLine = StrLine.trim();
					
					if (StrLine != "") {
						GFXLImport_CountRecords ++;
					}					
				}

				GFXLImport_ImportBox_InfoBox.style.display = 'block';
				
				if (GFXLImport_CountRecords > 0) {
					Record = 1;
					
					GFXLImport_ImportBox_InfoBox.innerHTML = "<div class='gfxl_import_records_infobox_filename'>" + File_Name + "</div>";
					GFXLImport_ImportBox_ControlsBox_Records.innerHTML = "<span style='float: left;'><span class='gfxl_import_btn_records_arrow' title='Backward'><i id='gfxl_import_btn_records_arrow_left' class='fa fa-2x fa-chevron-circle-left' aria-hidden='true'></i></span><span id='gfxl_import_btn_records_info' class='gfxl_import_btn_records_info'>Record: " + Record + " from " + GFXLImport_CountRecords + "</span><span class='gfxl_import_btn_records_arrow' title='Forward'><i id='gfxl_import_btn_records_arrow_right' class='fa fa-2x fa-chevron-circle-right' aria-hidden='true'></i></span></span>";
					GFXLImport_ImportBox_ControlsBox_Records.innerHTML += "<span id='gfxl_import_btn_import_records_processing' class='gfxl_import_btn_import_records_processing' style='display: inline-block;'><i class='fa fa-circle-o-notch fa-2x fa-spin fa-fw' aria-hidden='true'></i></span>";

					// Валидация Данных. Заполнение Select/Radio. Запись.
					GFXLImport_Get_Fields (Record);
				} else {
					GFXLImport_ImportBox_ControlsBox_Records.innerHTML = "File does not contain Data!";	
				}			
				
				// Отключаем GF кнопку "Сохранить"
				GFXLImport_Button_Submit.style.display = 'none';
				
			};
			})(File);
	
			reader.readAsText(File, GFXLImportCSV_Encoding);			
		} else {
			// Недопустимый Тип Файла.
			console.log('Invalid File Type');	
			
			GFXLImport_ImportBox_InfoBox.style.display = 'block';
			GFXLImport_ImportBox_InfoBox.innerHTML = "Invalid File Type!";
		}
		
		GFXLImport_Button_Import_FileUpload.value= '';
		GFXLImport_Button_Import_FileUpload.style.display = 'none';
		GFXLImport_Button_Import_Upload.style.display = 'block';			
	}
	
	// Get Fields from CSV Record
	function GFXLImport_Get_Fields (Record) {
		GFXLImport_Button_Submit.style.display = 'none';
		document.getElementById ('gfxl_import_btn_import_records_processing').style.display = 'inline-block';		
		document.getElementById ('gfxl_import_btn_records_info').innerHTML = "Record: " + Record + " from " + GFXLImport_CountRecords;
		
		if (Records_Import_Status[Record - 1] == 0) {
			// не сохраненная Запись
			document.getElementById ('gfxl_import_btn_records_info').style.color = 'black';
			document.getElementById ('gfxl_import_btn_records_info').title = '';
		} else {
			// сохраненная Запись
			document.getElementById ('gfxl_import_btn_records_info').style.color = 'green';
			document.getElementById ('gfxl_import_btn_records_info').title = 'This Record is Already Saved.';
		}
		
		GFXLImport_Clear_Fields();	

		if (Record <= GFXLImport_CountRecords) {
			Fields_Value = Lines[Record].split(GFXLImport_CSV_Separator);

			Fields = [];

			// Очищаем от мусора.
			for (var i = 0; i < CountFields; i ++){
				var Field_ID = Fields_ID[i];
				
				var Field_Value = Fields_Value[i];
				Field_Value = GFXLImport_ReplaceAll (Field_Value, '""', "'");
				Field_Value = GFXLImport_ReplaceAll (Field_Value, '"', "");
				Field_Value = GFXLImport_ReplaceAll (Field_Value, "'", '"');

				Field_Value = Field_Value.trim();		

				Fields_Value[i] = Field_Value;

				var Field = {
					id: Field_ID, 
					value: Field_Value
				};

				Fields.push(Field); 
			}		
			
			GFXLImport_Ajax_Data = {
				'action': 'gfxl_import',
				'mode': 'get_fields',
				'gf_id': GFXLImport_GFormID,
				'fields': Fields,
				'_wpnonce': GFXLImport_Ajax_Nonce,
				};	

			jQuery.ajax({
				type:"POST",
				url: GFXLImport_Ajax_URL,
				dataType: 'json',
				data: GFXLImport_Ajax_Data,
				cache: false,
				success: function(jsondata) {
					var Obj_Request = jsondata;	
					
					var Status		= Obj_Request.status;
					var Answer 		= Obj_Request.answer;
						Error 		= Obj_Request.error;
					var Error_Msg 	= Obj_Request.error_msg;
						Fields 		= Obj_Request.fileds;
					
					console.log(Obj_Request);					
					
					if (Answer) {
						CountErrors = 0;
						
						for (var i = 0; i < CountFields; i ++){	
							var Field_ID 		= Fields[i]['id'];
							var Input_ID 		= Fields[i]['input_id'];
							var Field_Value 	= Fields[i]['value'];
							var Field_Choice 	= Fields[i]['choice'];
							var Field_Type 		= Fields[i]['type'];
							var Field_Error 	= Fields[i]['error'];
							var Field_ErrorMsg 	= Fields[i]['error_msg'];
							
							Field_Value = GFXLImport_ReplaceAll (Field_Value, "\\", "");							
							
							if (Field_Error) {
								console.log('F:' + Field_ID + ' [Type: ' + Field_Type + '] ' + Fields_Value[i] + ' -> ' + Field_Value + ' | Error: ' + Field_ErrorMsg);
								
								CountErrors ++;
								
								// Выделяем Поля с Ошибками заполнения.
								document.getElementById ("field_" + GFXLImport_GFormID + "_" + Field_ID).style.background = 'red';
							} else {
								if (GFXLImport_ValueType_for_Select == 'name') {
									console.log('F:' + Field_ID + ' [Type: ' + Field_Type + '] ' + Fields_Value[i] + ' -> ' + Field_Value);
								} else {
									// PRO Version
								}
							
								try {
									var Element_ID;
									var Element;

									if (Field_Type == 'textarea') {
										// tinyMCE. Rich Text Editor
										Element_ID = Input_ID;
										
										try {
											tinyMCE.get(Element_ID).setContent(Field_Value);
										}
										catch(err) {
											// No tinyMCE Field mode
										}											
										
										Element = document.getElementById (Element_ID);
										Element.value = Field_Value;
									} else if (Field_Type == 'radio') {
										// Radio
										Element_ID = Input_ID;
										
										Element = document.getElementById (Element_ID);
										Element.checked = 'true';									
									} else if (Field_Type == 'checkbox') {
										for (var j = 0; j < Input_ID.length; j ++){	
											Element_ID = Input_ID[j];
											
											Element = document.getElementById (Element_ID);
											Element.checked = 'true';
										}										
									} else if (Field_Type == 'multiselect') {
										//MultiSelect
										Element_ID = Input_ID;		

										Field_Value = JSON.parse(Field_Value);

										jQuery('#' + Element_ID).val(Field_Value);
									} else {
										// Обычные остальные Поля.
										Element_ID = Input_ID;
										
										Element = document.getElementById (Element_ID);
										Element.value = Field_Value;
									}
									
									jQuery('#' + Element_ID).change(); // Симмуляция
								}
								catch(err) {
									console.log('Element: ' + Element_ID + ' Not Found');
								}							
							}							
						}

						document.getElementById ('gfxl_import_btn_import_records_processing').style.display = 'none';					
						GFXLImport_Button_Import_Submit.style.display = 'inline-block';
						
						GFXLImport_Clear_Errors ();
						
						if (Error) {
							GFXLImport_Button_Import_Submit.disabled = true;
							
							document.getElementById ('gfxl_import_btn_records_info').style.color = 'red';
							document.getElementById ('gfxl_import_btn_records_info').title = Error_Msg;
							
							// Ловушка Исправления Полей с Ошибками заполнения.
							document.addEventListener("change", function(e){
								if (Error) {							
									var Element_ID 		= e.target.id;
									var Element_Name 	= e.target.name;
									var Field_Changed_ID = Element_Name.replace('input_', '');

									console.log(Field_Changed_ID);
									
									for (var i = 0; i < CountFields; i ++){	
										var Field_ID 	= Fields[i]['id'];
										var Field_Error = Fields[i]['error'];
										
										if (Field_Changed_ID == Field_ID) {
											if (Field_Error) {
												// Убираем выделение Ошибки этого Поля.
												document.getElementById ("field_" + GFXLImport_GFormID + "_" + Field_ID).style.background = 'initial';
												
												CountErrors --;
												
												if (CountErrors == 0) {
													GFXLImport_Clear_Errors ();												
												}
											}
										}
									}
								}
							});					
						} 
					}
				}
			});				
		} else {
			// Закончено.
			document.getElementById ('gfxl_import_btn_import_records_processing').style.display = 'none';		
			document.getElementById ('gfxl_import_btn_records_info').innerHTML = "Total: " + GFXLImport_CountRecords + ". Complete.";	
		}		
	}
	
	// Clear_Fields
	function GFXLImport_Clear_Fields () {
		var Field_ID;
		var Element_ID;
		var Field;
		
		for (var i = 0; i < CountFields; i ++){	
			Field_ID = Fields_ID[i];

			Field = "field_" + GFXLImport_GFormID + "_" + Field_ID;
			Element_ID = "input_" + GFXLImport_GFormID + "_" + Field_ID;			
						
			try {
				document.getElementById (Element_ID).value = '';
				document.getElementById (Field).style.background = 'initial';
			}
			catch(err) {
				console.log('Element: ' + Element_ID + ' Not Found');
			}			
		}

		jQuery("[id^=choice_" + GFXLImport_GFormID + "]").prop('checked', false);	
		
		return true;		
	}	
	
	// Clear_Errors
	function GFXLImport_Clear_Errors() {		
		GFXLImport_Button_Import_Submit.disabled = false;
		
		return true;
	}	
	
	// Records Navi
	document.addEventListener("click", function(e){
		var Element_ID = e.target.id;
		
		if (Element_ID == 'gfxl_import_btn_records_arrow_left') {
			if (Record > 1) {
				Record = Record - 1;
				console.log('backward to: ' + Record + ' Status: ' + Records_Import_Status[Record]);
				
				GFXLImport_Get_Fields (Record);
			}
		}		
		
		if (Element_ID == 'gfxl_import_btn_records_arrow_right') {
			if (Record < GFXLImport_CountRecords) {
				Record = Record + 1;
				console.log('forward to :' + Record + ' Status: ' + Records_Import_Status[Record]);
				
				GFXLImport_Get_Fields (Record);
			}
		}		
	});	
	
	// Submit
	function GFXLImport_Submit () {
		console.log('GFXLImport_Submit');	
		
		Records_Import_Status[Record - 1] = 1;
		
		var GFXLImport_GForm_Fields_Element = GFXLImport_GForm.querySelectorAll('[name^="input_"]');

		var Required_Errors = false;
		var GF_Form_Fields = [];
		
		for (var i = 0; i < GFXLImport_GForm_Fields_Element.length; i ++){
			var GF_Form_Field_Name = GFXLImport_GForm_Fields_Element[i].name;
			var GF_Form_Field_Type = GFXLImport_GForm_Fields_Element[i].type;
			var GF_Form_Field_Value = GFXLImport_GForm_Fields_Element[i].value;
			var GF_Form_Field_ID = GF_Form_Field_Name.replace('input_', '');
			
			GF_Form_Field_ID = GFXLImport_ReplaceAll (GF_Form_Field_ID, '[]', '');
			
			if (GF_Form_Field_Type == 'checkbox') {
				// checkbox
				var IsChecked = Number(GFXLImport_GForm_Fields_Element[i].checked);
				
				if (! IsChecked) {
					GF_Form_Field_Value = '';
				}

				var GF_Form_Field = {
					id: GF_Form_Field_ID, 
					value: GF_Form_Field_Value
				};
				
				GF_Form_Field_ID = parseInt(GF_Form_Field_ID);
				
				GF_Form_Fields.push(GF_Form_Field);
			} else if (GF_Form_Field_Type == 'radio') {
				// radio
				var IsChecked = Number(GFXLImport_GForm_Fields_Element[i].checked);
								
				if (IsChecked) {
					GF_Form_Field_ID = parseInt(GF_Form_Field_ID);
					
					var GF_Form_Field = {
						id: GF_Form_Field_ID, 
						value: GF_Form_Field_Value
					};
					
					GF_Form_Fields.push(GF_Form_Field);
				}

				GF_Form_Field_ID = parseInt(GF_Form_Field_ID);
			} else if (GF_Form_Field_Type == 'select-multiple') {
				// multiselect
				GF_Form_Field_Value = '';
				var SelectOptionsSelected = [];

				for (var j = 0; j < GFXLImport_GForm_Fields_Element[i].length; j ++){
					var SelectOption = GFXLImport_GForm_Fields_Element[i][j];	
					var SelectOption_Selected = SelectOption.selected;
					
					if (SelectOption_Selected) {
						var SelectOption_Value = SelectOption.value;		
						
							if (SelectOption_Value) {
								SelectOptionsSelected.push(SelectOption_Value);
							}
					}	
				}

				if (SelectOptionsSelected.length > 0) {
					GF_Form_Field_Value = JSON.stringify(SelectOptionsSelected);
				}

				var GF_Form_Field = {
					id: GF_Form_Field_ID, 
					value: GF_Form_Field_Value
				};

				GF_Form_Fields.push(GF_Form_Field);
			} else {
				// others Field Type
				GF_Form_Field_ID = parseInt(GF_Form_Field_ID);
				
				var GF_Form_Field = {
					id: GF_Form_Field_ID, 
					value: GF_Form_Field_Value
				};

				GF_Form_Fields.push(GF_Form_Field);				
			}
			
			// Проверка на Required
			var Selector = "field_" + GFXLImport_GFormID + "_" + GF_Form_Field_ID;
			var GF_Form_Field_Box = document.querySelectorAll('[id$=' + Selector + ']')[0];
			var GF_Form_Field_Box_Classes = GF_Form_Field_Box.classList;			
			
			for (var j = 0; j < GF_Form_Field_Box_Classes.length; j ++){
				if (GF_Form_Field_Box_Classes[j] == 'gfield_contains_required') {
					//Required
					var GF_Form_Field_Style_Display = GF_Form_Field_Box.style.display;
					
					if (GF_Form_Field_Style_Display != 'none') {
						if (GF_Form_Field_Value == '') {
							Required_Errors = true;
							
							console.log('* Required: ' + GF_Form_Field_ID);
							document.getElementById ("field_" + GFXLImport_GFormID + "_" + GF_Form_Field_ID).style.background = 'red';
						} else {
							document.getElementById ("field_" + GFXLImport_GFormID + "_" + GF_Form_Field_ID).style.background = 'initial';
						}
					}
				}
			}
		}
		
		if (Required_Errors) {
			document.getElementById ('gfxl_import_btn_records_info').style.color = 'red';
			document.getElementById ('gfxl_import_btn_records_info').title = 'Not all Required Fields are filled.';
		} else {
			GFXLImport_Button_Import_Submit.style.display = 'none';
			
			document.getElementById ('gfxl_import_btn_records_info').style.color = 'black';
			document.getElementById ('gfxl_import_btn_records_info').title = '';	

			// Сохраняем Запись
			GFXLImport_Ajax_Data = {
				'action': 'gfxl_import',
				'mode': 'save',
				'gf_id': GFXLImport_GFormID,
				'fields': GF_Form_Fields,
				'_wpnonce': GFXLImport_Ajax_Nonce,
				};		
			
			jQuery.ajax({
				type:"POST",
				url: GFXLImport_Ajax_URL,
				dataType: 'json',
				data: GFXLImport_Ajax_Data,
				cache: false,
				success: function(jsondata) {
					var Obj_Request = jsondata;	
					
					var Status		= Obj_Request.status;
					var Answer 		= Obj_Request.answer;
					var Entry_ID	= Obj_Request.fileds;
					
					// console.log(Obj_Request);					

					if (Answer) {
						if (Entry_ID) {
							console.log('Saved. ' + Entry_ID);

							Record ++;
							
							GFXLImport_Get_Fields (Record)
						} else {
							console.log('No Saved. Errors!');
						}
					}
				}
			});				
		}		
	}
	
	// ReplaceAll Substring in String
	function GFXLImport_ReplaceAll (str, find, replace) {
		var escapedFind = find.replace (/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
		
		return str.replace (new RegExp(escapedFind, 'g'), replace);
	}	
}