<?php
/*
 * WPGear. 
 * Import Excel to Gravity Forms
 * ajax_processing.php
 */

	$GFXLImport_Nonce = 'AJAX_Processing Import Excel to Gravity Forms';
	$nonce = wp_create_nonce ($GFXLImport_Nonce);
	
	$Mode 		= isset($_REQUEST['mode']) ? sanitize_text_field( wp_unslash( $_REQUEST['mode'] ) ) : null;
	$GF_Form_ID = isset($_REQUEST['gf_id']) ? sanitize_text_field( wp_unslash( $_REQUEST['gf_id'] ) ) : null;
	$GF_Fields 	= isset($_REQUEST['fields']) ? $_REQUEST['fields'] : array(); // phpcs:ignore
	$WP_Nonce 	= isset($_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : 'none';	
	
	if (!wp_verify_nonce( $WP_Nonce, $GFXLImport_Nonce )) {
		exit;
	}	
	
	$Result = false;

	$Error = false;
	$Error_Msg = '';

	// get_fields and Validations.
	if ($Mode == 'get_fields') {
		if ($GF_Fields) {
			$GFXLImport_ValueType_for_Select = 'name';
			
			foreach ($GF_Fields as &$Item) {
				$Field_ID 	= $Item['id'];
				$Field_Arg 	= $Item['value'];
				
				$Item['error'] = false;
				
				if ($Field_ID) {					
					$Field = GFAPI::get_field ( $GF_Form_ID, $Field_ID );

					$Field_Type 	= $Field['type'];
					$Field_label 	= $Field['label'];
					$Field_Choices 	= $Field['choices'];
					$Field_Inputs	= $Field['inputs'];					

					$Item['input_id'] 	= 'input_' .$GF_Form_ID .'_' .$Field_ID;
					$Item['type'] 		= $Field_Type; 
					$Item['choice'] 	= '';

					if (in_array ($Field_Type, array ('select','multiselect','radio','checkbox','number') )) {						
						// Получаем Значения.
						if (isset($Field_Arg)) {
							$ChoiceError = true;

							if ($Field_Type == 'checkbox') {
								// Обработка Полей типа: CheckBox
								$Field_Arg = explode(",", $Field_Arg);					
											
								$Field_Choices_Flat = [];
								$Choices_Value = [];
								$Choices_Index = [];

								$ChoiceError = false;	

								foreach ($Field_Choices as $key => $Field_Choice) {
									if ($GFXLImport_ValueType_for_Select == 'name') {
										// Названия
										$Field_Choices_Flat[] = $Field_Choice['text'];

										foreach ($Field_Arg as $Arg) {
											if ($Arg == $Field_Choice['value']) {
												$Choices_Value[] = $Field_Choice['text'];
												$Choices_Index[] = 'choice_' .$GF_Form_ID .'_' .$Field_ID .'_' .($key + 1);				
											}
										}		
									} else {
										// Значения
										// PRO Version.
									}
								}

								foreach ($Field_Arg as $key => $value) {
									if ($value != '') {									
										if (! in_array ($value, $Field_Choices_Flat)) {
											$ChoiceError = true;	
										}
									}
								}									

								$Item['choice'] 	= $Choices_Value;
								$Item['value'] 		= wp_json_encode( $Field_Arg );	
								$Item['input_id'] 	= $Choices_Index;
							} else if ($Field_Type == 'select') {
								// Обработка Полей типа: Select
								foreach ($Field_Choices as $Field_Choice) {								
									if ($GFXLImport_ValueType_for_Select == 'name') {
										// Названия
										if ($Field_Arg == $Field_Choice['text']) {									
											$Item['value'] = $Field_Choice['value'];									
											
											$ChoiceError = false;
										}
									} else {
										// Значения
										// PRO Version.
									}									
								}								
							} else if ($Field_Type == 'radio') {
								// Обработка Полей типа: Radio
								$i = 0;								
								foreach ($Field_Choices as $Field_Choice) {
									if ($GFXLImport_ValueType_for_Select == 'name') {
										// Названия
										if ($Field_Arg == $Field_Choice['text']) {									
											$Item['value'] 		= $Field_Choice['value'];
											$Item['input_id'] 	= 'choice_' .$GF_Form_ID .'_' .$Field_ID .'_' .$i;
											
											$ChoiceError = false;
										}
									} else {
										// Значения
										// PRO Version.
									}

									$i = $i + 1;									
								}
							} else if ($Field_Type == 'multiselect') {	
								// Обработка Полей типа: MultiSelect
								$Field_Arg = explode(",", $Field_Arg);					
											
								$Field_Choices_Flat = [];
								$Choices = [];
								
								$ChoiceError = false;	
								foreach ($Field_Choices as $Field_Choice) {
									if ($GFXLImport_ValueType_for_Select == 'name') {
										// Названия
										$Field_Choices_Flat[] = $Field_Choice['text'];
									} else {
										// Значения
										// PRO Version.
										}
								}

								foreach ($Field_Arg as $key => $value) {		
									if (! in_array ($value, $Field_Choices_Flat)) {
										$ChoiceError = true;	
									}
								}	
						
								$Item['choice'] 	= $Choices;
								$Item['value'] 		= wp_json_encode( $Field_Arg );
							} else if ($Field_Type == 'number') {	
								// Обработка Полей типа: Number
								$Field_RangeMin	= $Field['rangeMin'];	
								$Field_RangeMax	= $Field['rangeMax'];	
								
								$ChoiceError = false;
								
								if (is_numeric($Item['value'])) {
									$Field_Value = + $Item['value'];									
									
									// Check RangeMin
									if (is_numeric($Field_RangeMin)) {
										//Convert Str to Num.
										$Field_RangeMin = + $Field_RangeMin;										
										
										if ($Field_Value >= $Field_RangeMin) {
											// RangeMin OK
										} else {
											$ChoiceError = true;
											$ErrorMsg = 'Value < Min';
										}
									}
									
									// Check RangeMax
									if (is_numeric($Field_RangeMax)) {
										//Convert Str to Num.
										$Field_RangeMax = + $Field_RangeMax;
										
										if ($Field_Value <= $Field_RangeMax) {
											// RangeMax OK
										} else {
											$ChoiceError = true;
											$ErrorMsg = 'Value > Max';
										}
									}									
								}
								
								$Item['choice'] = $Item['value'];
							} else {
								// Прочие Поля. Что было бы странно ))
								$Item['choice'] = $Item['value'];									
								
								if (Field_Choices) {
									$Item['choice'] = '';
									
									foreach ($Field_Choices as $Field_Choice) {
										if ($Field_Arg == $Field_Choice['text']) {									
											$Item['choice'] 	= $Field_Choice['text'];
											$Item['value'] 		= $Field_Choice['value'];									
											
											$ChoiceError = false;
										}					
									}									
								}
							}
							
							if ($ChoiceError) {
								$Error = true;
								
								if ($ErrorMsg == '') {
									$ErrorMsg = "Value: [$Field_Arg]";
								} else {
									$ErrorMsg = "Value: [$Field_Arg] ($ErrorMsg)";
								}
								
								$Item['error'] = true;
								$Item['error_msg'] = $ErrorMsg;
								
								$ErrorMsg = "Field_ID: $Field_ID " .$ErrorMsg;
								$Errors_Msg[] = trim($ErrorMsg);
							}
						}						
					} else {
						// Прочие Поля
						$Item['choice'] = $Item['value'];
					}					
				}
			}		
		}
		
		$Result = true;
	}

	// Save New Record.
	if ($Mode == 'save') {
		if ($GF_Form_ID && $GF_Fields) {
			$GF_Entry = array();

			$GF_Entry['form_id'] = $GF_Form_ID;			
			
			foreach ($GF_Fields as $Item) {	
				$Field_ID = $Item['id'];
				$Field_Value = stripslashes($Item['value']);
				
				$GF_Entry[$Field_ID] = $Field_Value;
			}		
			
			$entry_id = GFAPI::add_entry( $GF_Entry );
			
			if ($entry_id) {
				$GF_Fields = 'entry_id:' .$entry_id;
			} else {
				$GF_Fields = null;
			}		
		}
		
		$Result = true;
	}		

	$Obj_Request = new stdClass();
	$Obj_Request->status 	= 'OK';
	$Obj_Request->answer 	= $Result;
	$Obj_Request->fileds 	= $GF_Fields;
	$Obj_Request->error 	= $Error;
	$Obj_Request->error_msg	= $Error_Msg;	

	wp_send_json($Obj_Request);    

	die; // Complete.