<?php
/*
Plugin Name: Import Excel to Gravity Forms
Plugin URI: https://wpgear.xyz/import-excel-to-gravity-forms
Description: Bulk Import of Records from Excel (CSV) files for "Gravity Forms" with Validation and Internal Logic support. Try the <a href="https://wpgear.xyz/import-excel-to-gravity-forms/">Demo</a> on a real Form.
Version: 3.20
Text Domain: gf-excel-import
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/
    
	$GFXLImport_plugin_url = plugin_dir_url( __FILE__ );		// со слэшем на конце
	$GFXLImport_plugin_dir = plugin_dir_path( __FILE__ );	// со слэшем на конце	
	
	$GFXLImport_CSV_Separator 	= get_option('gfxl_import_option_separator', ',');
	$GFXLImport_CSV_Encoding 	= get_option('gfxl_import_option_encoding', 'utf-8');	//'utf-8' - default; 'ISO-8859-1'; 'CP1251'...

	$GFXLImport_LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';
	__('Bulk Import of Records from Excel (CSV) files for "Gravity Forms" with Validation and Internal Logic support. Try the <a href="https://wpgear.xyz/import-excel-to-gravity-forms/">Demo</a> on a real Form.', 'gf-excel-import');	
	
	include_once( __DIR__ .'/includes/loader.php' );
	include_once( __DIR__ .'/includes/admin/admin.php' );	
	
	/* AJAX Processing
	----------------------------------------------------------------- */    
    function GFXLImport_Ajax(){	
		include_once ('includes/ajax_processing.php');
    }
	add_action( 'wp_ajax_gfxl_import', 'GFXLImport_Ajax' );
	add_action( 'wp_ajax_nopriv_gfxl_import', 'GFXLImport_Ajax' );

	/* Translate.
	----------------------------------------------------------------- */
	add_action ('plugins_loaded', 'GFXLImport_Action_plugins_loaded');
	function GFXLImport_Action_plugins_loaded() {
		global $GFXLImport_LocalePath;
				
		$Result = load_plugin_textdomain ('gf-excel-import', false, $GFXLImport_LocalePath);
	}