<?php
/*
 * WPGear. 
 * Import Excel to Gravity Forms
 * admin.php
 */

	/* Admin Console - Styles.
	----------------------------------------------------------------- */	
	add_action ('admin_enqueue_scripts', 'GFXLImport_Action_admin_enqueue_scripts' );	
	function GFXLImport_Action_admin_enqueue_scripts ($hook) {
		global $GFXLImport_plugin_url;
		
		$screen = get_current_screen();
		$screen_base = $screen -> base;		
		
		if ( $screen_base == 'toplevel_page_gf_edit_forms' || $screen_base == 'gf-excel-import/includes/admin/options') {
			wp_enqueue_style ('gfxl_import_adminstyle', $GFXLImport_plugin_url .'/includes/admin/admin-style.css'); // phpcs:ignore
		}	
	}
	
	/* Registering Styles with Gravity Forms when running on "no-conflict mode"
	----------------------------------------------------------------- */
	add_filter('gform_noconflict_styles', 'GFXLImport_Filter_gform_noconflict_styles' );
	function GFXLImport_Filter_gform_noconflict_styles( $styles ){
		$styles[] = "gfxl_import_adminstyle";
		return $styles;
	}	
	
	/* Create plugin SubMenu
	----------------------------------------------------------------- */		
	add_action('admin_menu', 'GFXLImport_Action_admin_menu');	
	function GFXLImport_Action_admin_menu() {
		add_options_page(
			__( 'Import Excel to Gravity Forms', 'gf-excel-import' ),
			__( 'Import Excel to Gravity Forms', 'gf-excel-import' ),
			'publish_posts',
			'gf-excel-import/includes/admin/options.php',
			''
		);
	}	

	/* Add Metabox Excel-Import. Gravity Forms -> Page: Settings.
	----------------------------------------------------------------- */	
	add_filter('gform_form_settings', 'GFXLImport_Filter_gform_form_settings', 10, 2);
	function GFXLImport_Filter_gform_form_settings($form_settings, $form){		
        // В старших версиях GF изменен формат Всплывающих Подсказок. Поэтому, делаем универсальный вариант. Без изысков.

		if (isset($form['gfxl_import_pro'])) {
			// Следы версии "Import Excel to Gravity Forms PRO"
			if (isset($form['gfxl_import'])) {
				$Options_GFXLImport = (isset($form['gfxl_import']) && $form['gfxl_import'] == 'on') ? 'checked' : '';
			} else {
				// Наследуем Настройки
				$Options_GFXLImport = (isset($form['gfxl_import_pro']) && $form['gfxl_import_pro'] == 'on') ? 'checked' : '';
			}
		} else {
			$Options_GFXLImport = (isset($form['gfxl_import']) && $form['gfxl_import'] == 'on') ? 'checked' : '';
		}		
		
		$form_settings['Excel Import']['gfxl_import'] = '
			<tr>
				<th>
					Excel Import <a href=\'#\' onclick=\'return false;\' onkeypress=\'return false;\' class=\'gf_tooltip tooltip tooltip_form_form_button_gfxl_import\' title=\'Bulk Import of Records from Excel (CSV) files with Validation and Internal Logic support.\'><i class=\'fa fa-question-circle\'></i></a>
				</th>
				<td>
					<input type="checkbox" id="form_button_gfxl_import" name="gfxl_import" ' .esc_attr( $Options_GFXLImport ) . '>
					<label for="form_button_gfxl_import" class="inline"> Enable Excel Import</label>
				</td>
			 </tr>
		';	
		
		return $form_settings;
	}

	/* Save MetaBox Excel-Import. Gravity Forms -> Page: Settings.
	----------------------------------------------------------------- */
	add_filter('gform_pre_form_settings_save', 'GFXLImport_Filter_gform_pre_form_settings_save');
	function GFXLImport_Filter_gform_pre_form_settings_save($form) {		
		
        $form['gfxl_import'] = rgpost( 'gfxl_import' );

        return $form;
	}	