<?php
/*
	Decimal Product Quantity for WooCommerce
	uninstall.php
*/

	// if uninstall.php is not called by WordPress, die
	if (!defined('WP_UNINSTALL_PLUGIN')) {
		die;
	}

	if (!function_exists ('WooDecimalProduct_Check_Plugin_Installed')) {
		include_once(__DIR__ .'/includes/functions.php');
	}	

	if (WooDecimalProduct_Check_Plugin_Installed ('decimal-product-quantity-for-woocommerce-pro')) {
		// Нельзя удалять некоторые Общие Настройки, т.к. имеется Плагин "Decimal Product Quantity for WooCommerce PRO"
	} else {	
		// Remove Plugin Options
		delete_option ('woodecimalproduct_min_qnt_default');
		delete_option ('woodecimalproduct_step_qnt_default');
		delete_option ('woodecimalproduct_item_qnt_default');
		
		// Remove post meta
		global $wpdb;
		$PostMeta_Table = $wpdb->prefix .'postmeta';
		
		$Query = "DELETE FROM $PostMeta_Table WHERE meta_key LIKE 'woodecimalproduct_%'";			
		$wpdb->query($Query);	
	}