<?php
/*
* Decimal Product Quantity for WooCommerce
* Admin WooCommerce Setup Page.
* admin_setup_woo.php
*/

	/* Инициализация.
     * Запускаем самым последним, чтобы быть уверенным, что WooCommerce уже инициализировался.
	----------------------------------------------------------------- */    
    add_action ('init', 'WooDecimalProduct_remove_filters', 999999);
	function WooDecimalProduct_remove_filters(){
        if (class_exists ('WooCommerce')){
            // Разрешаем использование дробного количества изменения Товара
            remove_filter ('woocommerce_stock_amount', 'intval');
            add_filter ('woocommerce_stock_amount', 'floatval');
        } 
    } 	

	/* WooCommerce Setup Page. | Товары -> Запасы
	 * Добавляем опции: "Шаг изменения кол-ва и Mинимальное кол-во Товара" для всех Заказов по умолчанию.
	 * Но каждый Товар может иметь собственные Параметры.
	----------------------------------------------------------------- */	
	add_filter ('woocommerce_get_settings_products', 'WooDecimalProduct_settings', 10, 2); 
	function WooDecimalProduct_settings( $settings, $current_section ) {
		if ( $current_section == 'inventory' ) {
			$updated_settings = array(); 

			foreach ( $settings as $section ) {
				$updated_settings[] = $section;
				
				if (isset( $section['type'] ) && $section['type'] == 'title') {
                    // Add field options: "Mинимальное кол-во Товара для покупки"
					$updated_settings[] = array(
						'name'     => 'Min cart Quantity', 'text-domain',
						'desc_tip' => 'How min-much quantity of product to cart',
						'id'       => 'woodecimalproduct_min_qnt_default',
						'type'     => 'text',
						'desc'     => '1 or 0.1 or 0.25 or 1.5 etc. (Each Product can set a custom value.)',
						'css'      => 'width: 64px;',
                        'default'  => '1'
					);					

                    // Add field options: "Шаг изменения кол-ва Товара"
					$updated_settings[] = array(
						'name'     => 'Step change Quantity', 'text-domain',
						'desc_tip' => 'How much to increase or decrease the quantity of product to cart',
						'id'       => 'woodecimalproduct_step_qnt_default',
						'type'     => 'text',
						'desc'     => '1 or 0.1 or 0.25 or 1.5 etc. (Each Product can set a custom value.)',
						'css'      => 'width: 64px;',
                        'default'  => '1'
					); 

                    // Add field options: "Количество Товара по Умолчанию"
					$updated_settings[] = array(
						'name'     => 'Default Quantity', 'text-domain',
						'desc_tip' => 'How much default quantity of product to cart',
						'id'       => 'woodecimalproduct_item_qnt_default',
						'type'     => 'text',
						'desc'     => '1 or 0.1 or 0.25 or 1.5 etc. (Each Product can set a custom value.)',
						'css'      => 'width: 64px;',
                        'default'  => '1'
					);
					
                    // Add field options: "Mаксимальное кол-во Товара для покупки"
					$updated_settings[] = array(
						'name'     => 'Max cart Quantity', 'text-domain',
						'desc_tip' => 'How max-much quantity of product to cart',
						'id'       => 'woodecimalproduct_max_qnt_default',
						'type'     => 'text',
						'desc'     => '1 or 0.1 or 0.25 or 1.5 etc. (Each Product can set a custom value.) or leave blank',
						'css'      => 'width: 64px;',
                        'default'  => ''
					);

                    // Add field options: "Auto correction 'No valid value' customer enters to nearest valid value."
					$updated_settings[] = array(
						'name'     => 'Auto correction Quantity', 'text-domain',
						'desc_tip' => '',
						'id'       => 'woodecimalproduct_auto_correction_qnt',
						'type'     => 'checkbox',
						'desc'     => 'Auto correction "No valid Value" customer enters to nearest valid value',
						'css'      => '',
                        'default'  => 'yes'
					);					
				}	
			}

			return $updated_settings;
			
		} else {
			return $settings;
		}
	}    

	/* WooCommerce Setup Page. | Товары -> Запасы. | Validation: Min cart Quantity.
     * $WooDecimalProduct_Min_Quantity_Default
	----------------------------------------------------------------- */       
    add_filter ("woocommerce_admin_settings_sanitize_option_woodecimalproduct_min_qnt_default", 'WooDecimalProduct_admin_settings_sanitize_option_min_qnt_default', 10, 3); 
	function WooDecimalProduct_admin_settings_sanitize_option_min_qnt_default ($value, $option, $raw_value) {		
		$min_Qnt = sanitize_text_field ($value);

        if (! $min_Qnt) {
            $min_Qnt = $option['default'];
        } 

        if (! is_numeric($min_Qnt)) {
            $min_Qnt = $option['default'];
        }

        if ($min_Qnt < 0) {
            $min_Qnt = $option['default'];
        }

        return $min_Qnt;
    }    

	/* WooCommerce Setup Page. | Товары -> Запасы. | Validation: Step change Quantity.
     * $WooDecimalProduct_Step_Quantity_Default
	----------------------------------------------------------------- */       
    add_filter ("woocommerce_admin_settings_sanitize_option_woodecimalproduct_step_qnt_default", 'WooDecimalProduct_admin_settings_sanitize_option_step_qnt_default', 10, 3); 
	function WooDecimalProduct_admin_settings_sanitize_option_step_qnt_default ($value, $option, $raw_value) {
        $step_Qnt = sanitize_text_field ($value);

        if (! $step_Qnt) {
            $step_Qnt = $option['default'];
        } 

        if (! is_numeric($step_Qnt)) {
            $step_Qnt = $option['default'];
        }

        if ($step_Qnt < 0) {
            $step_Qnt = $option['default'];
        }

        return $step_Qnt;
    }    

	/* WooCommerce Setup Page. | Товары -> Запасы. | Validation: Default preset Quantity.
     * $WooDecimalProduct_Item_Quantity_Default
	----------------------------------------------------------------- */       
    add_filter ("woocommerce_admin_settings_sanitize_option_woodecimalproduct_item_qnt_default", 'WooDecimalProduct_admin_settings_sanitize_option_preset_qnt_default', 10, 3);
	function WooDecimalProduct_admin_settings_sanitize_option_preset_qnt_default ($value, $option, $raw_value) {
        $Default_Qnt = sanitize_text_field ($value);

        if (! $Default_Qnt) {
            $Default_Qnt = $option['default'];
        } 

        if (! is_numeric($Default_Qnt)) {
            $Default_Qnt = $option['default'];
        }

        if ($Default_Qnt < 0) {
            $Default_Qnt = $option['default'];
        }

        return $Default_Qnt;
    }
	
	/* WooCommerce Setup Page. | Товары -> Запасы. | Validation: Max cart Quantity.
     * $WooDecimalProduct_Max_Quantity_Default
	----------------------------------------------------------------- */       
    add_filter ("woocommerce_admin_settings_sanitize_option_woodecimalproduct_max_qnt_default", 'WooDecimalProduct_admin_settings_sanitize_option_max_qnt_default', 10, 3); 
	function WooDecimalProduct_admin_settings_sanitize_option_max_qnt_default ($value, $option, $raw_value) {		
		$max_Qnt = sanitize_text_field ($value);

        if (! $max_Qnt) {
            $max_Qnt = '';
        } 

        if (! is_numeric($max_Qnt)) {
            $max_Qnt = '';
        }

        if ($max_Qnt < 0) {
            $max_Qnt = '';
        }		

        return $max_Qnt;
    }	