<?php
/*
 * WPGear. 
 * WPGear – Consent Privacy Policy Acceptance
 * options.php
 */

	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly
	}
	
	$WPGearCPPA_NonceKey = 'Update_Options_Accept-Privacy-Policy';
	$WPGearCPPA_Nonce = wp_create_nonce ($WPGearCPPA_NonceKey);	
	
	$WPGearCPPA_Action = isset($_REQUEST['action']) ? sanitize_text_field (wp_unslash($_REQUEST['action'])) : null; // phpcs:ignore
	
	if ($WPGearCPPA_Action == 'Update') {
		$WPGearCPPA_NonceRequest 	= isset($_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : 'none';	
		$WPGearCPPA_AdminOnly 		= isset($_REQUEST['wpgear-cppa_option_adminonly']) ? 1 : 0;	
		$WPGearCPPA_Enable 			= isset($_REQUEST['wpgear-cppa_option_enable']) ? 1 : 0;	
		$WPGearCPPA_Clearing 		= isset($_REQUEST['wpgear-cppa_option_clearing']) ? 1 : 0;	
		$WPGearCPPA_Message			= isset($_REQUEST['wpgear-cppa_option_message']) ? sanitize_textarea_field( wp_unslash( $_REQUEST['wpgear-cppa_option_message'] ) ): '';
		$WPGearCPPA_ButtonAccept 	= isset($_REQUEST['wpgear-cppa_option_button_accept']) ? sanitize_text_field( wp_unslash( $_REQUEST['wpgear-cppa_option_button_accept'] ) ) : '';
		$WPGearCPPA_PolicyPageSlug	= isset($_REQUEST['wpgear-cppa_option_policypage_slug']) ? sanitize_textarea_field( wp_unslash( $_REQUEST['wpgear-cppa_option_policypage_slug'] ) ) : '';
		$WPGearCPPA_PolicyPageText	= isset($_REQUEST['wpgear-cppa_option_policypage_text']) ? sanitize_textarea_field( wp_unslash( $_REQUEST['wpgear-cppa_option_policypage_text'] ) ) : '';
		
		if (!wp_verify_nonce ($WPGearCPPA_NonceRequest, $WPGearCPPA_NonceKey)) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="wpgear-cppa_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'wpgear-consent-privacy-policy-acceptance') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}
		
		// Save Options.
		$WPGearCPPA_Options = array(
			'adminonly' => $WPGearCPPA_AdminOnly,
			'enable' => $WPGearCPPA_Enable,
			'clearing' => $WPGearCPPA_Clearing,
			'message' => $WPGearCPPA_Message,
			'button_accept' => $WPGearCPPA_ButtonAccept,
			'policypage_slug' => $WPGearCPPA_PolicyPageSlug,
			'policypage_text' => $WPGearCPPA_PolicyPageText,
		);

		update_option( 'wpgear-cppa_acceptance_option', $WPGearCPPA_Options ); // phpcs:ignore
	}
	
	$WPGearCPPA_Options = WPGearCPPA_Get_Options();
	
	$WPGearCPPA_AdminOnly 		= $WPGearCPPA_Options['adminonly'];
	$WPGearCPPA_Enable			= $WPGearCPPA_Options['enable'];
	$WPGearCPPA_Clearing 		= $WPGearCPPA_Options['clearing'];		
	$WPGearCPPA_Message 		= $WPGearCPPA_Options['message'];
	$WPGearCPPA_ButtonAccept 	= $WPGearCPPA_Options['button_accept'];
	$WPGearCPPA_PolicyPageSlug 	= $WPGearCPPA_Options['policypage_slug'];
	$WPGearCPPA_PolicyPageText 	= $WPGearCPPA_Options['policypage_text'];
	
	if ($WPGearCPPA_AdminOnly) {
		if (!current_user_can('edit_dashboard')) {
			?>
			<div class="wpgear-cppa_warning" style="margin: 40px;">				
				<?php echo esc_html( __('Sorry, you are not allowed to view this page.', 'wpgear-consent-privacy-policy-acceptance') ); ?>
			</div>
			<?php
			
			return;
		}		
	}
	
	?>
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
		<hr>
		
		<div class="wpgear-cppa_options_box">
			<form name="form_AcceptPrivacyPolicy_Options" method="post" style="margin-top: 20px;">
				<h3><?php echo esc_html( __('General', 'wpgear-consent-privacy-policy-acceptance') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="wpgear-cppa_option_field_label">
									<label for="wpgear-cppa_option_adminonly">
										<?php echo esc_html( __('Enable this Page for Admin only', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</label>
								</th>
								<td class="wpgear-cppa_options_field_input">
									<input id="wpgear-cppa_option_adminonly" name="wpgear-cppa_option_adminonly" type="checkbox" <?php if($WPGearCPPA_AdminOnly) {echo 'checked';} ?>>
									<span class="wpgear-cppa_options_field_description">
										<?php echo esc_html( __('On/Off', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</span>
								</td>
							</tr>
							
							<tr>
								<th scope="row" class="wpgear-cppa_option_field_label">
									<label for="wpgear-cppa_option_enable">
										<?php echo esc_html( __('Enable "Consent Privacy Policy Acceptance"', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</label>
								</th>
								<td class="wpgear-cppa_options_field_input">
									<input id="wpgear-cppa_option_enable" name="wpgear-cppa_option_enable" type="checkbox" <?php if($WPGearCPPA_Enable) {echo 'checked';} ?>>
									<span class="wpgear-cppa_options_field_description">
										<?php echo esc_html( __('On/Off', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</span>
								</td>
							</tr>							
						</tbody>
					</table>
				</div>
				
				<hr>
					
				<h3><?php echo esc_html( __('Content', 'wpgear-consent-privacy-policy-acceptance') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="wpgear-cppa_option_field_label">
									<label for="wpgear-cppa_option_message">
										<?php echo esc_html( __('Message', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</label>
								</th>
								<td class="wpgear-cppa_options_field_input">
									<textarea id="wpgear-cppa_option_message" name="wpgear-cppa_option_message" rows="4" class="wpgear-cppa_options_message"><?php echo esc_attr( $WPGearCPPA_Message); ?></textarea>
									<span class="wpgear-cppa_options_field_description">
										<?php echo esc_textarea( __('Message about Agreement. Use {Privacy Policy} for Link to Policy Page', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</span>
								</td>
							</tr>
							<tr>
								<th scope="row" class="wpgear-cppa_option_field_label">
									<label for="wpgear-cppa_option_policypage_slug">
										<?php echo esc_html( __('Slug (Policy Page)', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</label>
								</th>
								<td class="wpgear-cppa_options_field_input">
									<input id="wpgear-cppa_option_policypage_slug" name="wpgear-cppa_option_policypage_slug" type="text" value="<?php echo esc_attr( $WPGearCPPA_PolicyPageSlug ); ?>">
									<span class="wpgear-cppa_options_field_description">
										<?php echo esc_html( __('privacy-policy', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</span>
								</td>
							</tr>
							<tr>
								<th scope="row" class="wpgear-cppa_option_field_label">
									<label for="wpgear-cppa_option_policypage_text">
										<?php echo esc_html( __('Link Text', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</label>
								</th>
								<td class="wpgear-cppa_options_field_input">
									<input id="wpgear-cppa_option_policypage_text" name="wpgear-cppa_option_policypage_text" type="text" value="<?php echo esc_attr( $WPGearCPPA_PolicyPageText ); ?>">
									<span class="wpgear-cppa_options_field_description">
										<?php echo esc_html( __('Privacy Policy', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</span>
								</td>
							</tr>
							<tr>
								<th scope="row" class="wpgear-cppa_option_field_label">
									<label for="wpgear-cppa_option_button_accept">
										<?php echo esc_html( __('Button Accept', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</label>
								</th>
								<td class="wpgear-cppa_options_field_input">
									<input id="wpgear-cppa_option_button_accept" name="wpgear-cppa_option_button_accept" type="text" value="<?php echo esc_attr( $WPGearCPPA_ButtonAccept ); ?>">
									<span class="wpgear-cppa_options_field_description">
										<?php echo esc_html( __('I agree / OK / etc', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
					<div>
						<?php echo esc_html( __('* The appearance, shape and location of the banner can be fully customized to suit your design using CSS.', 'wpgear-consent-privacy-policy-acceptance') ); ?>
					</div>
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Clearing', 'wpgear-consent-privacy-policy-acceptance') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="wpgear-cppa_option_field_label">
									<label for="wpgear-cppa_option_clearing">
										<?php echo esc_html( __('Delete MetaData with Uninstall Plugin.', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</label>
								</th>
								<td class="wpgear-cppa_options_field_input">
									<input id="wpgear-cppa_option_clearing" name="wpgear-cppa_option_clearing" type="checkbox" <?php if($WPGearCPPA_Clearing) {echo 'checked';} ?>>
									<span class="wpgear-cppa_options_field_description">
										<?php echo esc_html( __('On/Off', 'wpgear-consent-privacy-policy-acceptance') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>

				<hr>
				<div style="margin-top: 10px; margin-bottom: 5px; text-align: right;">
					<input id="wpgear-cppa_option_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_html( __('Save', 'wpgear-consent-privacy-policy-acceptance') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="Update">
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($WPGearCPPA_Nonce); ?>">
			</form>
		</div>
	</div>
	