<?php
/*
 * WPGear.
 * GV Excel Export
 * admin.php
*/

	/* Create plugin SubMenu
	----------------------------------------------------------------- */		
	add_action('admin_menu', 'GVXL_Action_admin_menu');	
	function GVXL_Action_admin_menu() {
		add_options_page(			
			__('GV Excel Export', 'gv-excel-export'),
			'GV Excel Export',
			'publish_posts',
			'gv-excel-export/includes/admin/options.php',
			''
		);	
	}
	
	/* Стили для Админки GV
	----------------------------------------------------------------- */	
	add_action ('admin_enqueue_scripts', 'GVXL_Action_admin_enqueue_scripts');
	function GVXL_Action_admin_enqueue_scripts () {
        if (function_exists ('gravityview_is_admin_page')) {
            if (gravityview_is_admin_page()) {
				global $GVXL_plugin_url;
				
				$Style_Path = $GVXL_plugin_url .'admin/admin-style.css';
				wp_enqueue_style ('gvxl_admin', $Style_Path); // phpcs:ignore
				
				$Style_Path = "https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css";
				wp_enqueue_style ('fontawesome_4.7.0', $Style_Path); // phpcs:ignore					
            }
        }	
	}	
	
	/* GV. MetaBoxes. Add to admin forms.
	----------------------------------------------------------------- */
	add_action('add_meta_boxes', 'GVXL_Action_add_meta_boxes');	
	function GVXL_Action_add_meta_boxes(){		
		$screens = array( 'gravityview');	
			
		// Excel-Export.
		add_meta_box( 'GVXL_ExcelExport_Metabox', 'Excel-Export.', 'GVXL_Add_ExcelExport_Metabox_Callback', $screens, 'side', 'high');		
	}	
	
	/* MetaBox Excel-Export.
	----------------------------------------------------------------- */	
	function GVXL_Add_ExcelExport_Metabox_Callback( $post, $meta ) {	
		$GVXL_Setup_Enable = GVXL_Get_Options('enable');
		
		$GVXL_Nonce = 'Metabox GV Excel Export';
		$nonce = wp_create_nonce ($GVXL_Nonce);
		
		$Action = isset($_REQUEST['action']) ? sanitize_text_field( wp_unslash( $_REQUEST['action'] ) ) : null; // phpcs:ignore
	
		$PostID = $post -> ID;
		
		if ($PostID && $Action == 'edit') {
			global $GVXL_plugin_url;
			
			$key = 'gvxl_excel-export_control';
			$ExcelExport_Control = get_post_meta( $PostID, $key, true );
		
			if ($ExcelExport_Control) {
				// Load JS Script. PRO Version.
			}

			?>
			<div class='gvxl_metabox'>
				<div>
					<div>
						<label>
							<input id="gvxl_excelexport" type="checkbox" name="gvxl_excelexport" onchange="excelexport_info()" <?php if ($ExcelExport_Control) {echo 'checked="checked"';} ?> value="1" />
							<span class='gvxl_metabox_excelexport_title' title="Enable 'Excel-Export' for this form.">
								<?php echo esc_html( __('Excel-Export', 'gv-excel-export') ); ?> <i class="fa fa-info-circle" aria-hidden="true"></i>
								<?php if (! $GVXL_Setup_Enable) { ?>
									<div id="excelexport_info_box" class="gvxl_excelexport_info_box" style="color: red;">
										<?php echo esc_html( __('Disabled on General Settings.', 'gv-excel-export') ); ?>
									</div>
								<?php } ?>
							</span>
						</label>					
					</div>
					<div id="excelexport_info_box" class="gvxl_excelexport_info_box" style="display: none;">
						<?php echo esc_html( __('you need to update this form, before changes to take effect.', 'gv-excel-export') ); ?>
					</div>			
				</div>
			</div>
			<input id="gvxl_excelexport_nonce" name="gvxl_excelexport_nonce" type="hidden" value="<?php echo esc_attr( $nonce ); ?>">

			<script>
				function excelexport_info () {
					document.getElementById('excelexport_info_box').style.display = 'block';
				}
			</script>
			<?php
			// PRO Version				
			// Some Problems about - Try Register Script for GV Admin page!		
		} 
	}	

	/* MetaBox. Save options whith GV.
	----------------------------------------------------------------- */	
	add_action( 'save_post_gravityview', 'GVXL_Action_save_post_gravityview' );	
	function GVXL_Action_save_post_gravityview( $post_id ) {
		$GVXL_Nonce = 'Metabox GV Excel Export';
		
		$_nonce = isset($_POST['gvxl_excelexport_nonce']) ? sanitize_text_field( wp_unslash( $_POST['gvxl_excelexport_nonce'] ) ) : null; // phpcs:ignore

		if ( ! wp_verify_nonce( $_nonce, $GVXL_Nonce ) ) {
			return;
		} 	
	
		// Autosave, Do Nothing
		if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) 
			return;

		if( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}			

		// ОК. Do Save.
		$ExcelExport_Control = isset($_POST['gvxl_excelexport']) ? sanitize_text_field($_POST['gvxl_excelexport']) : 0;	 // phpcs:ignore
		
		$key = 'gvxl_excel-export_control';		
		update_post_meta( $post_id, $key, $ExcelExport_Control ); // phpcs:ignore		
	}	