<?php
/*
 * WPGear. 
 * GV Excel Export
 * shortcodes.php
 */

	/* ShortCode: Excel Export Button.
	----------------------------------------------------------------- */	
	add_shortcode( 'gvxl_button_excelexport', 'GVXL_Shortcode_Button' );
	function GVXL_Shortcode_Button( $atts, $shortcode_content = null){	
		$GV_Settings = get_option('gravityformsaddon_gravityview_app_settings', array());
		$GV_Settings_ExcelExport 	= isset($GV_Settings['excel-export']) ? intval($GV_Settings['excel-export']) : true; 
		
		if ($GV_Settings_ExcelExport) {
			$Site_URL = get_site_url();
			
			// Try get G-View ID		
			global $wp_query;
			$GV = get_query_var('gravityview');
			$GV_ID = null;
			
			if ($GV) {
				$GV_View = (array) $GV -> view;
				$GV_Post = array_values($GV_View)[0];
				$GV_ID = $GV_Post -> ID;
			}				
			
			if ($GV_ID) {
				$key = 'gvxl_excel-export_control';
				$ExcelExport_Control = get_post_meta( $GV_ID, $key, true );				
				
				if ($ExcelExport_Control) {	
					$Requests = array();
					
					$Request_Search 	= isset($_REQUEST['gv_search']) ? sanitize_text_field( wp_unslash( $_REQUEST['gv_search'] ) ) : null; // phpcs:ignore
					$Request_Sorting 	= isset($_REQUEST['sort']) ? sanitize_text_field( wp_unslash( $_REQUEST['sort'] ) ) : null; // phpcs:ignore		
					
					if ($Request_Search) {
						$Requests['gv_search'] = $Request_Search;
						$Requests['mode'] = 'any';
					}	
					
					$Redirect_URL = $_SERVER['REDIRECT_URL'];		
					$Excel_URL = $Site_URL .$Redirect_URL .'?out=excel';					
					
					if ($GV_ID) {
						$Excel_URL = $Excel_URL .'&gv_id=' .$GV_ID;
					}
					
					foreach ($Requests as $key => $value) {
						$Excel_URL = $Excel_URL .'&' .$key .'=' .$value;
					}
					
					if (is_array($Request_Sorting)) {
						$Sort_Field 	= array_keys($Request_Sorting)[0];
						$Sort_Direction = array_values($Request_Sorting)[0];
						
						$Excel_URL = $Excel_URL .'&sort%5B' .$Sort_Field .'%5D=' .$Sort_Direction;
					}						
					
					// PRO Version	
					// datepicker					
					
					ob_start();
					?>
					<div>
						<div>
							<i class="fa fa-2x fa-file-excel-o" onclick="GVXL_excel_fields_box_Togle_Show ()" title="Export to Excel" style="color: green; cursor: pointer;" aria-hidden="true"></i>
						</div>
						<div id="gvxl_excel_fields_box" class="gvxl_excel_fields_box" style="display: none;">
							<div class="gvxl_excel_fields_box_fields">
								<div class="gvxl_excel_fields_box_fields_item">
									<label for="gvxl_excel_field_date_from">Date from: </label>
									<input id="gvxl_excel_field_date_from" name="gvxl_excel_field_date_from" onchange="GVXL_excel_change_fields_date_note()" type="text" class="datepicker">
								</div>
								<div class="gvxl_excel_fields_box_fields_item">
									<label for="gvxl_excel_field_date_to">Date to: </label>
									<input id="gvxl_excel_field_date_to" name="gvxl_excel_field_date_to" onchange="GVXL_excel_change_fields_date_note()" type="text" class="datepicker">
								</div>	
							</div>
							
							<div>
								<span id="gvxl_excel_fields_date_note" class="gvxl_excel_fields_date_note"></span>
							</div>
							
							<div class="gvxl_excelexport_button">
								<input id="gvxl_excel_btn_submit" onclick="GVXL_excel_submit ()" type="button" class="button" value="Start Export">
							</div>
						</div>
					</div>
					<script>
						var GVXL_excel_fields_box_Show = false;
						var DateSeparator = '.';
						
						var Now = new Date();
						var Today_Y = Now.getFullYear();
						var Today_M = ("0" + (Now.getMonth() + 1)).slice(-2);			
						var Today_D = ("0" + Now.getDate()).slice(-2);
						document.getElementById ('gvxl_excel_field_date_to').value = Today_D + DateSeparator + Today_M + DateSeparator + Today_Y;
							
						if (Today_D > 10) {
							// Start from Current Month
							var FirstDayPrevMonth_Y = Today_Y;
							var FirstDayPrevMonth_M = Today_M;				
							var FirstDayPrevMonth_D = '01';
							
							document.getElementById ('gvxl_excel_fields_date_note').innerHTML = '* Date range: first Day current Month -> Today.';
						} else {
							// Start from Prev. Month
							var FirstDayPrevMonth = new Date(Now.getFullYear(), Now.getMonth() - 1, 1);
							var FirstDayPrevMonth_Y = FirstDayPrevMonth.getFullYear();
							var FirstDayPrevMonth_M = ("0" + (FirstDayPrevMonth.getMonth() + 1)).slice(-2);				
							var FirstDayPrevMonth_D = ("0" + FirstDayPrevMonth.getDate()).slice(-2);
							
							document.getElementById ('gvxl_excel_fields_date_note').innerHTML = '* Date range: first Day prev. Month -> Today.';
						}	

						document.getElementById ('gvxl_excel_field_date_from').value = FirstDayPrevMonth_D + DateSeparator + FirstDayPrevMonth_M + DateSeparator + FirstDayPrevMonth_Y;
						
						function GVXL_excel_fields_box_Togle_Show () {
							// Show/Hide fields box.
							GVXL_excel_fields_box_Show = !GVXL_excel_fields_box_Show;				
							
							if (GVXL_excel_fields_box_Show) {
								document.getElementById ('gvxl_excel_fields_box').style.display = 'inline-block';
							} else {
								document.getElementById ('gvxl_excel_fields_box').style.display = 'none';
							}
						}
						
						function GVXL_excel_submit () {
							var GVXL_Excel_Date_from = document.getElementById ('gvxl_excel_field_date_from').value;
							var GVXL_Excel_Date_to 	= document.getElementById ('gvxl_excel_field_date_to').value;				
							var Location = "<?php echo esc_url( $Excel_URL );?>";
							
							if (GVXL_Excel_Date_from) {
								Location = Location + "&date_from=" + GVXL_Excel_Date_from;
							}
											
							if (GVXL_Excel_Date_to) {
								Location = Location + "&date_to=" + GVXL_Excel_Date_to;
							}				

							window.location.href = Location;
						}
						
						function GVXL_excel_change_fields_date_note () {
							document.getElementById ('gvxl_excel_fields_date_note').innerHTML = '* Date range: Custom.';
						}
					</script>
					<?php		
					$content = ob_get_clean();
					
					return $content;
				}				
			}
		}
	}	