<?php
/*
 * WPGear. Users Login Monitor
 * options.php
 */
	
    if (!current_user_can('edit_dashboard')) {
        return;
    } 
?>
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
		<hr>
	</div>
	
	<?php
	$Current_Tab = isset($_GET['tab']) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : 'activity'; // phpcs:ignore 
	
	UsersLoginMonitor_Create_Tabs ($Current_Tab);
	
	//Tab: "Activity"
	if ($Current_Tab == 'activity') { 
		include_once(dirname( __FILE__ ) ."/tab_activity.php");
	}
	
	// Tab: "Log"
	if ($Current_Tab == 'log') { 
		include_once(dirname( __FILE__ ) ."/tab_log.php");
	}	

	//Tab: "Setup"
	if ($Current_Tab == 'setup') { 
		include_once(dirname( __FILE__ ) ."/tab_setup.php");
	}	
	
	//Create Tabs.
	function UsersLoginMonitor_Create_Tabs ($Current_Tab) {
		$Tab_Activity 	= __('Activity', 'users-login-monitor');
		$Tab_Setup 		= __('Setup', 'users-login-monitor');
		$Tab_Log 		= __('Log', 'users-login-monitor');
		
		$Tabs = array( 
			'activity' 	=> $Tab_Activity, 
			'setup' => $Tab_Setup,
			'log' 	=> $Tab_Log,
		);
		
		// $UsersLoginMonitor_Nonce = 'Tabs.Activity_UsersLoginMonitor';
		// $nonce = wp_create_nonce ($UsersLoginMonitor_Nonce);		
		
		echo '<div class="wrap"><h2 class="nav-tab-wrapper">';
			foreach( $Tabs as $tab => $name ) {
				$class = '';
				
				if ($tab == $Current_Tab) {
					$class = ' nav-tab-active';
				} 
				
				echo "<a class='nav-tab" .esc_html ( $class ) ."' href='?page=users-login-monitor/includes/admin/options.php&direct=1&tab=" .esc_html ( $tab ) ."'>" .esc_html ( $name ) ."</a>";
			}
		echo '</h2></div>';
	}
	?>