<?php
/*
 * WPGear. Users Login Monitor
 * tab_activity.php
 */
	
    if (!current_user_can('edit_dashboard')) {
        return;
    }
	
	$UsersLoginMonitor_Nonce = 'Activity_UsersLoginMonitor';
	$nonce = wp_create_nonce ($UsersLoginMonitor_Nonce);	
	
	$WP_Nonce 		= isset($_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : 'none';
	$Nonce_Ignore 	= isset($_REQUEST['direct']) ? sanitize_text_field( wp_unslash( $_REQUEST['direct'] ) ) : false;
	$Request_Page 	= isset($_REQUEST['page']) ? sanitize_text_field( wp_unslash( $_REQUEST['page'] ) ) : false;
	
	if ($Request_Page == 'users-login-monitor/includes/admin/options.php') {
		// Вызов из Меню Админки.
		$Nonce_Ignore = true;
	}

	if (! $Nonce_Ignore) {
		// Проверка $_REQUEST['_wpnonce'] не делается, если переход по ссылке из Admin-Bar или по Tab или из Меню. 
		// Т.к. '_wpnonce' в таком случае в открытом виде, либо его нет (если это - из Меню).
		// В любом случае - это Достоверные Источники.
		if (! wp_verify_nonce( $WP_Nonce, $UsersLoginMonitor_Nonce )) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="ulm_options_box">						
						<?php echo esc_html( __('Access Disable!', 'users-login-monitor') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}
	}
	
	$UsersLoginMonitor_Search			= isset($_REQUEST['s']) ? sanitize_text_field( wp_unslash( $_REQUEST['s'] ) ) : null;
	$UsersLoginMonitor_Filter_Activity 	= isset($_REQUEST['ulm_activity']) ? sanitize_text_field( wp_unslash( $_REQUEST['ulm_activity'] ) ) : 'on';	
		
	global $UsersLoginMonitor_Search;

	$UsersLoginMonitor_Filter_Activity_Class['all'] = 'ulm_list_table_filter_status_box_free';
	$UsersLoginMonitor_Filter_Activity_Class['on'] = 'ulm_list_table_filter_status_box_free';
	$UsersLoginMonitor_Filter_Activity_Class['off'] = 'ulm_list_table_filter_status_box_free';	
	
	if ($UsersLoginMonitor_Filter_Activity == 'all') {
		$UsersLoginMonitor_Filter_Activity_Class['all'] = 'ulm_list_table_filter_status_box_current';
	}
	if ($UsersLoginMonitor_Filter_Activity == 'on') {
		$UsersLoginMonitor_Filter_Activity_Class['on'] = 'ulm_list_table_filter_status_box_current';
	}
	if ($UsersLoginMonitor_Filter_Activity == 'off') {
		$UsersLoginMonitor_Filter_Activity_Class['off'] = 'ulm_list_table_filter_status_box_current';
	}	
		
	$ULM_Counts_Active_Users = UsersLoginMonitor_Get_Counts_Active_Users ();

	if( ! class_exists('WP_List_Table') ) {
		require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
	}
		
	$UsersLoginMonitor_ListTable = new ULM_ListTable();
	$UsersLoginMonitor_ListTable -> prepare_items();		
	?>
	<div class="wrap">
		<h2><?php echo esc_html( __('LogOn & Activity over the last 24 hours.', 'users-login-monitor') ); ?></h2>
		<hr>
		
		<div>
			<form id="ulm_form" method="post">
				<input type="hidden" name="page" value="ulm_list_table">

				<div class="ulm_list_table_filter_status_box">
					<?php echo esc_html( __('Activity:', 'users-login-monitor') ); ?>
					<a class="<?php echo esc_html( $UsersLoginMonitor_Filter_Activity_Class['all'] ); ?>" href='?page=users-login-monitor/includes/admin/options.php&tab=activity&ulm_activity=all'>
						<?php echo esc_html( __('All', 'users-login-monitor') ); ?>
						<span class="ulm_list_table_filter_status_box_count">(<?php echo esc_html( $ULM_Counts_Active_Users['all'] ); ?>)</span>
					</a> |
					<a class="<?php echo esc_html( $UsersLoginMonitor_Filter_Activity_Class['on'] ); ?>" href='?page=users-login-monitor/includes/admin/options.php&tab=activity&ulm_activity=on'>
						<?php echo esc_html( __('On', 'users-login-monitor') ); ?>
						<span class="ulm_list_table_filter_status_box_count">(<?php echo esc_html( $ULM_Counts_Active_Users['on'] ); ?>)</span>
					</a> |
					<a class="<?php echo esc_html( $UsersLoginMonitor_Filter_Activity_Class['off'] ); ?>" href='?page=users-login-monitor/includes/admin/options.php&tab=activity&ulm_activity=off'>
						<?php echo esc_html( __('Off', 'users-login-monitor') ); ?>
						<span class="ulm_list_table_filter_status_box_count">(<?php echo esc_html( $ULM_Counts_Active_Users['off'] ); ?>)</span>
					</a>
				</div>					
				
				<?php 				
				$UsersLoginMonitor_ListTable -> search_box(__('Search', 'users-login-monitor'), 'search_id');
				
				echo '<div class="ulm_list_table_box">';
					$UsersLoginMonitor_ListTable -> display(); 
				echo '</div>';
				?>
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($nonce); ?>">
			</form>
		</div>		
	</div>
<?php	
	class ULM_ListTable extends WP_List_Table {			
		public function prepare_items() {
			$columns = $this->get_columns();
			$hidden = $this->get_hidden_columns();
			$sortable = $this->get_sortable_columns();
			$data = $this->table_data();
			usort( $data, array( &$this, 'sort_data' ) );
			$perPage = 20;
			$currentPage = $this->get_pagenum();
			$totalItems = UsersLoginMonitor_RealCount($data);
			$this->set_pagination_args (array(
				'total_items' => $totalItems,
				'per_page'    => $perPage
			) );
			$data = array_slice($data,(($currentPage-1)*$perPage),$perPage);
			$this->_column_headers = array($columns, $hidden, $sortable);
			$this->items = $data;
		}	

		public function get_columns() {
			$columns = array(
				'cb'          	=> '<input type="checkbox" />',
				'user_id'       => 'User ID',
				'user_login'    => 'Login',
				'date'       	=> 'Login Date-Time',
				'ip'       		=> 'IP',				
				'details'		=> 'Details',
			);

			$cb = array('cb' => '<input type="checkbox" />');
			$columns = array_merge($cb, $columns);
			
			$columns['active'] = 'Last Activity';
			
			return $columns;
		}

		public function get_hidden_columns() {
			return array();
		}
		
		public function get_sortable_columns() {
			$sortable_columns = array(
				'user_id' => array('user_id', false),
				'user_login' => array('user_login', false),
				'date' => array('date', false),
				'ip' => array('ip', false),
				'details' => array('details', false),
				'active' => array('active', false),
			  );
			return $sortable_columns;
		}			

		function extra_tablenav( $which ){
			// echo '<div class="ulm_list_table_filter_ext_box">Ext.Filter</div>';
		}
		
		private function table_data() {
			global $UsersLoginMonitor_Search;
			global $UsersLoginMonitor_Filter_Activity;
				
			$UsersLoginMonitor_Timer_Activity = UsersLoginMonitor_Get_Options('timer_activity');

			$Records = array();
			
			$ULM_Users_Active = get_transient ('ulm_users_active');
			
			if ($ULM_Users_Active) {
				$Members = array();
				
				// Отбор по Фильтру.
				if ($UsersLoginMonitor_Filter_Activity) {
					foreach ($ULM_Users_Active as $Member) {
						if (isset($Member['last_time'])){
							if ($UsersLoginMonitor_Filter_Activity == 'all') {
								$Member_ID = $Member['id'];							
								$Members[] = $Member_ID;								
							}
							if ($UsersLoginMonitor_Filter_Activity == 'on') {
								if ($Member['last_time'] > time() - $UsersLoginMonitor_Timer_Activity ){
									$Member_ID = $Member['id'];							
									$Members[] = $Member_ID;
								}
							}
							if ($UsersLoginMonitor_Filter_Activity == 'off') {
								if ($Member['last_time'] <= time() - $UsersLoginMonitor_Timer_Activity ){
									$Member_ID = $Member['id'];							
									$Members[] = $Member_ID;
								}
							}
						}					
					}
				} else {
					foreach ($ULM_Users_Active as $Member) {
						if (isset($Member['last_time'])){
							$Member_ID = $Member['id'];
							
							$Members[] = $Member_ID;
						}					
					}
				}
			}
			
			if ($Members) {				
				$Records = UsersLoginMonitor_Get_Log_User_Data ($Mode = 'activity', $Members);
				
				$Item_Key = 0;
				foreach ($Records as &$Item) {					
					$Member_ID = $Item['user_id'];
					
					$Item['active'] = $ULM_Users_Active[$Member_ID]['last_time'];
					
					// Поиск.
					if ($UsersLoginMonitor_Search) {
						$Item_Merge = '';

						$pattern = "/$UsersLoginMonitor_Search/i";
						
						if (preg_match ($pattern, $Item_Merge)) {
							// Отставляем этот Элемент
						} else {
							// Удаляем из Списка
							unset ($Records[$Item_Key]);
						}
					}
					
					$Item_Key ++;
				}
			}

			return $Records;
		}
		
		public function column_default( $item, $column_name ) {
			switch( $column_name ) {
				case 'user_id':
				case 'user_login':
				case 'date':
				case 'ip':
				case 'details':
				case 'active':
					return $item[ $column_name ];
				default:
					return $item[ $column_name ];
			}
		}
		
		private function sort_data( $a, $b ) {
			// Set defaults
			$orderby = 'date';
			$order = 'desc';
			
			// If orderby is set, use this as the sort column
			if (!empty($_GET['orderby'])) { // phpcs:ignore 
				$orderby = sanitize_text_field( wp_unslash( $_GET['orderby'] ) ); // phpcs:ignore 
			}
			
			// If order is set use this as the order
			if (!empty($_GET['order'])) { // phpcs:ignore 
				$order = sanitize_text_field( wp_unslash( $_GET['order'] ) ); // phpcs:ignore 
			}
			
			$result = strcmp( $a[$orderby], $b[$orderby] );
			
			if ($order === 'asc') {
				return $result;
			}
			
			return -$result;
		}
		
		// заполнение колонки User_ID
		function column_user_id ($item){
			$User_ID = $item['user_id'];
			
			if (UsersLoginMonitor_User_Exists($User_ID)) {
				echo "<a href='/wp-admin/user-edit.php?user_id=" .esc_html ( $User_ID ) ."' target='_blank' title='Click - to open User Profile'>" .esc_html ( $User_ID ) ."</a>";
			} else {
				echo "<span class='ulm_list_table_box_field_userid_noexist' title='User not Exist'>" .esc_html ( $User_ID ) ."</span>";
			}
		}	

		// заполнение колонки Login
		function column_user_login ($item){
			$User_ID 	= $item['user_id'];
			$User_Login = $item['user_login'];
			
			if (UsersLoginMonitor_User_Exists($User_ID)) {
				echo "<a href='/wp-admin/user-edit.php?user_id=" .esc_html ( $User_ID ) ."' target='_blank' title='Click - to open User Profile'>" .esc_html ( $User_Login ) ."</a>";
			} else {
				echo "<span class='ulm_list_table_box_field_userid_noexist' title='User not Exist'>" .esc_html ( $User_Login ) ."</span>";
			}
		}		
		
		// заполнение колонки Active
		function column_active ($item){			
			$UsersLoginMonitor_Timer_Activity = UsersLoginMonitor_Get_Options('timer_activity');
			
			$Active = 'N/A';
			
			$User_ID = $item['user_id'];
			
			$ULM_Users_Active = get_transient('ulm_users_active');
			
			if ($User_ID && isset($ULM_Users_Active[$User_ID]['last_time']) ) {
				$timezone = get_option('gmt_offset');
				
				$Active = gmdate("Y.m.d H:i", $ULM_Users_Active[$User_ID]['last_time'] + $timezone * 3600);
				
				if ($ULM_Users_Active[$User_ID]['last_time'] > time() - $UsersLoginMonitor_Timer_Activity ){				
					$Active_Class = 'ulm_list_table_box_field_active_on';
				} else {
					$Active_Class = 'ulm_list_table_box_field_active_off';
				}
			}
			
			echo "<span class='" .esc_html ( $Active_Class ) ."'>" .esc_html ( $Active ) ."</span>";
		}		
		
		// заполнение колонки cb
		function column_cb( $item ){
			echo '<input type="checkbox" name="licids[]" id="cb-select-'. esc_html( $item['id'] ) .'" value="'. esc_attr( $item['id'] ) .'" />';	
		}		
	}	