<?php
/*
 * WPGear. 
 * Users Login Monitor
 * tab_log.php
 */
	
    if (!current_user_can('edit_dashboard')) {
        return;
    }
	
	$UsersLoginMonitorPRO_ListTable = new ULM_ListTable();
	$UsersLoginMonitorPRO_ListTable -> prepare_items();
	
	?>
	<div class="wrap">
		<h2><?php echo esc_html( __('Log of Users Activity', 'users-login-monitor') ); ?></h2>
		
		<hr>
		
		<div class="ulm_warning">
			PRO Version only.
		</div>
		
		<div>
			<form id="ulm_form" method="post">
				<input type="hidden" name="page" value="ulm_list_table">
				<input id="ulm_export" type="hidden" name="ulm_export" value="no">
				
				<div class="ulm_list_table_btn_export" title="Export to CSV File with current filtered records.">
					<?php echo esc_html( __('Export CSV', 'users-login-monitor') ); ?>
				</div>
				
				<div class="ulm_list_table_filter_status_box">					
					<?php echo esc_html( __('Status:', 'users-login-monitor') ); ?>					
						<?php echo esc_html( __('All', 'users-login-monitor') ); ?>
						<span class="ulm_list_table_filter_status_box_count">(N/A)</span>
					</a> |
						<?php echo esc_html( __('Logon', 'users-login-monitor') ); ?>
						<span class="ulm_list_table_filter_status_box_count">(N/A)</span>
					</a> |
						<?php echo esc_html( __('Fail', 'users-login-monitor') ); ?>
						<span class="ulm_list_table_filter_status_box_count">(N/A)</span>
					</a>					
				</div>				

				<div class="ulm_list_table_filter_daterange_box">					
					<?php echo esc_html( __('Date Range:', 'users-login-monitor') ); ?>
					<div class="ulm_list_table_filter_daterange_box_field">
						<input id="ulm_daterange1" name="ulm_daterange1" type="date" value="">
					</div>
					
					<div class="ulm_list_table_filter_daterange_box_field">
						<?php echo esc_html( __('To', 'users-login-monitor') ); ?>
						<input id="ulm_daterange2" name="ulm_daterange2" type="date" value="">
					</div>
				</div>
			</form>
		</div>	
	</div>
	
	<?php
	$UsersLoginMonitorPRO_ListTable -> search_box('Search', 'search_id');
	echo '<div class="ulm_list_table_box">';
		$UsersLoginMonitorPRO_ListTable -> display(); 
	echo '</div>';
				
	class ULM_ListTable extends WP_List_Table {			
		public function prepare_items() {
			$columns = $this->get_columns();
			$hidden = $this->get_hidden_columns();
			$sortable = $this->get_sortable_columns();
			$data = $this->table_data();
			// usort( $data, array( &$this, 'sort_data' ) );
			$perPage = 20;
			$currentPage = $this->get_pagenum();
			$totalItems = 0;
			$this->set_pagination_args( array(
				'total_items' => $totalItems,
				'per_page'    => $perPage
			) );
			// $data = array_slice($data,(($currentPage-1)*$perPage),$perPage);
			$this->_column_headers = array($columns, $hidden, $sortable);
			$this->items = $data;
		}	

		public function get_columns() {
			$columns = array(
				'cb'          	=> '<input type="checkbox" />',
				'id'       		=> 'ID',
				'user_id'       => 'User ID',
				'user_login'    => 'Login',
				'date'       	=> 'Date',
				'ip'       		=> 'IP',				
				'details'		=> 'Details',
				'country'       => 'Country',
				'country_code'  => '<span title="Country Code">CC</span>',
				'city'       	=> 'City',
				'region'       	=> 'Region',
				'region_name'   => 'Region Name',
				'lat'       	=> 'Geo Lat',
				'lon'			=> 'Geo Lon',				
				'timezone'		=> 'Time Zone',	
				'isp'			=> 'ISP',	
				'org'			=> 'Org. Name',	
				'zip'			=> 'Zip',
				'asn'			=> 'ASN',	
				'role'			=> 'Role',
				'status'		=> 'Status',	
			);
			
			return $columns;
		}

		public function get_hidden_columns() {
			return array();
		}
		
		public function get_sortable_columns() {
			return array();
		}			

		function extra_tablenav( $which ){
			// echo '<div class="ulm_list_table_filter_ext_box">Ext.Filter</div>';
		}
		
		private function table_data() {			
			return array();
		}
		
		public function column_default( $item, $column_name ) {
			switch( $column_name ) {
				case 'id':
				case 'user_id':
				case 'user_login':
				case 'date':
				case 'ip':
				case 'details':
				case 'country':
				case 'country_code':
				case 'city':
				case 'region':
				case 'region_name':
				case 'lat':
				case 'lon':
				case 'timezone':
				case 'isp':
				case 'org':
				case 'zip':
				case 'asn':
				case 'role':
				case 'status':
					return $item[ $column_name ];
				default:
					return $item[ $column_name ];
			}
		}
		
		private function sort_data( $a, $b ) {
			return true;
		}	
	}	