<?php
/*
 * WPGear. 
 * Users Login Monitor
 * tab_setup.php
 */
	
    if (!current_user_can('edit_dashboard')) {
        return;
    }
	
	$UsersLoginMonitor_Nonce = 'Update_Options_UsersLoginMonitor';
	$nonce = wp_create_nonce ($UsersLoginMonitor_Nonce);	
	
	$UsersLoginMonitor_Options = UsersLoginMonitor_Get_Options();
	
	$UsersLoginMonitor_Digest_Sent = get_option('ulm_digest_date', '0000.00.00' );
	$UsersLoginMonitor_Digest_Size = get_option('ulm_digest_size', 0 );
	
	$UsersLoginMonitor_Digest_Log = esc_html( __('Digest Sent:', 'users-login-monitor') ) ." $UsersLoginMonitor_Digest_Sent | ". esc_html( __('Records: ', 'users-login-monitor') ) ." $UsersLoginMonitor_Digest_Size";

	$Digest_Email_Error = false;
	
	$WP_Nonce 	= isset($_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : 'none';
	$Action 	= isset($_REQUEST['action']) ? sanitize_text_field( wp_unslash( $_REQUEST['action'] ) ) : null;
	
	if ($Action == 'Update') {
		if (! wp_verify_nonce( $WP_Nonce, $UsersLoginMonitor_Nonce )) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="ulm_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'users-login-monitor') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}
		
		$New_Option_AdminOnly 		= isset($_REQUEST['ulm_option_adminonly']) ? 1 : 0;	
		$New_Option_Enable 			= isset($_REQUEST['ulm_option_enable']) ? 1 : 0;	
		$New_Option_Clearing 		= isset($_REQUEST['ulm_option_clearing']) ? 1 : 0;		
		$New_Option_Digest_Enable 	= isset($_REQUEST['ulm_option_digest_enable']) ? 1 : 0;
		$New_Option_Digest_Email 	= (isset($_REQUEST['ulm_option_digest_email']) && $_REQUEST['ulm_option_digest_email'] != '') ? sanitize_email( wp_unslash( $_REQUEST['ulm_option_digest_email'] ) ) : get_option('admin_email' );	
		$New_Option_Dashboard_Size 	= (isset($_REQUEST['ulm_option_dashboard_size']) && $_REQUEST['ulm_option_dashboard_size'] != '') ? sanitize_text_field( wp_unslash( $_REQUEST['ulm_option_dashboard_size']) ) : 10;
		$New_Option_Timer_Activity	= isset($_REQUEST['ulm_option_timer_activity']) ? sanitize_text_field( wp_unslash( $_REQUEST['ulm_option_timer_activity'] ) ) : 60;

		if (! filter_var($New_Option_Digest_Email, FILTER_VALIDATE_EMAIL)) {
			$Digest_Email_Error = "! Invalid email.";
		}	

		if (! is_numeric($New_Option_Timer_Activity)) {
			$New_Option_Timer_Activity = 60; // Set Default.
		}

		if (! $Digest_Email_Error) {
			$UsersLoginMonitor_Options = array(
				'adminonly' => $New_Option_AdminOnly,
				'enable' => $New_Option_Enable,
				'clearing' => $New_Option_Clearing,
				'digest_enable' => $New_Option_Digest_Enable,
				'digest_email' => $New_Option_Digest_Email,
				'dashboard_size' => $New_Option_Dashboard_Size,
				'timer_activity' => $New_Option_Timer_Activity,
				);
			
			update_option ('users-login-monitor_options', $UsersLoginMonitor_Options); // phpcs:ignore 
		}		
	}

	$UsersLoginMonitor_AdminOnly		= $UsersLoginMonitor_Options['adminonly'];
	$UsersLoginMonitor_Enable 			= $UsersLoginMonitor_Options['enable'];
	$UsersLoginMonitor_Clearing 		= $UsersLoginMonitor_Options['clearing'];
	$UsersLoginMonitor_Digest_Enable 	= $UsersLoginMonitor_Options['digest_enable'];
	$UsersLoginMonitor_Digest_Email 	= $UsersLoginMonitor_Options['digest_email'];
	$UsersLoginMonitor_Dashboard_Size	= $UsersLoginMonitor_Options['dashboard_size'];
	$UsersLoginMonitor_Timer_Activity 	= $UsersLoginMonitor_Options['timer_activity'];
	
?>
	<div class="wrap">
		<h2><?php echo esc_html( __('Setup', 'users-login-monitor') ); ?></h2>
		<hr>	
		
		<div class="ulm_options_box">
			<form name="form_ULM_Options" method="post" style="margin-top: 20px; margin-left: 20px;">
				<h3><?php echo esc_html( __('General', 'users-login-monitor') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="ulm_options_field_label">
									<label for="ulm_option_adminonly">
										<?php echo esc_html( __('Enable this Page for Admin only', 'users-login-monitor') ); ?>
									</label>
								</th>
								<td class="ulm_options_field_input">
									<input id="ulm_option_adminonly" name="ulm_option_adminonly" type="checkbox" <?php if($UsersLoginMonitor_AdminOnly) {echo 'checked';} ?>>
									<span class="ulm_options_field_description">
										<?php echo esc_html( __('On/Off', 'users-login-monitor') ); ?>
									</span>
								</td>
							</tr>
							
							<tr>
								<th scope="row" class="ulm_options_field_label">
									<label for="ulm_option_enable">
										<?php echo esc_html( __('Enable "Users Login Monitor"', 'users-login-monitor') ); ?>
									</label>
								</th>
								<td class="ulm_options_field_input">
									<input id="ulm_option_enable" name="ulm_option_enable" type="checkbox" <?php if($UsersLoginMonitor_Enable) {echo 'checked';} ?>>
									<span class="ulm_options_field_description">
										<?php echo esc_html( __('On/Off', 'users-login-monitor') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Widgets', 'users-login-monitor') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>	
							<tr>
								<th scope="row" class="ulm_options_field_label">
									<label for="ulm_option_dashboard_size">
										<?php echo esc_html( __('Widget: Number of last login users-list: ', 'users-login-monitor') ); ?>
									</label>
								</th>
								<td class="ulm_options_field_input">
									<input id="ulm_option_dashboard_size" name="ulm_option_dashboard_size" type="text" style="width: 60px; text-align: center;" value="<?php echo esc_attr( $UsersLoginMonitor_Dashboard_Size ); ?>">
									<span class="ulm_options_field_description">
										<?php echo esc_html( __('How many Last Login Users to display in the console widget.', 'users-login-monitor') ); ?>
									</span>
								</td>
							</tr>	

							<tr>
								<th scope="row" class="ulm_options_field_label">
									<label for="ulm_option_timer_activity">
										<?php echo esc_html( __('Admin-Bar: Activity control period: ', 'users-login-monitor') ); ?>
									</label>
								</th>
								<td class="ulm_options_field_input">
									<input id="ulm_option_timer_activity" name="ulm_option_timer_activity" type="text" style="width: 60px; text-align: center;" value="<?php echo esc_attr( $UsersLoginMonitor_Timer_Activity ); ?>">
									<span class="ulm_options_field_description">
										<?php echo esc_html( __('How often to update data. (sec)', 'users-login-monitor') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Digest notifications', 'users-login-monitor') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>	
							<tr>
								<th scope="row" class="ulm_options_field_label">
									<label for="ulm_option_digest_enable">
										<?php echo esc_html( __('Daily-digest notifications: ', 'users-login-monitor') ); ?>
									</label>
								</th>
								<td class="ulm_options_field_input">
									<input id="ulm_option_digest_enable" name="ulm_option_digest_enable" type="checkbox" <?php if($UsersLoginMonitor_Digest_Enable) {echo 'checked';} ?>>
									<span class="ulm_options_field_description">
										<?php echo esc_html( __('Daily-digest notifications. On/Off', 'users-login-monitor') ); ?>
									</span>
								</td>
							</tr>
							
							<tr>
								<th scope="row" class="ulm_options_field_label">
									<label for="ulm_option_digest_email" <?php if(!$UsersLoginMonitor_Digest_Enable) {echo 'style="color: darkgrey;"';} ?> >
										<?php echo esc_html( __('E-mail for daily-digest notifications: ', 'users-login-monitor') ); ?>
									</label>
								</th>
								<td class="ulm_options_field_input">
									<input id="ulm_option_digest_email" name="ulm_option_digest_email" type="text" value="<?php echo esc_attr( $UsersLoginMonitor_Digest_Email ); ?>">
									<span class="ulm_options_field_description">
										<?php echo esc_html( __('Who will receive daily notifications?', 'users-login-monitor') ); ?>
									</span>
									<div id="digest_email_note" style="color: red;"><?php if($Digest_Email_Error) {echo esc_attr( $Digest_Email_Error );} ?></div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				
				<hr>
				
				<div class="ulm_options_pro_version">
					<h3><?php echo esc_html( __('Log controls', 'users-login-monitor') ); ?></h3>
					
					<div class="ulm_warning">
						PRO Version only.
					</div>
					
					<div style="margin-left: 20px; margin-bottom: 10px;">
						<table class="form-table">
							<tbody>	
								<tr>
									<th scope="row" class="ulm_options_field_label">
										<label for="ulm_csv_export_all_columns">
											<?php echo esc_html( __('CSV Export (All Columns)', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_csv_export_all_columns" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('On/Off', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
					
					<div style="margin-left: 20px; margin-bottom: 10px;">
						<table class="form-table">
							<tbody>	
								
								<div style="margin-top: 10px;">
									<hr>
									<h4><?php echo esc_html( __('Log List Columns:', 'users-login-monitor') ); ?></h4>
								</div>	
								
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[id]">
											<?php echo esc_html( __('ID', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[id]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Record ID', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[user_id]">
											<?php echo esc_html( __('User ID', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[user_id]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The User ID', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[user_login]">
											<?php echo esc_html( __('User Login', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[user_login]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The User Login', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[date]">
											<?php echo esc_html( __('Date', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[date]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Date of the event', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[ip]">
											<?php echo esc_html( __('IP', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[ip]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The IP address', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[details]">
											<?php echo esc_html( __('Details', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[details]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Browser Details', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[country]">
											<?php echo esc_html( __('Country', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[country]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Country name', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[country_code]">
											<?php echo esc_html( __('Cnt', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[country_code]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Country Code', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[city]">
											<?php echo esc_html( __('City', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[city]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The City name', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[region]">
											<?php echo esc_html( __('Region Code', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[region]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Region Code', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[region_name]">
											<?php echo esc_html( __('Region Name', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[region_name]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Region Name', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[lat]">
											<?php echo esc_html( __('Lat', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[lat]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Coordinates. Latitude', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[lon]">
											<?php echo esc_html( __('Lon', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[lon]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Coordinates. Longitude', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[timezone]">
											<?php echo esc_html( __('Time Zone', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[timezone]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Time Zone', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[isp]">
											<?php echo esc_html( __('ISP', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[isp]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Internet Service Provider', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[org]">
											<?php echo esc_html( __('Org. Name', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[org]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Organization Name', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[zip]">
											<?php echo esc_html( __('ZIP', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[zip]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Postal ZIP Code', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[asn]">
											<?php echo esc_html( __('ASN', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[asn]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Autonomous System Number', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[role]">
											<?php echo esc_html( __('Role', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[role]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The User Role', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>	
								<tr>
									<th scope="row" class="ulm_options_field_label_right">
										<label for="ulm_log_list_columns[status]">
											<?php echo esc_html( __('Status', 'users-login-monitor') ); ?>
										</label>
									</th>
									<td class="ulm_options_field_input">
										<input id="ulm_log_list_columns[status]" type="checkbox">
										<span class="ulm_options_field_description">
											<?php echo esc_html( __('The Status of an attempt to Authorize', 'users-login-monitor') ); ?>
										</span>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Clearing', 'users-login-monitor') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>							
							<tr>
								<th scope="row" class="ulm_options_field_label">
									<label for="ulm_option_clearing">
										<?php echo esc_html( __('Delete MetaData with Uninstall Plugin.', 'users-login-monitor') ); ?>
									</label>
								</th>
								<td class="ulm_options_field_input">
									<input id="ulm_option_clearing" name="ulm_option_clearing" type="checkbox" <?php if($UsersLoginMonitor_Clearing) {echo 'checked';} ?>>
									<span class="ulm_options_field_description">
										<?php echo esc_html( __('On/Off', 'users-login-monitor') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Report', 'users-login-monitor') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="ulm_options_field_label">
									<i class="fa fa-check" aria-hidden="true"></i>
									<span style="margin-right: 10px; color: black;">
										<?php echo esc_html( __('Operating:', 'users-login-monitor') ); ?>
									</span>
								</th>
								<td class="ulm_options_field_input">
									<?php echo esc_html( $UsersLoginMonitor_Digest_Log ); ?>
								</td>
							</tr>
						</tbody>
					</table>
				</div>

				<hr>				
				
				<div style="margin-top: 20px; margin-bottom: 5px; text-align: right;">
					<input id="btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_html( __('Save', 'users-login-monitor') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="Update">
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($nonce); ?>">
			</form>
		</div>		
	</DIV>