<?php
/*
 * WPGear. Users Login Monitor
 * functions.php
 */
 
	/* Get_Options / Option
	----------------------------------------------------------------- */ 	
	function UsersLoginMonitor_Get_Options( $Option = null ) {
		$admin_email = get_option('admin_email');
		
		$UsersLoginMonitor_Options = get_option( "users-login-monitor_options", array(
			'adminonly' => 1,
			'enable' => 1,
			'clearing' => 1,
			'digest_enable' => 1,
			'digest_email' => $admin_email,
			'dashboard_size' => 10,
			'timer_activity' => 60,
			)
		);		
		
		$UsersLoginMonitor_AdminOnly		= isset( $UsersLoginMonitor_Options['adminonly'] ) ? $UsersLoginMonitor_Options['adminonly'] : 1;					// Доступ к Настройкам.
		$UsersLoginMonitor_Enable 			= isset( $UsersLoginMonitor_Options['enable'] ) ? $UsersLoginMonitor_Options['enable'] : 1;							// On/Off - Обработчик.
		$UsersLoginMonitor_Clearing 		= isset( $UsersLoginMonitor_Options['clearing'] ) ? $UsersLoginMonitor_Options['clearing'] : 1;						// Необходимость удаления Мета-Данных.
		$UsersLoginMonitor_Digest_Enable 	= isset( $UsersLoginMonitor_Options['digest_enable'] ) ? $UsersLoginMonitor_Options['digest_enable'] : 1;			// On/Off - дайджест об угрозах безопасности.
		$UsersLoginMonitor_Digest_Email 	= isset( $UsersLoginMonitor_Options['digest_email'] ) ? $UsersLoginMonitor_Options['digest_email'] : $admin_email;	// Адрес получателя дайджеста об угрозах безопасности.
		$UsersLoginMonitor_Dashboard_Size	= isset( $UsersLoginMonitor_Options['dashboard_size'] ) ? $UsersLoginMonitor_Options['dashboard_size'] : 10;		// Количество пользователей в виджете консоли.
		$UsersLoginMonitor_Timer_Activity 	= isset( $UsersLoginMonitor_Options['timer_activity'] ) ? $UsersLoginMonitor_Options['timer_activity'] : 60;		// Период контроля Активности..
		
		$UsersLoginMonitor_Dashboard_Size = intval($UsersLoginMonitor_Dashboard_Size);
		$UsersLoginMonitor_Timer_Activity = intval($UsersLoginMonitor_Timer_Activity);
		
		$UsersLoginMonitor_Options = array(
			'adminonly' => $UsersLoginMonitor_AdminOnly,
			'enable' => $UsersLoginMonitor_Enable,
			'clearing' => $UsersLoginMonitor_Clearing,
			'digest_enable' => $UsersLoginMonitor_Digest_Enable,
			'digest_email' => $UsersLoginMonitor_Digest_Email,
			'dashboard_size' => $UsersLoginMonitor_Dashboard_Size,
			'timer_activity' => $UsersLoginMonitor_Timer_Activity,
		);
		
		if ($Option) {
			return $UsersLoginMonitor_Options[$Option];
		}

		return $UsersLoginMonitor_Options;
	}
	
	/* Update Option
	----------------------------------------------------------------- */ 
	function UsersLoginMonitor_Update_Option ( $Option, $Value ) {
		if ($Option) {
			$UsersLoginMonitor_Options = UsersLoginMonitor_Get_Options();
			
			$UsersLoginMonitor_Options[$Option] = $Value;
			
			update_option ('users-login-monitor_options', $UsersLoginMonitor_Options); // phpcs:ignore 
			
			return true;
			
		} else {
			return false;
		}
	}	
 
	/* Request Get_WhoIs.
	----------------------------------------------------------------- */
	function UsersLoginMonitor_Get_WhoIs ($IP) {
		global $wp_version;
		 
		$CURL_Query = "http://ip-api.com/json/$IP";
		
		$CURL_Arg = array(
			'timeout'     => 5,
			'redirection' => 5,
			'httpversion' => '1.0',
			'user-agent'  => 'WordPress/' . $wp_version . '; ' . get_bloginfo( 'url' ),
			'blocking'    => true,
			'headers'     => array(),
			'cookies'     => array(),
			'body'        => null,
			'compress'    => false,
			'decompress'  => true,
			'sslverify'   => false,
			'stream'      => false,
			'filename'    => null
		);
			
		$CURL_Answer = wp_remote_get ($CURL_Query, $CURL_Arg);

		if (is_wp_error ($CURL_Answer)) {
			$Error_Eessage = $CURL_Answer -> get_error_message();
			
			return null;
		} else {
			if ($CURL_Answer) {
				$CURL_Answer_Code 		= isset($CURL_Answer['response']['code']) ? $CURL_Answer['response']['code'] : 'N/A';
				$CURL_Answer_Message	= isset($CURL_Answer['response']['message']) ? $CURL_Answer['response']['message'] : 'N/A';
				$CURL_Response 			= isset($CURL_Answer['body']) ? $CURL_Answer['body'] : 'N/A';	
				
				return $CURL_Response;
			}						
		}		
	}
	
	/* TimeStamp
	----------------------------------------------------------------- */	
	function UsersLoginMonitor_Get_TimeStamp ($Format = "Y-m-d H:i:s") {
		$TimeZone 	= get_option('gmt_offset');
		$TimeStamp 	= gmdate($Format, strtotime($TimeZone ." Hours"));		

		return $TimeStamp;
	}

	/* Get User IP
	----------------------------------------------------------------- */
	function UsersLoginMonitor_Get_UserIP () {
		$Server_Remote_Addr = isset ($_SERVER['REMOTE_ADDR']) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : '';
		$User_IP = isset ($_SERVER['HTTP_X_FORWARDED_FOR']) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ): $Server_Remote_Addr;
		$User_IP = isset ($_SERVER['HTTP_X_REAL_IP']) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_REAL_IP'] ) ) : $User_IP;

		return $User_IP;
	}
	
	/* Get Browser Info
	----------------------------------------------------------------- */	
	function UsersLoginMonitor_Get_BrowserInfo () {
		// Try use Browscap PHP Lib.        
		
		$Browser_Log = '---';
		
		if (function_exists('get_browser') && ini_get('browscap')) {			
			$browser = get_browser(null, true);
			
			if ($browser) {
				$Browser_Log = $browser['browser'] .', ' .$browser['platform'] .', ' .$browser['device_type'];
			} else {
				// Try use Plugin: 'Quick Browscap'. https://wordpress.org/plugins/quick-browscap/
				global $quick_browscap;

				if (isset($quick_browscap) && is_object($quick_browscap)) {
					$bw_info = $quick_browscap->get_browser(null, true);

					$Browser_Log = $bw_info['Browser'] .', ' .$bw_info['Platform'];
				}
			}
		} 
		
		return $Browser_Log;		
	}	

	/* Check Plugin Installed
	----------------------------------------------------------------- */		
	function UsersLoginMonitor_Check_Plugin_Installed($Plugin_Slug = null) {
		$Result = false;
		
		if ($Plugin_Slug) {
			if (! function_exists ('get_plugins')) {
				require_once ABSPATH . 'wp-admin/includes/plugin.php';
			}
			
			$Plugins = get_plugins();
			
			foreach ($Plugins as $Plugin) {
				$Plugin_TextDomain = $Plugin['TextDomain'];
				if ($Plugin_TextDomain == $Plugin_Slug) {
					$Result = true;
				}
			}			
		}	
		
		return $Result;
	}
	
	/* RealCount
	----------------------------------------------------------------- */		
	function UsersLoginMonitor_RealCount($X) {
		// Решение проблемы с Ошибкой Обратной Совместимости PHP7*. Count()
		// теперь, в PHP7* и выше, count() работает только с параметром типа array. Возвращает не 0, если не array, а Ошибку.
		$Result = 0;
		
		if (is_array ($X)) {
			$Result = count($X);
		}
		
		return $Result;
	}	
	
	/* Check User Exist
	----------------------------------------------------------------- */	
	function UsersLoginMonitor_User_Exists($User_ID) {
		$User_Data = get_user_by( 'ID', $User_ID );	
		
		if ($User_Data) {
			return true; 
		} else {
			return false; 
		}
	}	

	/* Get Log User - Data.
	----------------------------------------------------------------- */
	function UsersLoginMonitor_Get_Log_User_Data ($Mode, $Users_ID = null) {		
		$Records = array();
		
		foreach ($Users_ID as $User_ID) {
			$User_LogData = array();

			$User_MetaData = get_user_meta ($User_ID);

			if ($User_MetaData) {
				$User_LogData['id'] 		= $User_ID;
				$User_LogData['user_id'] 	= $User_ID;
				$User_LogData['user_login'] = isset( $User_MetaData['nickname'][0] ) ? $User_MetaData['nickname'][0] : 'N/A';
				$User_LogData['date'] = 	isset( $User_MetaData['ulm_lastlogin'][0] ) ? $User_MetaData['ulm_lastlogin'][0] : 'N/A';
				$User_LogData['ip'] = 		isset( $User_MetaData['ulm_user_ip'][0] ) ? $User_MetaData['ulm_user_ip'][0] : 'N/A';
				$User_LogData['details'] 	= isset( $User_MetaData['ulm_browser'][0] ) ? $User_MetaData['ulm_browser'][0] : 'N/A';
			
				$Records[] = $User_LogData;
			}			
		}
		
		return $Records;
	}	
	
	/* Get Count Active Users
	----------------------------------------------------------------- */
	function UsersLoginMonitor_Get_Counts_Active_Users () {
		$UsersLoginMonitor_Timer_Activity = UsersLoginMonitor_Get_Options('timer_activity');
		
		$ULM_Counts_Active_Users = array (
			'all' => 1,
			'on' => 1,
			'off' => 0,
		);
		
		$ULM_Users_Active = get_transient ('ulm_users_active');
		
		if ($ULM_Users_Active) {
			$ULM_Counts_Active_Users['all']	= 0;
			$ULM_Counts_Active_Users['on']	= 0;
			$ULM_Counts_Active_Users['off']	= 0;
			
			foreach ( $ULM_Users_Active as $Member ) {
				if (isset($Member['last_time']) && $Member['last_time'] > time() - $UsersLoginMonitor_Timer_Activity ){
					$ULM_Counts_Active_Users['on'] ++;
				} else {
					$ULM_Counts_Active_Users['off'] ++;				
				}
			}
			
			if ($ULM_Counts_Active_Users['on'] == 0) {
				// Иногда, вдруг такое бывает. Почему - непонятно.
				$ULM_Counts_Active_Users['on'] = 1;
			}
			$ULM_Counts_Active_Users['all'] = $ULM_Counts_Active_Users['on'] + $ULM_Counts_Active_Users['off'];		
		}

		return $ULM_Counts_Active_Users;
	}	
	
	/* Update Users-Data Transient
	----------------------------------------------------------------- */
	function UsersLoginMonitor_Update_UsersData_Transient () {
		$ULM_Users_Active = get_transient('ulm_users_active');

		$User = wp_get_current_user ();

		if ($User) {
			$User_ID = $User -> ID;
			
			$UsersLoginMonitor_Timer_Activity = UsersLoginMonitor_Get_Options('timer_activity');
			
			if ($User_ID) {
				if (!is_array($ULM_Users_Active)) {
					$ULM_Users_Active = array();
				}
				
				if ( !isset($ULM_Users_Active[$User_ID]['last_time']) || $ULM_Users_Active[$User_ID]['last_time'] <= time() - $UsersLoginMonitor_Timer_Activity ){
					$ULM_Users_Active[$User_ID] = array(
						'id' => $User_ID,
						'last_time' => time(),
					);
			
					// Transient. Устанавливаем со временем жизни 24 часа
					set_transient ('ulm_users_active', $ULM_Users_Active, 86400);			
				}			
			}
		}
	}