<?php
/*
 * WPGear. 
 * Users Login Monitor
 * users.php
 */

	/* Admin. Users. Creat new columns.
	----------------------------------------------------------------- */
	add_filter ('manage_users_columns', 'UsersLoginMonitor_Filter_columns');	
	function UsersLoginMonitor_Filter_columns ($column) {
		$column['last_login'] 	= 'Last Login';
		$column['user_ip'] 		= 'IP Details';
		
		return $column;
	}	
	
	/* Admin. Users. 
	 Create "Last Login" column.
	----------------------------------------------------------------- */			
	add_filter ('manage_users_custom_column', 'UsersLoginMonitor_last_login_column', 10, 3 );	
	function UsersLoginMonitor_last_login_column ($val, $column_name, $User_ID) {
		if ('last_login' != $column_name ) {
			return $val;
		} else {
			$meta_key = 'ulm_lastlogin';
			$User_LastLogin = get_user_meta ($User_ID, $meta_key, true);
			
			return $User_LastLogin;
		}
	}

	/* Admin. Users. 
	 Create "IP Details" column.
	----------------------------------------------------------------- */	
	add_filter ('manage_users_custom_column', 'UsersLoginMonitor_IP_Detail_column', 10, 3 );		
	function UsersLoginMonitor_IP_Detail_column ($val, $column_name, $User_ID) {
		if ('user_ip' != $column_name ) {
			return $val;
		} else {
			$meta_key = 'ulm_user_ip';
			$user_ip = get_user_meta ($User_ID, $meta_key, true);
			
			$meta_key = 'ulm_browser';
			$browser_log = get_user_meta ($User_ID, $meta_key, true);
			
			$IP_Details = $user_ip .' ' .$browser_log;
			
			return $IP_Details;
		}
	}

	/* Admin. Users.
	 Make "Last Login" column - Sortable.
	----------------------------------------------------------------- */	
	add_filter ('manage_users_sortable_columns', 'UsersLoginMonitor_last_login_column_sortable' );	
	function UsersLoginMonitor_last_login_column_sortable ($sortable_columns) {
		$sortable_columns['last_login'] = 'last_login';
		
		return $sortable_columns;
	}	
	
	/* Admin. Users.
	 Sorting "Last Login" column.
	----------------------------------------------------------------- */	
	add_filter ('pre_user_query','UsersLoginMonitor_last_login_column_orderby');		
	function UsersLoginMonitor_last_login_column_orderby ( $user_query ) {	
		global $wpdb, $current_screen;
		
		if ($current_screen -> id != 'users') return;
			
		$usermeta_table = $wpdb -> prefix .'usermeta';
		$users_table 	= $wpdb -> prefix .'users';
		
		$vars = $user_query -> query_vars;	
		
		if($vars['orderby'] == 'last_login') {
			$user_query -> query_from = " FROM $users_table INNER JOIN $usermeta_table ON ($users_table.ID = $usermeta_table.user_id)";
			$user_query -> query_where = " WHERE $usermeta_table.meta_key = 'ulm_lastlogin'";	
			$user_query -> query_orderby = " ORDER BY $usermeta_table.meta_value ". $vars['order'];
		}
		
		return $user_query;	
	}	