<?php
/*
 * WPGear. 
 * Users Login Monitor
 * widgets.php
 */
 
	/* Admin Bar. Active Users Info
	----------------------------------------------------------------- */
	add_action ('admin_bar_menu','UsersLoginMonitor_Action_AdminBar_Info', 999);
	function UsersLoginMonitor_Action_AdminBar_Info () {
		global $wp_admin_bar;
		
		if (!current_user_can('edit_dashboard')) {
			return;
		}
			
		$ULM_Count_Active_Users = 1;
		
		$ULM_Counts_Active_Users = UsersLoginMonitor_Get_Counts_Active_Users ();
		
		if ($ULM_Counts_Active_Users) {
			$ULM_Count_Active_Users = $ULM_Counts_Active_Users['on'];
		}		
		
		// $UsersLoginMonitor_Nonce = 'Admin Bar.Activity_UsersLoginMonitor';
		// $nonce = wp_create_nonce ($UsersLoginMonitor_Nonce);	
		
		$wp_admin_bar -> add_menu (
			array (
				'id' => 'ulm_active_users_info', 
				'title' => '<span class="">' . __( 'Activity', 'users-login-monitor') .' (' .$ULM_Count_Active_Users .')' .'</span>',
				'href' => esc_url (admin_url('users.php?page=users-login-monitor/includes/admin/options.php&tab=activity&direct=1'))
			)
		);
	}
	
	/* Create Users-Login-Monitor DashboardWidget
	----------------------------------------------------------------- */	
	add_action ('wp_dashboard_setup', 'UsersLoginMonitor_Dashboard_Widgets_UsersLogin');	function UsersLoginMonitor_Dashboard_Widgets_UsersLogin () {
		if (current_user_can('edit_dashboard')) {
			global $wp_meta_boxes;
			
			wp_add_dashboard_widget ('ulm_lastlogin_widget', 'Users Login Monitor', 'UsersLoginMonitor_Dashboard_UsersLogin');			
		}
	}
	
	/* Users-Login-Monitor DashboardWidget
	----------------------------------------------------------------- */	
	function UsersLoginMonitor_Dashboard_UsersLogin () {
		global $wpdb;
		
		$UsersLoginMonitor_Dashboard_Size = UsersLoginMonitor_Get_Options('dashboard_size');
		
		$users_table 	= $wpdb -> prefix .'users';
		$usermeta_table = $wpdb -> prefix .'usermeta';

		$Query = "
			SELECT $users_table.ID, $users_table.user_login, $usermeta_table.meta_value as last_login
			FROM $users_table 
			INNER JOIN $usermeta_table ON ($users_table.ID = $usermeta_table.user_id)
			WHERE meta_key = 'ulm_lastlogin' ORDER BY meta_value DESC LIMIT %d";
			
		$users = $wpdb -> get_results ($wpdb -> prepare ($Query, $UsersLoginMonitor_Dashboard_Size)); // phpcs:ignore 			
		?>
		
		<table style="width: 100%">
			<tbody style="text-align: left;">
				<th><h3>Last Login</h3></th>
				<th><h3>Login</h3></th>
				<th><h3>WhoIs IP</h3></th>
				<th><h3>Success</h3></th>
				<th><h3>Device</h3></th>
				<?php 
				
				foreach ($users as $user) {
					$User_ID 	= $user -> ID;
					$User_Login = $user -> user_login;
					
					$meta_key = 'ulm_user_ip';
					$User_IP = get_user_meta( $User_ID, $meta_key, true );
					
					$meta_key = 'ulm_browser';
					$User_Device = get_user_meta( $User_ID, $meta_key, true );

					$meta_key = 'ulm_whois';
					$WhoIs = get_user_meta( $User_ID, $meta_key, true );

					$meta_key = 'ulm_count_login_success';
					$User_Login_Success = intval (get_user_meta ($User_ID, $meta_key, true));

					$meta_key = 'ulm_count_login_total';
					$User_Login_Total = intval (get_user_meta ($User_ID, $meta_key, true));	

					$Login_Counts = '---';
					if ($User_Login_Total > 0) {
						$Login_Counts = round ($User_Login_Success * 100 / $User_Login_Total,0);
						$Login_Counts .= "% ($User_Login_Total)";
					}
					?>
					<tr>
						<td>
							<?php echo esc_html( gmdate ('Y-m-d H:i', strtotime($user -> last_login)) );?>
						</td>
						
						<td>
							<a href="<?php echo esc_url( get_edit_user_link ($User_ID) ); ?>"><?php echo esc_html( $User_Login ); ?></a>
						</td>
						
						<td>
							<span class="ulm_dashboard_widget_whois" title="<?php echo esc_html( $WhoIs ); ?>">
								<?php echo esc_html( $User_IP ); ?>
							</span>
						</td>
						
						<td>
							<span class="ulm_dashboard_widget_counts" title="<?php echo esc_html( $User_Login_Total ); ?>">
								<?php echo esc_html( $Login_Counts ); ?>
							</span>
						</td>						
						
						<td>
							<?php echo esc_html( $User_Device ); ?>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
		
		<script>
			var ULM_Widget = document.getElementById("ulm_lastlogin_widget");
			var ULM_Widget_Header = ULM_Widget.getElementsByTagName("h2")[0];
			
			ULM_Widget_Header.innerHTML = '<span title="Click to open Setup-Option Page"><a href="/wp-admin/users.php?page=users-login-monitor/includes/admin/options.php" class="ulm_dashboard_widget_header">Users Login Monitor</a></span>';
		</script>		
	<?php 
	}	