<?php
/*
 * WPGear. 
 * Hack-Info
 * functions.php
 */
 
	/* Get_Options / Option
	----------------------------------------------------------------- */ 	
	function HackInfo_Get_Options( $Option = null ) {
		$debug_process = 'f_get_options';
		
		$admin_email = get_option('admin_email');
		
		$HackInfo_Options = get_option( "hack-info_option", array(
			'adminonly' => 1,
			'enable' => 1,
			'clearing' => 1,
			'digest_enable' => 1,
			'digest_email' => $admin_email,
			'digest_timer' => 12,
			'digest_sent' => 'N/A',
			'digest_size' => 'N/A',
			'whois_enable' => 1,
			'db_version' => '0',
			)
		);		
		
		$HackInfo_AdminOnly		= isset( $HackInfo_Options['adminonly'] ) ? $HackInfo_Options['adminonly'] : 1;						// Доступ к Настройкам.
		$HackInfo_Enable 		= isset( $HackInfo_Options['enable'] ) ? $HackInfo_Options['enable'] : 1;							// On/Off - Обработчик.
		$HackInfo_Clearing 		= isset( $HackInfo_Options['clearing'] ) ? $HackInfo_Options['clearing'] : 1;						// Необходимость удаления Мета-Данных.
		$HackInfo_Digest_Enable = isset( $HackInfo_Options['digest_enable'] ) ? $HackInfo_Options['digest_enable'] : 1;				// On/Off - дайджест об угрозах безопасности.
		$HackInfo_Digest_Email 	= isset( $HackInfo_Options['digest_email'] ) ? $HackInfo_Options['digest_email'] : $admin_email;	// Адрес получателя дайджеста об угрозах безопасности.
		$HackInfo_Digest_Timer	= isset( $HackInfo_Options['digest_timer'] ) ? $HackInfo_Options['digest_timer'] : 12;				// Период отправки Уведомлений.
		$HackInfo_Digest_Sent	= isset( $HackInfo_Options['digest_sent'] ) ? $HackInfo_Options['digest_sent'] : 'N/A';				// TimeStamp Отправки Дайджеста.
		$HackInfo_Digest_Size	= isset( $HackInfo_Options['digest_size'] ) ? $HackInfo_Options['digest_size'] : 'N/A';				// Количество Событий в Дайджесте.
		$HackInfo_WhoIs_Enable 	= isset( $HackInfo_Options['whois_enable'] ) ? $HackInfo_Options['whois_enable'] : 1;				// On/Off - Получение информации о владельце IP.
		$HackInfo_db_version	= isset( $HackInfo_Options['db_version'] ) ? $HackInfo_Options['db_version'] : '0';					// Версия Структуры Данных.
		
		if (! is_numeric($HackInfo_Digest_Timer)) {
			$HackInfo_Digest_Timer = 12; // Set Default.
		}		
		
		$HackInfo_Options = array(
			'adminonly' => $HackInfo_AdminOnly,
			'enable' => $HackInfo_Enable,
			'clearing' => $HackInfo_Clearing,
			'digest_enable' => $HackInfo_Digest_Enable,
			'digest_email' => $HackInfo_Digest_Email,
			'digest_timer' => $HackInfo_Digest_Timer,
			'digest_sent' => $HackInfo_Digest_Sent,
			'digest_size' => $HackInfo_Digest_Size,
			'whois_enable' => $HackInfo_WhoIs_Enable,
			'db_version' => $HackInfo_db_version,
		);
		
		if ($Option) {
			return $HackInfo_Options[$Option];
		}

		HackInfo_Debugger ($HackInfo_Options, '$HackInfo_Options', $debug_process, __FUNCTION__, __LINE__);
		return $HackInfo_Options;
	}
	
	/* Update Option
	----------------------------------------------------------------- */ 
	function HackInfo_Update_Option ( $Option, $Value ) {
		if ($Option) {
			$HackInfo_Options = HackInfo_Get_Options();
			
			$HackInfo_Options[$Option] = $Value;
			
			update_option ('hack-info_option', $HackInfo_Options); // phpcs:ignore 
			
			return true;
			
		} else {
			return false;
		}
	}

	/* DB. Сохраняем отловленное событие.
	----------------------------------------------------------------- */	
	function HackInfo_Save_Event ($IP, $Type, $URL) {
		$debug_process = 'f_save_event';
		
		HackInfo_Debugger ($IP, '$IP', $debug_process, __FUNCTION__, __LINE__);
		HackInfo_Debugger ($Type, '$Type', $debug_process, __FUNCTION__, __LINE__);
		HackInfo_Debugger ($URL, '$URL', $debug_process, __FUNCTION__, __LINE__);
		
		$HackInfo_WhoIs_Enable = HackInfo_Get_Options('whois_enable');
		HackInfo_Debugger ($HackInfo_WhoIs_Enable, '$HackInfo_WhoIs_Enable', $debug_process, __FUNCTION__, __LINE__);
		
		$TimeStamp = HackInfo_Get_TimeStamp("Y-m-d H:i:s");
				
		if ($HackInfo_WhoIs_Enable && $IP) {
			// WhoIs IP
			$WhoIs = HackInfo_Get_WhoIs($IP);
			HackInfo_Debugger ($WhoIs, '$WhoIs', $debug_process, __FUNCTION__, __LINE__);
		}		
		
		global $wpdb;			

		$Result_Insert = $wpdb -> insert ($wpdb -> prefix .'hackinfo', array('date' => $TimeStamp, 'type' => $Type, 'ip' => $IP, 'details' => $URL, 'whois' => $WhoIs, 'sent' => 0), array('%s', '%s', '%s', '%s', '%s', '%d')); // phpcs:ignore 
		HackInfo_Debugger ($Result_Insert, '$Result_Insert', $debug_process, __FUNCTION__, __LINE__);
			
		return true;
	}
	
	/* TimeStamp
	----------------------------------------------------------------- */
	function HackInfo_Get_TimeStamp ($Format = "Y-m-d H:i:s") {
		$TimeZone 	= get_option('gmt_offset');
		
		$TimeStamp 	= gmdate($Format, strtotime($TimeZone ." Hours"));

		return $TimeStamp;
	}	

	/* Request Get_WhoIs.
	----------------------------------------------------------------- */
	function HackInfo_Get_WhoIs ($IP) {
		$debug_process = 'f_get_whois';
		
		global $wp_version;
		 
		$CURL_Query = "http://ip-api.com/json/$IP";
		
		$CURL_Arg = array(
			'timeout'     => 5,
			'redirection' => 5,
			'httpversion' => '1.0',
			'user-agent'  => 'WordPress/' . $wp_version . '; ' . get_bloginfo( 'url' ),
			'blocking'    => true,
			'headers'     => array(),
			'cookies'     => array(),
			'body'        => null,
			'compress'    => false,
			'decompress'  => true,
			'sslverify'   => false,
			'stream'      => false,
			'filename'    => null
		);
			
		$CURL_Answer = wp_remote_get ($CURL_Query, $CURL_Arg);
		
		if (is_wp_error ($CURL_Answer)) {
			$Error_Eessage = $CURL_Answer -> get_error_message();
			
			// return null;
			return '';
		} else {
			if ($CURL_Answer) {
				$CURL_Answer_Code 		= isset($CURL_Answer['response']['code']) ? $CURL_Answer['response']['code'] : 'N/A';
				$CURL_Answer_Message	= isset($CURL_Answer['response']['message']) ? $CURL_Answer['response']['message'] : 'N/A';
				$CURL_Response 			= isset($CURL_Answer['body']) ? $CURL_Answer['body'] : 'N/A';			
				
				HackInfo_Debugger ($CURL_Response, '$CURL_Response', $debug_process, __FUNCTION__, __LINE__);
				return $CURL_Response;
			}						
		}			
	}	
	
	/* Отправка Уведомлений.
	----------------------------------------------------------------- */	
	function HackInfo_do_send_digest() {	
		$debug_process = 'f_do_send_digest';
		
		$HackInfo_Digest_Enable = HackInfo_Get_Options('digest_enable');
		$HackInfo_Digest_Email 	= HackInfo_Get_Options('digest_email');
		
		HackInfo_Debugger ($HackInfo_Digest_Enable, '$HackInfo_Digest_Enable', $debug_process, __FUNCTION__, __LINE__);
		
		if ($HackInfo_Digest_Enable) {
			$HackInfo_SiteName = get_bloginfo('name');
			
			global $wpdb;

			$Records = $wpdb -> get_results ($wpdb -> prepare ("SELECT * FROM " .$wpdb->prefix .'hackinfo' ." WHERE sent = %d", 0)); // phpcs:ignore 
			HackInfo_Debugger ($Records, '$Records', $debug_process, __FUNCTION__, __LINE__);
			
			$HackInfo_Digest_CountRecords = count($Records);
			
			if ($Records) {				
				$Report_Table = "
					<table style='width: 100%; border-collapse: collapse; border-style: solid; border-width: 2px;'>
						<tbody>
							<tr style='border-style: solid; border-width: thin; background-color: #4CAF50; color: white;'>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>IP Address</th>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>Events</th>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>Description</th>
								<th style='border: 1px solid #ddd; padding: 8px; border-bottom-color: grey;'>Time Stamp</th>
							</tr>
				";
				
				foreach ($Records as $Item) {					
					$HackInfo_Item_IP = $Item->ip;
					$HackInfo_Item_Event = $Item->type;
					$HackInfo_Item_Description = $Item->details;
					$HackInfo_Item_TimeStamp = $Item->date;
					
					$HackInfo_Item_TimeStamp = gmdate("Y.m.d H:i", strtotime($HackInfo_Item_TimeStamp));
					
					$WhoIs = json_decode($Item->whois);
					
					if ($WhoIs) {
						$WhoIs_asn 			= isset($WhoIs->as) ? $WhoIs->as : 'N/A';
						$WhoIs_country 		= isset($WhoIs->country) ? $WhoIs->country : 'N/A';
						$WhoIs_city			= isset($WhoIs->city) ? $WhoIs->city : 'N/A';
						$WhoIs_countryCode 	= isset($WhoIs->countryCode) ? $WhoIs->countryCode : 'N/A';
						$WhoIs_isp 			= isset($WhoIs->isp) ? $WhoIs->isp : 'N/A';
						$WhoIs_org 			= isset($WhoIs->org) ? $WhoIs->org : 'N/A';
					}

					$HackInfo_Source = "<span style='font-weight: bold;'>$HackInfo_Item_IP</span>\r\n\r\n" .$WhoIs_org ." | " .$WhoIs_country." | " .$WhoIs_city ." | " .$WhoIs_asn;
					
					$Report_Table .= "
						<tr>
							<td style='border: 1px solid #ddd; padding: 8px;'>$HackInfo_Source</td>
							<td style='border: 1px solid #ddd; padding: 8px;'>$HackInfo_Item_Event</td>
							<td style='border: 1px solid #ddd; padding: 8px;'>$HackInfo_Item_Description</td>
							<td style='border: 1px solid #ddd; padding: 8px;'>$HackInfo_Item_TimeStamp</td>
						</tr>
					";					
				}
				
				$Report_Table .= "</tbody></table>";
				
				$HackInfo_SiteName 	= get_bloginfo('name');
				
				$subject = "$HackInfo_SiteName | HackInfo-Digest. (+ $HackInfo_Digest_CountRecords)";
				$admin_email = get_option('admin_email');
				$from = $admin_email;	

				$headers[] = "From: HackInfo-Digest <$from>";
				$headers[] = "Content-Type: text/html";
				$headers[] = "charset=UTF-8";
				
				$to = $HackInfo_Digest_Email;

				$TimeStamp = HackInfo_Get_TimeStamp("Y-m-d H:i");
				
				$message = "HackInfo-Digest $TimeStamp\r\n\r\n";
				$message .= $Report_Table;		

				// формируем HTML контент вместо Text, т.к почему-то нарушается форматирование текста. Переводы строки не работают ((
				$message = wpautop($message);
				HackInfo_Debugger ($message, '$HackInfo_Options', $debug_process, __FUNCTION__, __LINE__);
				
				wp_mail( $to, $subject, $message, $headers );

				// Делаем отметку, что эти Записи отправлены.
				// $Query = "UPDATE $HackInfo_table SET sent = 1 WHERE sent = %d";				
				// $wpdb->query ($wpdb->prepare ($Query, 0) );

				$wpdb -> update ($wpdb->prefix .'hackinfo', array('sent' => 1), array('sent' => 0), array('%d'), array('%d') ); // phpcs:ignore 

				HackInfo_Update_Option ('digest_sent', $TimeStamp); // phpcs:ignore 
				HackInfo_Update_Option ('digest_size', $HackInfo_Digest_CountRecords); // phpcs:ignore 
			}
		}
		
		return true;
	}
	
	/* Debugger. 
	----------------------------------------------------------------- */
	function HackInfo_Debugger ($Content, $Subject = null, $Process = null, $Function = '', $Line = '') {
		if (function_exists( 'WPGear_Debugger' )) {
			$Source = 'HackInfo';
			$TimeStamp = true;
			
			$Parameters = array(
				'source' => $Source,
				'content' => $Content,
				'subject' => esc_html( $Subject ),
				'process' => esc_html( $Process ),
				'function' => esc_html( $Function ),
				'timestamp' => $TimeStamp,
				'line' => esc_html( $Line ),
			);
			
			WPGear_Debugger ($Parameters);
		}
	}	