<?php
/*
 * WPGear. Hack-Info.
 * init.php
 */

	/* Install Plugin. 
		DB. Check of HackInfo Tables exist.
	----------------------------------------------------------------- */	
	function hackinfo_install () {
		HackInfo_Create_Tables();
	}

	/* DB. Create Tables.
	----------------------------------------------------------------- */
	function HackInfo_Create_Tables() {
		$debug_process = 'f_create_tables';
		
		global $HackInfo_db_version;

		HackInfo_Check_Convert_Options();		
		
		$HackInfo_Options = HackInfo_Get_Options();
		HackInfo_Debugger ($HackInfo_Options, '$HackInfo_Options', $debug_process, __FUNCTION__, __LINE__);
		
		$HackInfo_db_version_installed = $HackInfo_Options['db_version'];
				
		if ($HackInfo_db_version_installed != $HackInfo_db_version) {
			// Create hackinfo Table
			
			global $wpdb;			
			$HackInfo_table = $wpdb -> prefix .'hackinfo';
			
			$charset_collate = $wpdb -> get_charset_collate();

			$Query = "
				CREATE TABLE $HackInfo_table (
					id bigint(20) NOT NULL AUTO_INCREMENT,
					date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
					type varchar(12) NOT NULL,
					ip varchar(255) NOT NULL,
					details varchar(255) NOT NULL,
					whois text NOT NULL,
					sent tinyint(1) NOT NULL,
					PRIMARY KEY (id)
				) $charset_collate;";

			require_once (ABSPATH .'wp-admin/includes/upgrade.php');
			dbDelta ($Query);
		
			HackInfo_Update_Option ('db_version', $HackInfo_db_version); // phpcs:ignore 
		}		
	}
	
	/* Convert Options (for versions before v4.20)
	----------------------------------------------------------------- */
	function HackInfo_Check_Convert_Options() {
		$debug_process = 'f_check_convert_options';
		
		$HackInfo_Options = get_option( "hack-info_option", null);
		HackInfo_Debugger ($HackInfo_Options, '$HackInfo_Options', $debug_process, __FUNCTION__, __LINE__);

		if ($HackInfo_Options) {
			// OK. Актуальный Формат. Нет необходимости Конвертации.
		} else {
			// Проверяем наличие следов предыдущих версий.
			$HackInfo_db_version_installed = get_option('hackinfo_db_version', null);
			
			if ($HackInfo_db_version_installed) {
				// Необходимо Конвертировать.
				$admin_email = get_option('admin_email');
				
				$HackInfo_Digest_Enable = get_option('hackinfo_digest_enable', 1);
				$HackInfo_Digest_Email 	= get_option('hackinfo_digest_email', $admin_email);
				$HackInfo_Digest_Timer 	= get_option('hackinfo_digest_timer', 12);					
				$HackInfo_WhoIs_Enable 	= get_option('hackinfo_whois_enable', 1 );
				$HackInfo_Digest_Sent 	= get_option ('hackinfo_digest_sent', 'N/A');
				$HackInfo_Digest_Size 	= get_option ('hackinfo_digest_size', 'N/A');	

				$HackInfo_AdminOnly = 1;
				$HackInfo_Enable = 1;
				$HackInfo_Clearing = 1;
				
				$HackInfo_Options = array(
					'adminonly' => $HackInfo_AdminOnly,
					'enable' => $HackInfo_Enable,
					'clearing' => $HackInfo_Clearing,
					'digest_enable' => $HackInfo_Digest_Enable,
					'digest_email' => $HackInfo_Digest_Email,
					'digest_timer' => $HackInfo_Digest_Timer,
					'digest_sent' => $HackInfo_Digest_Sent,
					'digest_size' => $HackInfo_Digest_Size,
					'whois_enable' => $HackInfo_WhoIs_Enable,
					'db_version' => $HackInfo_db_version_installed,
				);
				
				update_option ('hack-info_option', $HackInfo_Options); // phpcs:ignore 
				
				// Удаляем Опции предыдущих версий.
				delete_option('hackinfo_digest_enable');
				delete_option('hackinfo_digest_email');
				delete_option('hackinfo_digest_timer');
				delete_option('hackinfo_digest_sent');
				delete_option('hackinfo_digest_size');	
				delete_option('hackinfo_whois_enable');
				delete_option('hackinfo_db_version');
		
			} else {
				// Нет следов предыдущих версий.
			}
		}
		
		return true;
	}	