<?php
/*
 * WPGear. 
 * Dismiss Gravity Notices
 * admin.php
 */
 
	/* Admin Console - Styles.
	----------------------------------------------------------------- */	
	add_action ('admin_enqueue_scripts', 'DGN_Action_admin_enqueue_scripts' );
	function DGN_Action_admin_enqueue_scripts ($hook) {
		$screen = get_current_screen();
		$screen_base = $screen -> base;
	
		if ($screen_base == 'dashboard') {
			global $DGN_plugin_url;
			
			wp_enqueue_style ('dgn_admin_style', $DGN_plugin_url .'admin-style.css'); // phpcs:ignore
		}
	}
	
	/* Do Real Dismissed.
	----------------------------------------------------------------- */	
	add_filter ('gravityview/admin/notices', 'DGN_Processing', 999);
	function DGN_Processing ($notices) {
        global $DGN_Notices;

        if ($notices) {
            $i = 0;

            foreach ($notices as $notice) {
				$Notices_Cap    	= $notice['cap'];
				$Notices_Dismiss 	= $notice['dismiss'];
				$Notices_Msg    	= $notice['message'];
				
				$Notices_Title = isset($notice['title']) ? $notice['title'] : $Notices_Cap .': ' .$Notices_Dismiss;

                $DGN_Notices[$i]['title']     = $Notices_Title;
                $DGN_Notices[$i]['message']   = $Notices_Msg;

                $i = $i+1;
            }

            $notices = array();
        }

		return $notices;
	}