<?php
/*
 * WPGear. Notice Interceptor
 * functions.php
 */
 
	// Read Rules. Global.
	function NtcIntrcptr_Get_Rules ($NI_File_AutoHideRules_ChangeTime) {
		global $NI_File_AutoHideRules_Path;
		
		$NI_Rules = array();
		
		if (file_exists($NI_File_AutoHideRules_Path)) {		
			$NI_Rules = file_get_contents($NI_File_AutoHideRules_Path);

			$NI_Rules = NtcIntrcptr_Prepare_Rules ($NI_Rules);

			update_option( 'notice-interceptor_rules', $NI_Rules ); // phpcs:ignore		
			update_option( 'notice-interceptor_autohide', $NI_File_AutoHideRules_ChangeTime ); // phpcs:ignore			
		}	
		
		return $NI_Rules;
	}

	// Prepare Rules
	function NtcIntrcptr_Prepare_Rules ($NI_Rules) {
		$NI_Rules = explode(PHP_EOL, $NI_Rules);

		foreach ( $NI_Rules as $key => &$value ) {
			$value = sanitize_text_field($value);
			$value = preg_replace( '/[^A-Za-z0-9\-_# `~]/', '', $value );

			if ($value) {
				if ( preg_match( "/#/", $value ) ) {
					unset($NI_Rules[$key]);
				}
			} else {
				unset($NI_Rules[$key]);
			}
		}

		$NI_Rules = array_unique ($NI_Rules);
		$NI_Rules = array_values ($NI_Rules); 

		return $NI_Rules;
	}

	/* Function str_contains for PHP < 8
	----------------------------------------------------------------- */	
	if (! function_exists('str_contains')) {
		function str_contains($haystack, $needle) {
			return $needle !== '' && mb_strpos($haystack, $needle) !== false;
		}
	}	
	
	/* Debugger. 
	----------------------------------------------------------------- */
	function NtcIntrcptr_Debugger ($Content, $Subject = null, $Process = null, $Function = '', $Line = '') {
		if (function_exists( 'WPGear_Debugger' )) {
			$Source = 'NtcIntrcptr';
			$Description = 'Plugin: Notice Interceptor';
			
			$TimeStamp = true;
			
			$Parameters = array(
				'source' => $Source,
				'description' => $Description,
				'content' => $Content,
				'subject' => esc_html( $Subject ),
				'process' => esc_html( $Process ),
				'function' => esc_html( $Function ),
				'timestamp' => $TimeStamp,
				'line' => esc_html( $Line ),
			);
			
			WPGear_Debugger ($Parameters);
		}
	}		