<?php
/*
Plugin Name: Notice Interceptor
Plugin URI: https://wpgear.xyz/notice-interceptor/
Description: Tool for creating a comfortable living environment in the Admin area without annoying notifications and ad units.
Version: 5.26
Text Domain: notice-interceptor
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	$NtcIntrcptr_plugin_url = plugin_dir_url( __FILE__ ); 	// со слэшем на конце
	$NtcIntrcptr_plugin_dir = plugin_dir_path( __FILE__ );	// со слэшем на конце

	$NtcIntrcptr_Rules = array();
		
	$NI_File_AutoHideRules_Path = $NtcIntrcptr_plugin_dir  .'includes/autohide.txt';
	$NI_File_AutoHideCSS_Path 	= ABSPATH .'notice_autohide.css';	
	
	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/admin.php' );
	
	$NtcIntrcptr_LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';
	// __('Tool for creating a comfortable living environment in the Admin area without annoying notifications and ad units.', 'notice-interceptor');	

	/* Translate.
	----------------------------------------------------------------- */
	add_action ('init', 'NtcIntrcptr_Action_init');
	function NtcIntrcptr_Action_init() {
		global $NtcIntrcptr_LocalePath;
				
		$Result = load_plugin_textdomain ('notice-interceptor', false, $NtcIntrcptr_LocalePath);
	}	
	
	/* Admin Console - Styles.
	----------------------------------------------------------------- */
	add_action ('admin_enqueue_scripts', 'NtcIntrcptr_admin_style', 999999);	
	function NtcIntrcptr_admin_style ($hook) {
		global $NtcIntrcptr_plugin_url;		
		global $NtcIntrcptr_plugin_dir;
		global $NI_File_AutoHideCSS_Path;
	
		// Styles: Admin
		$NI_Style_URL = $NtcIntrcptr_plugin_url .'admin-style.css';
		
		wp_register_style ('notice_interceptor', $NI_Style_URL, false); // phpcs:ignore
		wp_enqueue_style ('notice_interceptor'); // phpcs:ignore
		
		// Styles: AutoHide
		if (file_exists ($NI_File_AutoHideCSS_Path)) {
			$Site_URL = get_site_url();
			
			$NI_Style_AutoHide_URL = $Site_URL .'/notice_autohide.css';

			wp_register_style ('notice_interceptor_autohide', $NI_Style_AutoHide_URL, false); // phpcs:ignore
			wp_enqueue_style ('notice_interceptor_autohide'); // phpcs:ignore	
		}	

		// Script
		$NI_Script_URL = $NtcIntrcptr_plugin_url .'includes/notice-interceptor.js';			
		wp_enqueue_script ('notice_interceptor', $NI_Script_URL, array()); // phpcs:ignore
	}

	if (file_exists($NI_File_AutoHideRules_Path)) {
		// Get Rules. Global.
		$NI_File_AutoHideRules_Stat = stat($NI_File_AutoHideRules_Path);		
		$NI_File_AutoHideRules_ChangeTime = $NI_File_AutoHideRules_Stat["mtime"];
		
		$NI_File_AutoHideRules_LasTime = get_option('notice-interceptor_autohide', false);

		if ($NI_File_AutoHideRules_LasTime) {
			// Check Updates.
			if ($NI_File_AutoHideRules_LasTime == $NI_File_AutoHideRules_ChangeTime) {
				// Get Rules.
				$NtcIntrcptr_Rules = get_option('notice-interceptor_rules', array());				
			} else {
				// Update Rules. 
				$NtcIntrcptr_Rules = NtcIntrcptr_Get_Rules ($NI_File_AutoHideRules_ChangeTime);				
			}
		} else {
			// Load Rules default.
			$NtcIntrcptr_Rules = NtcIntrcptr_Get_Rules ($NI_File_AutoHideRules_ChangeTime);
		}
	}
	
	// Get Rules. Customs.
	$NI_Custom_Rules = get_option('notice-interceptor_rules_custom', array());
		
	// Merge Rules. Global + Customs.
	if ($NtcIntrcptr_Rules) {
		if ($NI_Custom_Rules) {
			$NtcIntrcptr_Rules = array_merge ($NtcIntrcptr_Rules, $NI_Custom_Rules);
			$NtcIntrcptr_Rules = array_unique ($NtcIntrcptr_Rules);
		}
	} else {
		if ($NI_Custom_Rules) {
			$NtcIntrcptr_Rules = $NI_Custom_Rules;
		}		
	}
	
	$NtcIntrcptr_Rules = array_values ($NtcIntrcptr_Rules);

	/* AJAX Processing
	----------------------------------------------------------------- */
    add_action( 'wp_ajax_ntcintrcptr', 'NtcIntrcptr_Ajax' );
    function NtcIntrcptr_Ajax(){
		include_once ('includes/ajax_notice.php');
    }	