<?php
/*
 * WPGear. Users Login Monitor
 * uninstall.php
 */

	// if uninstall.php is not called by WordPress, die
	if (!defined('WP_UNINSTALL_PLUGIN')) {
		die;
	}
	
	if (!function_exists ('UsersLoginMonitor_Check_Plugin_Installed')) {
		include_once(__DIR__ .'/includes/functions.php');
	}	

	$UsersLoginMonitor_Clearing = UsersLoginMonitor_Get_Options('clearing');
	
	if ($UsersLoginMonitor_Clearing) {
		// Очистка
		if (UsersLoginMonitor_Check_Plugin_Installed ('users-login-monitor-pro')) {
			// Нельзя удалять некоторые Общие Настройки, т.к. имеется Плагин "users-login-monitor-pro"
		} else {	
			// Удаляем настройки Плагина
			delete_option('users-login-monitor_options');
			
			// Удаляем Триггеры Плагина
			delete_option('ulm_digest_date');
			delete_option('ulm_digest_size');
			
			// Удаляем метаполя Плагина у всех Пользователей
			global $wpdb;
			$ulm_usermeta_table = $wpdb -> prefix .'usermeta';
			$Query = "DELETE FROM $ulm_usermeta_table WHERE meta_key IN ('ulm_browser', 'ulm_lastlogin', 'ulm_triger', 'ulm_user_ip')";
			
			$wpdb -> query($Query); // phpcs:ignore 
		}
	}