<?php
/*
 * WPGear. 
 * Hack-Info
 * options.php
 */
 
	$HackInfo_Debug_Process = 'options';	
	
    if (!current_user_can('edit_dashboard')) {
        return;
    }
	
	$HackInfo_NonceKey = 'Update_Options_Hack-Info';
	$HackInfo_Nonce = wp_create_nonce ($HackInfo_NonceKey);
	
	$HackInfo_Options = HackInfo_Get_Options ();
	HackInfo_Debugger ($HackInfo_Options, '$HackInfo_Options', $HackInfo_Debug_Process, __FUNCTION__, __LINE__);
	
	$HackInfo_Digest_Sent	= $HackInfo_Options['digest_sent'];
	$HackInfo_Digest_Size	= $HackInfo_Options['digest_size'];
	
	$HackInfo_Digest_Log = __('Digest Sent:', 'hack-info') ." $HackInfo_Digest_Sent | ". __('Records: ', 'hack-info') ." $HackInfo_Digest_Size";
	
	$HackInfo_Digest_Email_Error = false;
	
	$HackInfo_Action = isset($_REQUEST['action']) ? sanitize_text_field (wp_unslash($_REQUEST['action'])) : null;

	if ($HackInfo_Action == 'Update') { 		
		$HackInfo_NonceRequest = isset($_REQUEST['_wpnonce']) ? sanitize_text_field (wp_unslash($_REQUEST['_wpnonce'])) : 'none';
		
		$HackInfo_Option_AdminOnlyNew 		= isset($_REQUEST['hackinfo_option_adminonly']) ? 1 : 0;	
		$HackInfo_Option_EnableNew 			= isset($_REQUEST['hackinfo_option_enable']) ? 1 : 0;	
		$HackInfo_Option_ClearingNew 		= isset($_REQUEST['hackinfo_option_clearing']) ? 1 : 0;
		$HackInfo_Option_DigestEnableNew 	= isset($_REQUEST['hackinfo_option_digest_enable']) ? 1 : 0;
		$HackInfo_Option_DigestEmailNew 	= (isset($_REQUEST['hackinfo_option_digest_email']) && $_REQUEST['hackinfo_option_digest_email'] != '') ? sanitize_email (wp_unslash($_REQUEST['hackinfo_option_digest_email'])) : get_option('admin_email');			
		$HackInfo_Option_DigestTimerNew 	= isset($_REQUEST['hackinfo_option_digest_timer']) ? sanitize_text_field (wp_unslash($_REQUEST['hackinfo_option_digest_timer'])) : 12;
		$HackInfo_Option_WhoIsEnableNew 	= isset($_REQUEST['hackinfo_option_whois_enable']) ? 1 : 0;
		
		HackInfo_Debugger ($_REQUEST, '$_REQUEST', $HackInfo_Debug_Process, __FUNCTION__, __LINE__); // phpcs:ignore 
		
		if (!wp_verify_nonce($HackInfo_NonceRequest, $HackInfo_NonceKey)) {
			?>
				<div class="wrap">
					<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
					<hr>
					<div class="hackinfo_options_box">						
						<?php echo esc_html( __('Warning! Data Incorrect. Update Disable.', 'hack-info') ); ?>
					</div>
				</div>
			<?php
			
			exit;
		}		

		if (! filter_var($HackInfo_Option_DigestEmailNew, FILTER_VALIDATE_EMAIL)) {
			$HackInfo_Digest_Email_Error = "! Invalid Email.";
		}
		
		if (! is_numeric($HackInfo_Option_DigestTimerNew)) {
			$HackInfo_Option_DigestTimerNew = 12; // Set Default.
		}
		
		if (! $HackInfo_Digest_Email_Error) {
			$HackInfo_Options = array(
				'adminonly' => $HackInfo_Option_AdminOnlyNew,
				'enable' => $HackInfo_Option_EnableNew,
				'clearing' => $HackInfo_Option_ClearingNew,
				'digest_enable' => $HackInfo_Option_DigestEnableNew,
				'digest_email' => $HackInfo_Option_DigestEmailNew,
				'digest_timer' => $HackInfo_Option_DigestTimerNew,
				'digest_sent' => $HackInfo_Options['digest_sent'],
				'digest_size' => $HackInfo_Options['digest_size'],
				'whois_enable' => $HackInfo_Option_WhoIsEnableNew,
				'db_version' => $HackInfo_Options['db_version'],
			);
			
			HackInfo_Debugger ($HackInfo_Options, 'Update $HackInfo_Options', $HackInfo_Debug_Process, __FUNCTION__, __LINE__);
			update_option ('hack-info_option', $HackInfo_Options); // phpcs:ignore 
		}
	}

	$HackInfo_AdminOnly		= $HackInfo_Options['adminonly'];
	$HackInfo_Enable 		= $HackInfo_Options['enable'];
	$HackInfo_Clearing 		= $HackInfo_Options['clearing'];
	$HackInfo_Digest_Enable = $HackInfo_Options['digest_enable'];
	$HackInfo_Digest_Email 	= $HackInfo_Options['digest_email'];
	$HackInfo_Digest_Timer	= $HackInfo_Options['digest_timer'];	
	$HackInfo_WhoIs_Enable 	= $HackInfo_Options['whois_enable'];
		
?>
	<div class="wrap">
		<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
		<hr>	
		
		<div class="hackinfo_options_box">
			<form name="form_hackinfo_Options" method="post" style="margin-top: 20px;">	
				<h3><?php echo esc_html( __('General', 'hack-info') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="hackinfo_options_field_label">
									<label for="hackinfo_option_adminonly">
										<?php echo esc_html( __('Enable this Page for Admin only', 'hack-info') ); ?>
									</label>
								</th>
								<td class="adaptive_login_action_options_field_input">
									<input id="hackinfo_option_adminonly" name="hackinfo_option_adminonly" type="checkbox" <?php if($HackInfo_AdminOnly) {echo 'checked';} ?>>
									<span class="hackinfo_options_field_description">
										<?php echo esc_html( __('On/Off', 'hack-info') ); ?>
									</span>
								</td>
							</tr>

							<tr>
								<th scope="row" class="hackinfo_options_field_label">
									<label for="hackinfo_option_enable">
										<?php echo esc_html( __('Enable Hack-Info', 'hack-info') ); ?>
									</label>
								</th>
								<td class="adaptive_login_action_options_field_input">
									<input id="hackinfo_option_enable" name="hackinfo_option_enable" type="checkbox" <?php if($HackInfo_Enable) {echo 'checked';} ?>>
									<span class="hackinfo_options_field_description">
										<?php echo esc_html( __('On/Off', 'hack-info') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				
				<hr>
					
				<h3><?php echo esc_html( __('IP Controls', 'hack-info') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>							
							<tr>
								<th scope="row" class="hackinfo_options_field_label">
									<label for="hackinfo_option_whois_enable">
										<?php echo esc_html( __('WhoIs IP:', 'hack-info') ); ?>
									</label>
								</th>
								<td class="hackinfo_options_field_input">
									<input id="hackinfo_option_whois_enable" name="hackinfo_option_whois_enable" type="checkbox" <?php if($HackInfo_WhoIs_Enable) {echo 'checked';} ?>>
									<span class="hackinfo_options_field_description">
										<?php echo esc_html( __('Obtaining information about the owner of IP. On/Off', 'hack-info') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Digest notifications', 'hack-info') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="hackinfo_options_field_label">
									<label for="hackinfo_option_digest_enable">
										<?php echo esc_html( __('Digest notifications:', 'hack-info') ); ?>
									</label>
								</th>
								<td class="hackinfo_options_field_input">
									<input id="hackinfo_option_digest_enable" name="hackinfo_option_digest_enable" type="checkbox" <?php if($HackInfo_Digest_Enable) {echo 'checked';} ?>>
									<span class="hackinfo_options_field_description">
										<?php echo esc_html( __('On/Off', 'hack-info') ); ?>
									</span>
								</td>
							</tr>	
							<tr>
								<th scope="row" class="hackinfo_options_field_label">
									<label for="hackinfo_option_digest_email" <?php if(!$HackInfo_Digest_Enable) {echo 'style="color: darkgrey;"';} ?>>
										<?php echo esc_html( __('E-mail for digest notifications:', 'hack-info') ); ?>
									</label>
								</th>
								<td class="hackinfo_options_field_input">
									<input id="hackinfo_option_digest_email" name="hackinfo_option_digest_email" type="text" value="<?php echo esc_attr($HackInfo_Digest_Email); ?>">
									<span class="hackinfo_options_field_description">
										<?php echo esc_html( __('Who will receive notifications?', 'hack-info') ); ?>
									</span>
									<div id="hackinfo_option_digest_email_note" style="color: red;"><?php if($HackInfo_Digest_Email_Error) {echo esc_attr($HackInfo_Digest_Email_Error);} ?></div>
								</td>
							</tr>	
							<tr>
								<th scope="row" class="hackinfo_options_field_label">
									<label for="hackinfo_option_digest_timer" <?php if(!$HackInfo_Digest_Enable) {echo 'style="color: darkgrey;"';} ?>>
										<?php echo esc_html( __('Digest notifications period:', 'hack-info') ); ?>
									</label>
								</th>
								<td class="hackinfo_options_field_input">
									<input id="hackinfo_option_digest_timer" name="hackinfo_option_digest_timer" type="text" style="width: 40px; text-align: center;" value="<?php echo esc_attr($HackInfo_Digest_Timer); ?>">
									<span class="hackinfo_options_field_description">
										<?php echo esc_html( __('How often should notifications be sent. (Hour)', 'hack-info') ); ?>
									</span>
								</td>
							</tr>	
						</tbody>
					</table>
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Clearing', 'hack-info') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="hackinfo_options_field_label">
									<label for="hackinfo_option_clearing">
										<?php echo esc_html( __('Delete MetaData with Uninstall Plugin.', 'hack-info') ); ?>
									</label>
								</th>
								<td class="adaptive_login_action_options_field_input">
									<input id="hackinfo_option_clearing" name="hackinfo_option_clearing" type="checkbox" <?php if($HackInfo_Clearing) {echo 'checked';} ?>>
									<span class="hackinfo_options_field_description">
										<?php echo esc_html( __('On/Off', 'hack-info') ); ?>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				
				<hr>
				
				<h3><?php echo esc_html( __('Report', 'hack-info') ); ?></h3>
				<div style="margin-left: 20px; margin-bottom: 10px;">
					<table class="form-table">
						<tbody>
							<tr>
								<th scope="row" class="hackinfo_options_field_label">
									<i class="fa fa-check" aria-hidden="true"></i>
									<span style="margin-right: 10px; color: black;">
										<?php echo esc_html( __('Operating:', 'hack-info') ); ?>
									</span>
								</th>
								<td class="hackinfo_options_field_input">
									<?php echo esc_html( $HackInfo_Digest_Log ); ?>
								</td>
							</tr>
						</tbody>
					</table>
				</div>	
				
				<hr>				

				<div style="margin-top: 10px; margin-bottom: 5px; text-align: right;">
					<span id="save_options_processing" style="display: none; margin-right: 5px;">
						<i class="fa fa-refresh fa-spin fa-fw fa-2x" aria-hidden="true" style="vertical-align: baseline;"></i>
					</span>
					<input id="btn_options_save" type="submit" class="button button-primary" style="margin-right: 5px;" value="<?php echo esc_html( __('Save', 'hack-info') ); ?>">
				</div>
				<input id="action" name="action" type="hidden" value="Update">
				<input id="_wpnonce" name="_wpnonce" type="hidden" value="<?php echo esc_attr($HackInfo_Nonce); ?>">
				
			</form>
		</div>		
	</div>	