<?php
/*
 * WPGear. 
 * WPGear – Consent Privacy Policy Acceptance
 * functions.php
 */
 
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly
	}
	
	/* Get_Options / Option
	----------------------------------------------------------------- */ 	
	function WPGearCPPA_Get_Options( $Option = null ) {
		$Options = get_option( "wpgear-consent-privacy-policy-acceptance_option", array(
			'adminonly' => 1,
			'enable' => 1,
			'clearing' => 1,
			'message' => 'By continuing to use this Site, I agree to the processing of personal data in accordance with the Privacy Policy',
			'button_accept' => 'I agree',
			)
		);		
		
		$OptionAdminOnly 		= isset( $Options['adminonly'] ) ? $Options['adminonly'] : 1;
		$OptionEnable 		= isset( $Options['enable'] ) ? $Options['enable'] : 1;
		$OptionClearing 		= isset( $Options['clearing'] ) ? $Options['clearing'] : 1;
		$OptionMessage 		= isset( $Options['message'] ) ? $Options['message'] : '';
		$OptionButtonAccept	= isset( $Options['button_accept'] ) ? $Options['button_accept'] : '';
		
		$Options = array(
			'adminonly' => $OptionAdminOnly,
			'enable' => $OptionEnable,
			'clearing' => $OptionClearing,
			'message' => $OptionMessage,
			'button_accept' => $OptionButtonAccept,
		);
		
		if ($Option) {
			return $Options[$Option];
		}

		return $Options;
	}
	
